// iSeries Access definition unit for Delphi
// Version 2.0.46
// versions of iSeries Access until V5R3
//
// written and translated
// 2001-2003 by Peter Sawatzki <Peter@Sawatzki.de>
//
// - not for redistribution -
//
// usage of this source is governed by a separate SOURCE CODE LICENSE AGREEMENT
// available from Peter@Sawatzki.de
// you are not permitted to use this source before signing the license agreement
//
// converted yet: cwb.h, cwbdb.h, cwbobj.h, cwbco.h, cwbso*.h, cwbsys.h, cwbrc.h
//
//
Unit ClientAccess;
Interface
Uses
  Windows, SysUtils;
Const
  cwbV3R2 = 320;
  cwbV4R3 = 430;
  cwbV4R4 = 440;
  cwbV4R5 = 450;
  cwbV5R1 = 510;
  cwbV5R2 = 520;
  cwbV5R3 = 530;

{$MINENUMSIZE 4}

Type
  cwb_Result               = Cardinal;
  cwb_Boolean              = Cardinal;
  cwb_Handle               = THandle;
  cwbDB_RequestHandle      = THandle;
  cwbDB_ConnectionHandle   = THandle;
  cwbDB_DataHandle         = THandle;
  cwbDB_FormatHandle       = THandle;
  cwbNL_Converter          = THandle;
  cwbNL_Conversion_Table   = THandle;
  cwbSV_ErrHandle          = THandle;
  cwbSY_SecurityHandle     = THandle;
  cwbOBJ_ParmHandle        = THandle;      // parameter list handle
  cwbOBJ_ObjHandle         = THandle;      // object handle
  cwbOBJ_ListHandle        = THandle;      // list handle
  cwbOBJ_KeyID             = Cardinal;
  cwbOBJ_DataType          = Cardinal;
  cwbOBJ_ListType          = Cardinal;
  cwbOBJ_ObjType           = Cardinal;
  cwbOBJ_AFPResourceType   = Cardinal;
  cwbOBJ_List_OpenType     = Cardinal;
  cwbOBJ_List_Status       = Cardinal;
  cwbOBJ_SeekOrigin        = Cardinal;
  cwbOBJ_SplFDataType      = Cardinal;
  cwbCO_SysHandle          = THandle;
  cwbCO_Service            = Cardinal;
  cwbCO_PromptMode         = Cardinal;
  cwbCO_ValidateMode       = Cardinal;
  cwbCO_DefaultUserMode    = Cardinal;
  cwbCO_IPAddressLookupMode= Cardinal;
  cwbCO_PortLookupMode     = Cardinal;
  cwbCO_PersistenceMode    = Cardinal;
  cwbSO_ErrHandle          = THandle;
  cwbSO_ListHandle         = THandle;
  cwbSO_ObjHandle          = THandle;
  cwbSO_ParmObjHandle      = THandle;
  cwbSO_Err_Handle         = cwbSO_ErrHandle;
  cwbSO_List_Handle        = cwbSO_ListHandle;
  cwbSO_Obj_Handle         = cwbSO_ObjHandle;
  cwbSO_ParmObj_Handle     = cwbSO_ParmObjHandle;
  cwbRC_SysHandle          = THandle;
  cwbRC_PgmHandle          = THandle;

  TCustomcwbErrorHandler = Class
  Private
    FRaiseWarnings: Boolean;
  Protected
    Function IsSerious (Index: Integer; Value: cwb_Result): Boolean; Virtual; Abstract;
    Function ReturnErrTexts(Value: cwb_Result; Context: String=''): String; Virtual; Abstract;
    Function Check (Index: Integer; Value: cwb_Result; Where: Pointer = Nil): cwb_Result; Virtual;
  Public
    Property RaiseWarnings: Boolean Read FRaiseWarnings Write FRaiseWarnings;
  End;

  TcwbErrorHandler = Class(TCustomcwbErrorHandler)
  Private
    FErrHandle: cwbSV_ErrHandle;
  Protected
    Function IsSerious (Index: Integer; Value: cwb_Result): Boolean; Override;
    Function ReturnErrTexts(Value: cwb_Result; Context: String=''): String; Override;
  Public
    Constructor Create;
    Destructor Destroy; Override;
    Property ErrHandle: cwbSV_ErrHandle Read FErrHandle Write FErrHandle;
  End;

  TcwbDBErrorHandler = Class(TcwbErrorHandler)
  Private
    FhostMsgId: cwbDB_DataHandle;
    FfirstLevelMessage: cwbDB_DataHandle;
    FsecondLevelMessage: cwbDB_DataHandle;
    FhostErrorClass: Word;
    FhostErrorCode: Integer;
    FrequestHandle: cwbDB_RequestHandle;
  Protected
    Function IsSerious (Index: Integer; Value: cwb_Result): Boolean; Override;
    Function ReturnErrTexts(Value: cwb_Result; Context: String=''): String; Override;
  Public
    Constructor Create (ARequestHandle: cwbDB_RequestHandle = 0);
    Destructor Destroy; Override;
    Property HostMsgID: cwbDB_DataHandle Read FhostMsgId Write FHostMsgId;
    Property FirstLevelMessage: cwbDB_DataHandle Read FfirstLevelMessage Write FfirstLevelMessage;
    Property SecondLevelMessage: cwbDB_DataHandle Read FsecondLevelMessage Write FsecondLevelMessage;
    Property hostErrorCode: Integer Read FhostErrorCode;
    Property hostErrorClass: Word Read FhostErrorClass;
  End;

  TcwbSOErrorHandler = Class(TCustomcwbErrorHandler)
  Private
    FErrHandle: cwbSO_ErrHandle;
  Protected
    Function IsSerious (Index: Integer; Value: cwb_Result): Boolean; Override;
    Function ReturnErrTexts(Value: cwb_Result; Context: String=''): String; Override;
  Public
    Constructor Create;
    Destructor Destroy; Override;
    Property ErrHandle: cwbSO_ErrHandle Read FErrHandle Write FErrHandle;
  End;

  // our Error handling via Exceptions
  EcwbError = class(Exception)
  Private
    FErrorCode: cwb_Result;
    FFuncIndex: Integer;
  Public
    Constructor Create(ANativeError: String; AErrorCode: cwb_Result; AFuncIndex: Integer);
    Property ErrorCode: cwb_Result read FErrorCode;
    Property FuncIndex: Integer Read FFuncIndex;
  end;

Type
  cwbDB_SQLCA = Record
   sqlcaid: Array[0..7] Of Char;    // Eyecatcher = 'SQLCA   '
   sqlcabc: Integer;                // SQLCA size in bytes = 136
   sqlcode: Integer;                // SQL return code
   sqlerrml: SmallInt;              // Length for SQLERRMC
   sqlerrmc: Array[0..69] Of Byte;  // Error message tokens
   sqlerrp: Array[0..7] Of Byte;    // Diagnostic information
   sqlerrd: Array[0..5] Of Integer; // Diagnostic information
   sqlwarn: Array[0..10] Of Byte;   // Warning flags
   sqlext: Array[0..4] Of Byte;     // Reserved
  End;

  // structure used as input to the cwbOBJ_GetObjAttrs() API
  cwbOBJ_GetObjAttrParms = Packed Record // aligned on a byte boundary
    key: cwbOBJ_KeyID;
    buffer: Pointer;
    bufLen: Cardinal
  End;

  cwb_DateTime = Packed Record
    year: Word;
    Month, Day, Hour, Minute, Second, mseconds: Byte;
  End;

Const
  CA400_MAXCURNAME = 19;    // max cursor name len = 18 plus null char
  CA400_MAXSQLNAME = 19;    // max statement name len = 18 plus null char
  CA400_MAXSQLTEXT = 32766; // max sql statement text len = 32765 plus null char
  CA400_MAXPARAMNAME = 64;
  CA400_MAXCOLUMNNAME = 30;
  CA400_MAXCOLTYPE = 64;

  CWB_FALSE = 0;
  CWB_TRUE = 1;
  CWBBOOLVAL: Array[Boolean] Of Cardinal = (CWB_FALSE, CWB_TRUE);

// Client Access/400 return codes fall into the following
// categories:
// - Global return codes corresponding to operating system errors
// - Global return codes unique to Client Access/400
// - Specific return codes for each Client Access/400 function
//
// The global return codes are defined in this file.  The function
// specific return codes are defined in the function specific
// header files.

// Global return codes corresponding to operating system errors

  CWB_OK                       =   0;
  CWB_INVALID_FUNCTION         =   1;
  CWB_FILE_NOT_FOUND           =   2;
  CWB_PATH_NOT_FOUND           =   3;
  CWB_TOO_MANY_OPEN_FILES      =   4;
  CWB_ACCESS_DENIED            =   5;
  CWB_INVALID_HANDLE           =   6;
  CWB_NOT_ENOUGH_MEMORY        =   8;
  CWB_INVALID_DRIVE            =  15;
  CWB_NO_MORE_FILES            =  18;
  CWB_DRIVE_NOT_READY          =  21;
  CWB_GENERAL_FAILURE          =  31;
  CWB_SHARING_VIOLATION        =  32;
  CWB_LOCK_VIOLATION           =  33;
  CWB_END_OF_FILE              =  38;
  CWB_NOT_SUPPORTED            =  50;
  CWB_BAD_NETWORK_PATH         =  53;
  CWB_NETWORK_BUSY             =  54;
  CWB_DEVICE_NOT_EXIST         =  55;
  CWB_UNEXPECTED_NETWORK_ERROR =  59;
  CWB_NETWORK_ACCESS_DENIED    =  65;
  CWB_FILE_EXISTS              =  80;
  CWB_ALREADY_ASSIGNED         =  85;
  CWB_INVALID_PARAMETER        =  87;
  CWB_NETWORK_WRITE_FAULT      =  88;
  CWB_OPEN_FAILED              = 110;
  CWB_BUFFER_OVERFLOW          = 111;
  CWB_DISK_FULL                = 112;
  CWB_PROTECTION_VIOLATION     = 115;
  CWB_INVALID_LEVEL            = 124;
  CWB_BUSY_DRIVE               = 142;
  CWB_INVALID_FSD_NAME         = 252;
  CWB_INVALID_PATH             = 253;

// Global return codes unique to Client Access/400
  CWB_START   = 4000;
  CWB_LAST    = 5999;

  CWB_USER_CANCELLED_COMMAND         =  (CWB_START);
  CWB_CONFIG_ERROR                   =  (CWB_START+1);
  CWB_LICENSE_ERROR                  =  (CWB_START+2);
  CWB_PROD_OR_COMP_NOT_SET           =  (CWB_START+3);
  CWB_SECURITY_ERROR                 =  (CWB_START+4);
  CWB_GLOBAL_CFG_FAILED              =  (CWB_START+5);
  CWB_PROD_RETRIEVE_FAILED           =  (CWB_START+6);
  CWB_COMP_RETRIEVE_FAILED           =  (CWB_START+7);
  CWB_COMP_CFG_FAILED                =  (CWB_START+8);
  CWB_COMP_FIX_LEVEL_UPDATE_FAILED   =  (CWB_START+9);
  CWB_INVALID_API_HANDLE             =  (CWB_START+10);
  CWB_INVALID_API_PARAMETER          =  (CWB_START+11);
  CWB_HOST_NOT_FOUND                 =  (CWB_START+12);
  CWB_NOT_COMPATIBLE                 =  (CWB_START+13);
  CWB_INVALID_POINTER                =  (CWB_START+14);
  CWB_SERVER_PROGRAM_NOT_FOUND       =  (CWB_START+15);
  CWB_API_ERROR                      =  (CWB_START+16);
  CWB_CA_NOT_STARTED                 =  (CWB_START+17);
  CWB_FILE_IO_ERROR                  =  (CWB_START+18);
  CWB_COMMUNICATIONS_ERROR           =  (CWB_START+19);
  CWB_RUNTIME_CONSTRUCTOR_FAILED     =  (CWB_START+20);
  CWB_DIAGNOSTIC                     =  (CWB_START+21);
  CWB_COMM_VERSION_ERROR             =  (CWB_START+22);
  CWB_NO_VIEWER                      =  (CWB_START+23);
  CWB_MODULE_NOT_LOADABLE            =  (CWB_START+24);
  CWB_ALREADY_SETUP                  =  (CWB_START+25);
  CWB_CANNOT_START_PROCESS           =  (CWB_START+26);
  CWB_NON_REPRESENTABLE_UNICODE_CHAR =  (CWB_START+27);
  CWB_ENTRY_NOT_FOUND                =  (CWB_START+28);


// Global return codes unique to Client Access/400 that are new
//   as of first release of Client Access Express, start at 8000
  CWB_EXPRESSBASE                    =  (8000);

//  Security Errors  (8000 - 8299)

  CWB_EXPRESS_SEC_BASE               =  (CWB_EXPRESSBASE);
  CWB_EXPRESS_SEC_END                =  (CWB_EXPRESS_SEC_BASE+299);

  CWB_UNKNOWN_USERID                 =  (CWB_EXPRESS_SEC_BASE+1);
  CWB_WRONG_PASSWORD                 =  (CWB_EXPRESS_SEC_BASE+2);
  CWB_PASSWORD_EXPIRED               =  (CWB_EXPRESS_SEC_BASE+3);
  CWB_INVALID_PASSWORD               =  (CWB_EXPRESS_SEC_BASE+4);
  CWB_PASSWORD_TO_EXPIRE             =  (CWB_EXPRESS_SEC_BASE+5);
  CWB_INCORRECT_DATA_FORMAT          =  (CWB_EXPRESS_SEC_BASE+6);
  CWB_GENERAL_SECURITY_ERROR         =  (CWB_EXPRESS_SEC_BASE+7);
  CWB_USER_PROFILE_DISABLED          =  (CWB_EXPRESS_SEC_BASE+11);
  CWB_USER_CANCELLED                 =  (CWB_EXPRESS_SEC_BASE+13);
  CWB_INVALID_SYSNAME                =  (CWB_EXPRESS_SEC_BASE+14);
  CWB_INVALID_USERID                 =  (CWB_EXPRESS_SEC_BASE+15);
  CWB_LIMITED_CAPABILITIES_USERID    =  (CWB_EXPRESS_SEC_BASE+16);
  CWB_WINDOWS_USERID_NOT_FOUND       =  (CWB_EXPRESS_SEC_BASE+17);
  CWB_WINDOWS_PASSWORD_NOT_FOUND     =  (CWB_EXPRESS_SEC_BASE+18);
  CWB_INVALID_TP_ON_HOST             =  (CWB_EXPRESS_SEC_BASE+19);
  CWB_NOT_LOGGED_ON                  =  (CWB_EXPRESS_SEC_BASE+22);
  CWB_EXIT_PGM_ERROR                 =  (CWB_EXPRESS_SEC_BASE+26);
  CWB_EXIT_PGM_DENIED_REQUEST        =  (CWB_EXPRESS_SEC_BASE+27);
  CWB_TIMESTAMPS_NOT_SET             =  (CWB_EXPRESS_SEC_BASE+50);
  CWB_KERB_CLIENT_CREDENTIALS_NOT_FOUND=(CWB_EXPRESS_SEC_BASE+51);
  CWB_KERB_SERVICE_TICKET_NOT_FOUND  =  (CWB_EXPRESS_SEC_BASE+52);
  CWB_KERB_SERVER_CANNOT_BE_CONTACTED=  (CWB_EXPRESS_SEC_BASE+53);
  CWB_KERB_UNSUPPORTED_BY_HOST       =  (CWB_EXPRESS_SEC_BASE+54);
  CWB_KERB_NOT_AVAILABLE             =  (CWB_EXPRESS_SEC_BASE+55);
  CWB_KERB_SERVER_NOT_CONFIGURED     =  (CWB_EXPRESS_SEC_BASE+56);
  CWB_KERB_CREDENTIALS_NOT_VALID     =  (CWB_EXPRESS_SEC_BASE+57);
  CWB_KERB_MAPPED_USERID_FAILURE     =  (CWB_EXPRESS_SEC_BASE+58);
  CWB_KERB_MAPPED_USERID_SUCCESS     =  (CWB_EXPRESS_SEC_BASE+59);
  CWB_PROFILE_TOKEN_INVALID          =  (CWB_EXPRESS_SEC_BASE+70);
  CWB_PROFILE_TOKEN_MAXIMUM          =  (CWB_EXPRESS_SEC_BASE+71);
  CWB_PROFILE_TOKEN_NOT_REGENERABLE  =  (CWB_EXPRESS_SEC_BASE+72);
  CWB_PW_TOO_LONG                    =  (CWB_EXPRESS_SEC_BASE+257);
  CWB_PW_TOO_SHORT                   =  (CWB_EXPRESS_SEC_BASE+258);
  CWB_PW_REPEAT_CHARACTER            =  (CWB_EXPRESS_SEC_BASE+259);
  CWB_PW_ADJACENT_DIGITS             =  (CWB_EXPRESS_SEC_BASE+260);
  CWB_PW_CONSECUTIVE_CHARS           =  (CWB_EXPRESS_SEC_BASE+261);
  CWB_PW_PREVIOUSLY_USED             =  (CWB_EXPRESS_SEC_BASE+262);
  CWB_PW_DISALLOWED_CHAR             =  (CWB_EXPRESS_SEC_BASE+263);
  CWB_PW_NEED_NUMERIC                =  (CWB_EXPRESS_SEC_BASE+264);
  CWB_PW_MATCHES_OLD                 =  (CWB_EXPRESS_SEC_BASE+266);
  CWB_PW_NOT_ALLOWED                 =  (CWB_EXPRESS_SEC_BASE+267);
  CWB_PW_CONTAINS_USERID             =  (CWB_EXPRESS_SEC_BASE+268);
  CWB_PW_LAST_INVALID_PWD            =  (CWB_EXPRESS_SEC_BASE+270);
  CWB_PW_STAR_NONE                   =  (CWB_EXPRESS_SEC_BASE+271);
  CWB_PW_QPWDVLDPGM                  =  (CWB_EXPRESS_SEC_BASE+272);

// Communications Errors (8400 - 8499)

  CWB_EXPRESS_COMM_BASE              =  (CWB_EXPRESSBASE+400);
  CWB_EXPRESS_COMM_END               =  (CWB_EXPRESS_COMM_BASE+99);

  CWB_INV_AFTER_SIGNON               =  (CWB_EXPRESS_COMM_BASE);
  CWB_INV_WHEN_CONNECTED             =  (CWB_EXPRESS_COMM_BASE+1);
  CWB_INV_BEFORE_VALIDATE            =  (CWB_EXPRESS_COMM_BASE+2);
  CWB_SECURE_SOCKETS_NOTAVAIL        =  (CWB_EXPRESS_COMM_BASE+3);
  CWB_RESERVED1                      =  (CWB_EXPRESS_COMM_BASE+4);
  CWB_RECEIVE_ERROR                  =  (CWB_EXPRESS_COMM_BASE+5);
  CWB_SERVICE_NAME_ERROR             =  (CWB_EXPRESS_COMM_BASE+6);
  CWB_GETPORT_ERROR                  =  (CWB_EXPRESS_COMM_BASE+7);
  CWB_SUCCESS_WARNING                =  (CWB_EXPRESS_COMM_BASE+8);
  CWB_NOT_CONNECTED                  =  (CWB_EXPRESS_COMM_BASE+9);
  CWB_DEFAULT_HOST_CCSID_USED        =  (CWB_EXPRESS_COMM_BASE+10);
  CWB_USER_TIMEOUT                   =  (CWB_EXPRESS_COMM_BASE+11);
  CWB_SSL_JAVA_ERROR                 =  (CWB_EXPRESS_COMM_BASE+12);
  CWB_USER_TIMEOUT_SENDRCV           =  (CWB_EXPRESS_COMM_BASE+13);

// Configuration Errors  (8500 - 8599)

  CWB_EXPRESS_CFG_BASE               =  (CWB_EXPRESSBASE+500);
  CWB_EXPRESS_CFG_END                =  (CWB_EXPRESS_CFG_BASE+99);

  CWB_RESTRICTED_BY_POLICY           =  (CWB_EXPRESS_CFG_BASE);
  CWB_POLICY_MODIFY_MANDATED_ENV     =  (CWB_EXPRESS_CFG_BASE+1);
  CWB_POLICY_MODIFY_CURRENT_ENV      =  (CWB_EXPRESS_CFG_BASE+2);
  CWB_POLICY_MODIFY_ENV_LIST         =  (CWB_EXPRESS_CFG_BASE+3);
  CWB_SYSTEM_NOT_FOUND               =  (CWB_EXPRESS_CFG_BASE+4);
  CWB_ENVIRONMENT_NOT_FOUND          =  (CWB_EXPRESS_CFG_BASE+5);
  CWB_ENVIRONMENT_EXISTS             =  (CWB_EXPRESS_CFG_BASE+6);
  CWB_SYSTEM_EXISTS                  =  (CWB_EXPRESS_CFG_BASE+7);
  CWB_NO_SYSTEMS_CONFIGURED          =  (CWB_EXPRESS_CFG_BASE+8);
  CWB_CONFIGERR_RESERVED_START       =  (CWB_EXPRESS_CFG_BASE+80);
  CWB_CONFIGERR_RESERVED_END         =  (CWB_EXPRESS_CFG_BASE+99);

// Automation Object Errors  (8600 - 8699)

  CWB_INVALID_METHOD_PARM            =  (CWB_EXPRESSBASE+600);
  CWB_INVALID_PROPERTY_PARM          =  (CWB_EXPRESSBASE+601);
  CWB_INVALID_PROPERTY_VALUE         =  (CWB_EXPRESSBASE+602);
  CWB_OBJECT_NOT_INITIALIZED         =  (CWB_EXPRESSBASE+603);
  CWB_OBJECT_ALREADY_INITIALIZED     =  (CWB_EXPRESSBASE+604);
  CWB_INVALID_DQ_ORDER               =  (CWB_EXPRESSBASE+605);
  CWB_DATA_TRANSFER_REQUIRED         =  (CWB_EXPRESSBASE+606);
  CWB_UNSUPPORTED_XFER_REQUEST       =  (CWB_EXPRESSBASE+607);
  CWB_ASYNC_REQUEST_ACTIVE           =  (CWB_EXPRESSBASE+608);
  CWB_REQUEST_TIMED_OUT              =  (CWB_EXPRESSBASE+609);
  CWB_CANNOT_SET_PROP_NOW            =  (CWB_EXPRESSBASE+610);
  CWB_OBJ_STATE_NO_LONGER_VALID      =  (CWB_EXPRESSBASE+611);


  CWB_UNSUPPORTED_FUNCTION           =  (CWB_EXPRESSBASE+998);
  CWB_INTERNAL_ERROR                 =  (CWB_EXPRESSBASE+999);

// 10000 - 11004 -- WINSOCK errors (see winsock.h / winsock2.h)

  CWB_SOCKBASE                       =  (10000);

  CWB_TOO_MANY_OPEN_SOCKETS                   = (CWB_SOCKBASE+24);
  CWB_RESOURCE_TEMPORARILY_UNAVAILABLE        = (CWB_SOCKBASE+35);
  CWB_SOCKET_OPERATION_ON_NON_SOCKET          = (CWB_SOCKBASE+38);
  CWB_PROTOCOL_NOT_INSTALLED                  = (CWB_SOCKBASE+47);
  CWB_NETWORK_IS_DOWN                         = (CWB_SOCKBASE+50);
  CWB_NETWORK_IS_UNREACHABLE                  = (CWB_SOCKBASE+51);
  CWB_NETWORK_DROPPED_CONNECTION_ON_RESET     = (CWB_SOCKBASE+52);
  CWB_SOFTWARE_CAUSED_CONNECTION_ABORT        = (CWB_SOCKBASE+53);
  CWB_CONNECTION_RESET_BY_PEER                = (CWB_SOCKBASE+54);
  CWB_NO_BUFFER_SPACE_AVAILABLE               = (CWB_SOCKBASE+55);
  CWB_SOCKET_IS_NOT_CONNECTED                 = (CWB_SOCKBASE+57);
  CWB_CANNOT_SEND_AFTER_SOCKET_SHUTDOWN       = (CWB_SOCKBASE+58);
  CWB_CONNECTION_TIMED_OUT                    = (CWB_SOCKBASE+60);
  CWB_CONNECTION_REFUSED                      = (CWB_SOCKBASE+61);
  CWB_HOST_IS_DOWN                            = (CWB_SOCKBASE+64);
  CWB_NO_ROUTE_TO_HOST                        = (CWB_SOCKBASE+65);
  CWB_NETWORK_SUBSYSTEM_IS_UNAVAILABLE        = (CWB_SOCKBASE+91);
  CWB_WINSOCK_VERSION_NOT_SUPPORTED           = (CWB_SOCKBASE+92);
  CWB_HOST_DEFINITELY_NOT_FOUND               = (CWB_SOCKBASE+1001);
  CWB_HOST_NOT_FOUND_BUT_WE_ARE_NOT_SURE      = (CWB_SOCKBASE+1002);
  CWB_VALID_NAME_BUT_NO_DATA_RECORD           = (CWB_SOCKBASE+1004);

// 20000 - 20999 -- SSL return codes
// NOTE: These are obsolete in V5R1M0.
// NOTE: In V5R1M0 and beyond, SSL return codes will only be documented in
//       the online Express User's Guide under CWBCO1034.

  CWB_SSLBASE1                                = (20000);
  CWB_SSLEND1                                 = (CWB_SSLBASE1+999);

  CWB_SSL_KEYFILE_IO_ERROR                    = (CWB_SSLBASE1+1);
  CWB_SSL_KEYFILE_OPEN_FAILED                 = (CWB_SSLBASE1+2);
  CWB_SSL_KEYFILE_BAD_FORMAT                  = (CWB_SSLBASE1+3);
  CWB_SSL_KEYFILE_BAD_PASSWORD                = (CWB_SSLBASE1+4);
  CWB_SSL_KEYFILE_BAD_MALLOC                  = (CWB_SSLBASE1+5);
  CWB_SSL_KEYFILE_NOTHING_TO_WRITE            = (CWB_SSLBASE1+6);
  CWB_SSL_KEYFILE_WRITE_FAILED                = (CWB_SSLBASE1+7);
  CWB_SSL_KEYFILE_NOT_FOUND                   = (CWB_SSLBASE1+8);
  CWB_SSL_KEYFILE_BAD_DNAME                   = (CWB_SSLBASE1+9);
  CWB_SSL_KEYFILE_BAD_KEY                     = (CWB_SSLBASE1+10);
  CWB_SSL_KEYFILE_KEY_EXISTS                  = (CWB_SSLBASE1+11);
  CWB_SSL_KEYFILE_BAD_LABEL                   = (CWB_SSLBASE1+12);
  CWB_SSL_KEYFILE_DUPLICATE_NAME              = (CWB_SSLBASE1+13);
  CWB_SSL_KEYFILE_DUPLICATE_KEY               = (CWB_SSLBASE1+14);
  CWB_SSL_KEYFILE_DUPLICATE_LABEL             = (CWB_SSLBASE1+15);
  CWB_SSL_BAD_FORMAT_OR_INVALID_PW            = (CWB_SSLBASE1+16);
  CWB_SSL_WARNING_INVALID_SERVER_CERT         = (CWB_SSLBASE1+98);
  CWB_SSL_WARNING_INVALID_SERVER_PRIV_KEY     = (CWB_SSLBASE1+99);
  CWB_SSL_ERR_INIT_PARM_NOT_VALID             = (CWB_SSLBASE1+100);
  CWB_SSL_INIT_SEC_TYPE_NOT_VALID             = (CWB_SSLBASE1+102);
  CWB_SSL_INIT_V2_TIMEOUT_NOT_VALID           = (CWB_SSLBASE1+103);
  CWB_SSL_INIT_V3_TIMEOUT_NOT_VALID           = (CWB_SSLBASE1+104);
  CWB_SSL_KEYFILE_CERT_EXPIRED                = (CWB_SSLBASE1+105);

// 25000 - 25999 -- More SSL return codes
// NOTE: These are obsolete in V5R1M0.
// NOTE: In V5R1M0 and beyond, SSL return codes will only be documented in
//       the online Express User's Guide under CWBCO1034.

  CWB_SSLBASE2                                = (CWB_SSLBASE1+5000);
  CWB_SSLEND2                                 = (CWB_SSLBASE2+999);

  CWB_SSL_ERROR_NO_CIPHERS                    = (CWB_SSLBASE2+1);
  CWB_SSL_ERROR_NO_CERTIFICATE                = (CWB_SSLBASE2+2);
  CWB_SSL_ERROR_BAD_CERTIFICATE               = (CWB_SSLBASE2+4);
  CWB_SSL_ERROR_UNSUPPORTED_CERTIFICATE_TYPE  = (CWB_SSLBASE2+6);
  CWB_SSL_ERROR_IO                            = (CWB_SSLBASE2+10);
  CWB_SSL_ERROR_BAD_MESSAGE                   = (CWB_SSLBASE2+11);
  CWB_SSL_ERROR_BAD_MAC                       = (CWB_SSLBASE2+12);
  CWB_SSL_ERROR_UNSUPPORTED                   = (CWB_SSLBASE2+13);
  CWB_SSL_ERROR_BAD_CERT_SIG                  = (CWB_SSLBASE2+14);
  CWB_SSL_ERROR_BAD_CERT                      = (CWB_SSLBASE2+15);
  CWB_SSL_ERROR_BAD_PEER                      = (CWB_SSLBASE2+16);
  CWB_SSL_ERROR_PERMISSION_DENIED             = (CWB_SSLBASE2+17);
  CWB_SSL_ERROR_SELF_SIGNED                   = (CWB_SSLBASE2+18);
  CWB_SSL_ERROR_BAD_MALLOC                    = (CWB_SSLBASE2+20);
  CWB_SSL_ERROR_BAD_STATE                     = (CWB_SSLBASE2+21);
  CWB_SSL_ERROR_SOCKET_CLOSED                 = (CWB_SSLBASE2+22);
  CWB_SSL_ERROR_INITIALIZATION_FAILED         = (CWB_SSLBASE2+23);
  CWB_SSL_ERROR_HANDLE_CREATION_FAILED        = (CWB_SSLBASE2+24);
  CWB_SSL_ERROR_BAD_DATE                      = (CWB_SSLBASE2+25);
  CWB_SSL_ERROR_BAD_KEY_LEN_FOR_EXPORT        = (CWB_SSLBASE2+26);
  CWB_SSL_ERROR_NO_PRIVATE_KEY                = (CWB_SSLBASE2+27);
  CWB_SSL_BAD_PARAMETER                       = (CWB_SSLBASE2+28);
  CWB_SSL_ERROR_INTERNAL                      = (CWB_SSLBASE2+29);
  CWB_SSL_ERROR_WOULD_BLOCK                   = (CWB_SSLBASE2+30);
  CWB_SSL_ERROR_LOAD_GSKLIB                   = (CWB_SSLBASE2+31);
  CWB_SSL_SOC_BAD_V2_CIPHER                   = (CWB_SSLBASE2+40);
  CWB_SSL_SOC_BAD_V3_CIPHER                   = (CWB_SSLBASE2+41);
  CWB_SSL_SOC_BAD_SEC_TYPE                    = (CWB_SSLBASE2+42);
  CWB_SSL_SOC_NO_READ_FUNCTION                = (CWB_SSLBASE2+43);
  CWB_SSL_SOC_NO_WRITE_FUNCTION               = (CWB_SSLBASE2+44);
  CWB_SSL_ERROR_NOT_SERVER                    = (CWB_SSLBASE2+50);
  CWB_SSL_ERROR_NOT_SSLV3                     = (CWB_SSLBASE2+51);
  CWB_SSL_ERROR_NOT_SSLV3_CLIENT              = (CWB_SSLBASE2+52);
  CWB_SSL_ERROR_UNKNOWN_ERROR                 = (CWB_SSLBASE2+99);
  CWB_SSL_ERROR_BAD_BUFFER_SIZE               = (CWB_SSLBASE2+100);
  CWB_SSL_ERROR_BAD_SSL_HANDLE                = (CWB_SSLBASE2+101);
  CWB_SSL_ERROR_TIMEOUT                       = (CWB_SSLBASE2+102);

// 30000 - 30999 -- internal return codes

  CWB_RESERVED2_BASE                          = (30000);
  CWB_RESERVED2_END                           = (CWB_RESERVED2_BASE+999);


  CWBDB_START                        =  CWB_LAST+1;

  CWBDB_CANNOT_CONTACT_SERVER        =  CWBDB_START+1;          // An error was encountered which prevented the Data Access server from being started.
  CWBDB_ATTRIBUTES_FAILURE           =  CWBDB_START+2;          // An error was encountered during attempt to set the Data Access server attributes.
  CWBDB_SERVER_ALREADY_STARTED       =  CWBDB_START+3;          // An attempt to start the Data Access server was made while a valid server was running. Stop the server before restarting it.
  CWBDB_INVALID_DRDA_PKG_SIZE        =  CWBDB_START+4;          // The valid submitted for the DRDA package size was invalid.
  CWBDB_REQUEST_MEMORY_ALLOCATION_FAILURE = CWBDB_START+5;      // A memory allocation attempt by a request handle failed.
  CWBDB_REQUEST_INVALID_CONVERSION = CWBDB_START+6;             // A Request handle failed in an attempt to convert data.
  CWBDB_SERVER_NOT_ACTIVE            =  CWBDB_START+7;          // The Data Access server is not started. It must be started before continuing.
  CWBDB_PARAMETER_ERROR              =  CWBDB_START+8;          // Attempt to set a parameter failed. Re-try. If error persists, there may be a lack of available memory.
  CWBDB_CLONE_CREATION_ERROR         =  CWBDB_START+9;          // Could not create a clone request.
  CWBDB_INVALID_DATA_FORMAT_FOR_CONNECTION =  CWBDB_START+10;   // The data format object was not valid for this connection.
  CWBDB_DATA_FORMAT_IN_USE           =  CWBDB_START+11;         // The data format object is already being used by another request.
  CWBDB_INVALID_DATA_FORMAT_FOR_DATA =  CWBDB_START+12;         // The data format object does not match the format of the data.
  CWBDB_STRING_ARG_TOO_LONG          =  CWBDB_START+13;         // The string provided was too long for the parameter.
  CWBDB_INVALID_INTERNAL_ARG         =  CWBDB_START+14;         // Invalid internally generated arguemtn (not user supplied)
  CWBDB_INVALID_NUMERIC_ARG          =  CWBDB_START+15;         // Value of numeric argument is invalid.
  CWBDB_INVALID_ARG                  =  CWBDB_START+16;         // Value of argument is invalid.
  CWBDB_STMT_NOT_SELECT              =  CWBDB_START+17;         // The statement provided was not a SELECT statement. This call requires a SELECT statement.
  CWBDB_STREAM_FETCH_NOT_COMPLETE    =  CWBDB_START+18;         // The connection is in stream fetch mode. Cannot perform desired operation until stream fetch has ended.
  CWBDB_STREAM_FETCH_NOT_ACTIVE      =  CWBDB_START+19;         // The connection is not in stream fetch mode and must be in order to perform the desired operation.
  CWBDB_MISSING_DATA_PROCESSOR       =  CWBDB_START+20;         // Pointer to data processor in request object is null.
  CWBDB_ILLEGAL_CLONE_REQUEST_TYPE   =  CWBDB_START+21;         // Cannot create a clone of an attributes request.
  CWBDB_UNSOLICITED_DATA             =  CWBDB_START+22;         // Data were received from the server, but none were requested.
  CWBDB_MISSING_DATA                 =  CWBDB_START+23;         // Data were requested from the server, but not all were received.
  CWBDB_PARM_INVALID_BITSTREAM       =  CWBDB_START+24;         // Bitstream within a parameter is invalid.
  CWBDB_CONSISTENCY_TOKEN_ERROR      =  CWBDB_START+25;         // The data format used to interpret the data from the AS/400 does not match the data returned.
  CWBDB_INVALID_FUNCTION             =  CWBDB_START+26;         // The function is invalid for this type of request.
  CWBDB_FORMAT_INVALID_ARG           =  CWBDB_START+27;         // A parameter value passed to the API was not valid.
  CWBDB_INVALID_COLUMN_POSITION      =  CWBDB_START+28;         // The column position passed to the API was not valid.
  CWBDB_INVALID_COLUMN_TYPE          =  CWBDB_START+29;         // The column type passed to the API was not valid.
  CWBDB_ROW_VECTOR_NOT_EMPTY         =  CWBDB_START+30;         // Invalid or corrupted format handle.
  CWBDB_ROW_VECTOR_EMPTY             =  CWBDB_START+31;         // Invalid or corrupted format handle.
  CWBDB_MEMORY_ALLOCATION_FAILURE    =  CWBDB_START+32;         // An error occurred while attempting to allocate memory.
  CWBDB_INVALID_CONVERSION           =  CWBDB_START+33;         // An invalid type conversion was attempted.
  CWBDB_DATASTREAM_TOO_SHORT         =  CWBDB_START+34;         // The data stream received from the host was too short.
  CWBDB_SQL_WARNING                  =  CWBDB_START+35;         // The database server received a warning from a SQL operation.
  CWBDB_SQL_ERROR                    =  CWBDB_START+36;         // The database server received an error from a SQL operation.
  CWBDB_SQL_PARAMETER_WARNING        =  CWBDB_START+37;         // The database server received a warning about a parameter used in a SQL operation.
  CWBDB_SQL_PARAMETER_ERROR          =  CWBDB_START+38;         // The database server received an error about a parameter used in a SQL operation.
  CWBDB_LIST_SERVER_WARNING          =  CWBDB_START+39;         // The database server returned a warning from a catalog operation.
  CWBDB_LIST_SERVER_ERROR            =  CWBDB_START+40;         // The database server returned an error from a catalog operation.
  CWBDB_LIST_PARAMETER_WARNING       =  CWBDB_START+41;         // The database server returned a warning about a parameter used in a catalog operation.
  CWBDB_LIST_PARAMETER_ERROR         =  CWBDB_START+42;         // The database server returned an error about a parameter used in a catalog operation.
  CWBDB_NDB_FILE_SERVER_WARNING      =  CWBDB_START+43;         // The database server returned a warning from a file processing operation.
  CWBDB_NDB_FILE_SERVER_ERROR        =  CWBDB_START+44;         // The database server returned an error from a file processing operation.
  CWBDB_FILE_PARAMETER_WARNING       =  CWBDB_START+45;         // The database server returned a warning about a parameter used in a file processing operation.
  CWBDB_FILE_PARAMETER_ERROR         =  CWBDB_START+46;         // The database server returned an error about a parameter used in a file processing operation.
  CWBDB_GENERAL_SERVER_WARNING       =  CWBDB_START+47;         // The database server returned a general warning.
  CWBDB_GENERAL_SERVER_ERROR         =  CWBDB_START+48;         // The database server returned a general error.
  CWBDB_EXIT_PROGRAM_WARNING         =  CWBDB_START+49;         // The database server returned a warning from an exit program.
  CWBDB_EXIT_PROGRAM_ERROR           =  CWBDB_START+50;         // The database server returned an error from an exit program.
  CWBDB_DATA_BUFFER_TOO_SMALL        =  CWBDB_START+51;         // Target data buffer is smaller than source buffer
  CWBDB_NL_CONVERSION_ERROR          =  CWBDB_START+52;         // Received error back from PiNlConverter
  CWBDB_COMMUNICATIONS_ERROR         =  CWBDB_START+53;         // Received a communications error during processing
  CWBDB_INVALID_ARG_API              =  CWBDB_START+54;         // Value of argument is invalid - API level.
  CWBDB_MISSING_DATA_HANDLER         =  CWBDB_START+55;         // Data handler not found in data handler list.
  CWBDB_REQUEST_DATASTREAM_NOT_VALID =  CWBDB_START+56;         // Invalid datastream in catalog request.
  CWBDB_SERVER_UNABLE                =  CWBDB_START+57;         // Server incapable of performing desired function.
// The next group of return codes are returned by the new cwbDB_StartServerDetailed API.
  CWBDB_WORK_QUEUE_START_ERROR       =  CWBDB_START+58;         // Unable to start server because of client work queue problem.
  CWBDB_WORK_QUEUE_CREATE_ERROR      =  CWBDB_START+59;         // Unable to start server because of client work queue problem.
  CWBDB_INITIALIZATION_ERROR         =  CWBDB_START+60;         // Unable to start server because of client initialization problem.
  CWBDB_SERVER_ATTRIBS_ERROR         =  CWBDB_START+61;         // Unable to start server because of server attribute problem.
  CWBDB_CLIENT_LEVEL_ERROR           =  CWBDB_START+62;         // Unable to start server because of set client level problem.
  CWBDB_CLIENT_LFC_ERROR             =  CWBDB_START+63;         // Unable to start server because of set client language feature code problem.
  CWBDB_CLIENT_CCSID_ERROR           =  CWBDB_START+64;         // Unable to start server because of set client CCSID problem.
  CWBDB_TRANSLATION_INDICATOR_ERROR  =  CWBDB_START+65;         // Unable to start server because of set translation indicator error
  CWBDB_RETURN_SERVER_ATTRIBS_ERROR  =  CWBDB_START+66;         // Unable to start server because of return server attribute problem
  CWBDB_SERVER_ATTRIBS_REQUEST       =  CWBDB_START+67;         // Unable to start server because of missing server attributes request object.
  CWBDB_RETURN_ATTRIBS_ERROR         =  CWBDB_START+68;         // Unable to start server because of return attribute problem.
  CWBDB_SERVER_ATTRIBS_MISSING       =  CWBDB_START+69;         // Unable to start server because returned server attributes too short (missing data).
  CWBDB_SERVER_LFC_CONVERSION_ERROR  =  CWBDB_START+70;         // Unable to start server because of data conversion error on server language feature code field of server attributes.
  CWBDB_SERVER_LEVEL_CONVERSION_ERROR=  CWBDB_START+71;         // Unable to start server because of data conversion error on server functional level field of server attributes.
  CWBDB_SERVER_LANGUAGE_TABLE_ERROR  =  CWBDB_START+72;         // Unable to start server because of data conversion error on server language table ID field of server attributes.
  CWBDB_SERVER_LANGUAGE_LIBRARY_ERROR=  CWBDB_START+73;         // Unable to start server because of data conversion error on server language library ID field of server attributes.
  CWBDB_SERVER_LANGUAGE_ID_ERROR     =  CWBDB_START+74;         // Unable to start server because of data conversion error on server language ID field of server attributes.
  CWBDB_COMM_DEQUEUE_ERROR           =  CWBDB_START+75;         // Unable to start server because of communications error.
  CWBDB_COMM_ENQUEUE_ERROR           =  CWBDB_START+76;         // Unable to start server because of communications error.
  CWBDB_UNSUPPORTED_COLUMN_TYPE      =  CWBDB_START+77;         // An unsupported column type was found in the data format.
  CWBDB_SERVER_IN_USE                =  CWBDB_START+78;         // A connection to the database server for the given connection handle is already being used by another connection handle which was created with the same system object handle.
  CWBDB_SERVER_REL_DB_CONVERSION_ERROR =  CWBDB_START+79;       // Unable to start server because of data conversion error on server relational DB  field of server attributes.
  CWBDB_SERVER_FUNCTION_NOT_AVAILABLE  =  CWBDB_START+80;       // This function is not available on this version of the host server
  CWBDB_FUNCTION_NOT_VALID_AFTER_CONNECT = CWBDB_START+81;      // This function is not valid after connected to the host server
  CWBDB_INVALID_INITIAL_REL_DB_NAME      = CWBDB_START+82;      // The initial relational DB name (IASP) was invalid

  CWBDB_LAST_STREAM_CHUNK            =  CWBDB_START+99;         // Stream fetch complete. NOTE: Informational; not an error.

// Definitions for parameter types

  CWBDB_PERIOD_NAME_CONV = 0; // SQL naming convention (.)
  CWBDB_SLASH_NAME_CONV  = 1; // Native AS/400 naming convention (/)

  CWBDB_IGNORE_ERROR     = 0; // Ignore decimal data error
  CWBDB_CORRECT_ERROR    = 1; // Correct decimal data error

  CWBDB_NONE             = 0; // *NONE - No commitment control
  CWBDB_CURSOR_STABILITY = 1; // *CS   - Cursor stability
  CWBDB_CHANGE           = 2; // *CHG  - Change
  CWBDB_ALL              = 3; // *ALL  - All

  CWBDB_ALL_FILES_ATTRIBUTES     =1; // All files
  CWBDB_PHYSICAL_FILES_ATTRIBUTES=2; // Only physical files
  CWBDB_LOGICAL_FILES_ATTRIBUTES =3; // Logical files
  CWBDB_ODBC_TABLES_ATTRIBUTES   =4; // phys. files, tables, indexes
  CWBDB_ODBC_VIEWS_ATTRIBUTES    =5; // logical files and views
  CWBDB_ODBC_SYSTEM_TABLES       =6;
  CWBDB_ODBC_TABLES_VIEWS        =7;
  CWBDB_ODBC_TABLES_SYSTEM_TABLES=8;
  CWBDB_ODBC_VIEWS_SYSTEM_TABLES =9;

  CWBDB_ALL_FILES        = 1;  // All files
  CWBDB_SOURCE_FILES     = 2;  // Source files
  CWBDB_DATA_FILES       = 3;  // Data files

  CWBDB_DEFAULT_CATALOG_ORDERING   = 1;  // Use the default order
  CWBDB_ODBC_TABLE_ORDERING        = 2;  // Order by ODBC tables
  CWBDB_ODBC_TABLE_PRIVILEGE_ORDER = 3;  // Order by  ODBC privilege

  CWBDB_UNIQUE_INDEX      = 1;  // Index is unique
  CWBDB_DUPLICATE_INDEX   = 2;  // Duplicates are allowed
  CWBDB_DUP_NULL_INDEX    = 3;  // Duplicate null values are allowed

  CWBDB_ALL_STATEMENTS    = 1;  // All statement types
  CWBDB_DECLARE_STATEMENTS = 2; // Declare statements
  CWBDB_SELECT_STATEMENTS = 3;  // Select statements
  CWBDB_EXEC_STATEMENTS   = 4;  // Executable statements

  CWBDB_GET_LIBRARY_NAME = $01000000; // Retrieve library name
  CWBDB_GET_LIBRARY_DESC = $02000000; // Retrieve description
  CWBDB_GET_LIBRARY_OWNER= $04000000; // Retrieve owner
  CWBDB_GET_LIBRARY_ALL  = $07000000;

  CWBDB_GET_RDB_NAME     = $01000000;  // Remote Relational Database name
  CWBDB_GET_RDB_DEVICE   = $02000000;  // Relational Database device
  CWBDB_GET_RDB_MODE     = $04000000;  // Relational Database mode
  CWBDB_GET_RDB_RMTLOC   = $08000000;  // Relational Database remote location
  CWBDB_GET_RDB_LOCLOC   = $10000000;  // Local location
  CWBDB_GET_RDB_RMTNET   = $20000000;  // Remote network
  CWBDB_GET_RDB_TPNAME   = $40000000;  // Remote Transaction Program name
  CWBDB_GET_RDB_DESC     = $80000000;  // Relational Database Text description
  CWBDB_GET_RDB_TPNDISP  = $00010000;  // Transaction Program name display
  CWBDB_GET_RDB_PGM      = $00040000;  // Relational Database program
  CWBDB_GET_RDB_PGMLIB   = $00080000;  // Relational Database program library
  CWBDB_GET_RDB_PGMLEVEL = $00100000;  // Relational Database program level
  CWBDB_GET_RDB_ALL      = $FF1D0000;

  CWBDB_GET_SQLPKG_LIB   = $01000000;  // SQL package library
  CWBDB_GET_SQLPKG_NAME  = $02000000;  // SQL Package name
  CWBDB_GET_SQLPKG_DESC  = $04000000;  // Text description of package
  CWBDB_GET_SQLPKG_ALL   = $07000000;

  CWBDB_GET_SQLSTMT_LIB  = $01000000;  // SQL package library
  CWBDB_GET_SQLSTMT_PKG  = $02000000;  // SQL statement package
  CWBDB_GET_SQLSTMT_NAME = $04000000;  // SQL statement name
  CWBDB_GET_SQLSTMT_TYPE = $08000000;  // Statement Type
  CWBDB_GET_SQLSTMT_TEXT = $10000000;  // Text of statement
  CWBDB_GET_SQLSTMT_PM_CNT=$20000000;  // Parameter marker count
  CWBDB_GET_SQLSTMT_ALL  = $3F000000;

  CWBDB_GET_FILE_LIB     =   $01000000; // Library name
  CWBDB_GET_FILE_REMARKS =   $02000000; // Remarks
  CWBDB_GET_FILE_NAME    =   $04000000; // File name
  CWBDB_GET_FILE_ATTRIB  =   $08000000; // Attribute
  CWBDB_GET_FILE_TYPE    =   $10000000; // File type (source/db)
  CWBDB_GET_FILE_DESC    =   $20000000; // Text description
  CWBDB_GET_FILE_COL_CNT =   $40000000; // Number of columns
  CWBDB_GET_FILE_AUTH    =   $80000000; // Current authority
  CWBDB_GET_FILE_ALL     =   $FF000000;

  CWBDB_GET_MBR_LIB      =   $01000000; // Library of member
  CWBDB_GET_MBR_FILE     =   $02000000; // Member file
  CWBDB_GET_MBR_NAME     =   $04000000; // Member name
  CWBDB_GET_MBR_DESC     =   $08000000; // Text description
  CWBDB_GET_MBR_ALL      =   $0F000000;

  CWBDB_GET_FMT_LIB      =   $01000000; // Record format library
  CWBDB_GET_FMT_FILE     =   $02000000; // Record format file
  CWBDB_GET_FMT_NAME     =   $04000000; // Record format name
  CWBDB_GET_FMT_REC_LEN  =   $08000000; // Record length
  CWBDB_GET_FMT_DESC     =   $10000000; // Text description
  CWBDB_GET_FMT_ALL      =   $1F000000;

  CWBDB_GET_FLD_LIB      =   $01000000; // Field library
  CWBDB_GET_FLD_REMARKS  =   $02000000; // Field remarks
  CWBDB_GET_FLD_FILE     =   $04000000; // Field file
  CWBDB_GET_FLD_NAME     =   $10000000; // Field name
  CWBDB_GET_FLD_DESC     =   $20000000; // Text description
  CWBDB_GET_FLD_DATA_TYPE=   $40000000; // Data type
  CWBDB_GET_FLD_LEN      =   $80000000; // Length
  CWBDB_GET_FLD_NULL     =   $00010000; // Null capability
  CWBDB_GET_FLD_RADIX    =   $00020000; // Radix
  CWBDB_GET_FLD_PREC     =   $00040000; // Precision
  CWBDB_GET_FLD_SCALE    =   $00080000; // Scale
  CWBDB_GET_FLD_CCSID    =   $00200000; // CCSID
  CWBDB_GET_FLD_ALL      =   $F72F0000;

  CWBDB_GET_IDX_TBL_LIB  =   $01000000; // Library name
  CWBDB_GET_IDX_TBL_NAME =   $04000000; // Table name
  CWBDB_GET_IDX_UNIQUE   =   $08000000; // Index unique rule
  CWBDB_GET_IDX_IDX_LIB  =   $10000000; // Index library
  CWBDB_GET_IDX_IDX_NAME =   $20000000; // Index name
  CWBDB_GET_IDX_COL_CNT  =   $40000000; // Column count
  CWBDB_GET_IDX_COL_NAME =   $80000000; // Column names
  CWBDB_GET_IDX_COL_SEQ  =   $00010000; // Column sequence
  CWBDB_GET_IDX_COLLAT   =   $00020000; // Collation sequence
  CWBDB_GET_IDX_ALL      =   $F7030000;

  CWBDB_GET_SP_COL_LIB      =$01000000; // Library name
  CWBDB_GET_SP_COL_TABLE    =$04000000; // Table name
  CWBDB_GET_SP_COL_COL_NAME =$08000000; // Column name
  CWBDB_GET_SP_COL_DATA_TYPE=$10000000; // Data type
  CWBDB_GET_SP_COL_PRECISION=$20000000; // Precision
  CWBDB_GET_SP_COL_LENGTH   =$40000000; // Length
  CWBDB_GET_SP_COL_SCALE    =$80000000; // Scale
  CWBDB_GET_SP_COL_ALL      =$FD000000;

// Primary Key Information constants
  CWBDB_GET_PR_KEY_LIB      =$01000000; // Library name
  CWBDB_GET_PR_KEY_FILE     =$08000000; // File name
  CWBDB_GET_PR_KEY_COL_ID   =$10000000; // Column ID
  CWBDB_GET_PR_KEY_COL_SEQ  =$20000000; // Column Sequence
  CWBDB_GET_PR_KEY_ALL      =$39000000;

// Foreign Key Primary Key Information constants
  CWBDB_GET_FG_PRKEY_LIB    =$01000000; // Library name
  CWBDB_GET_FG_PRKEY_FILE   =$04000000; // File name
  CWBDB_GET_FG_PRKEY_COL_ID =$08000000; // Column ID
  CWBDB_GET_FG_PRKEY_ALL    =$0D000000;
// Foreign Key Information constants
  CWBDB_GET_FG_KEY_LIB      =$10000000; // Library name
  CWBDB_GET_FG_KEY_FILE     =$40000000; // File name
  CWBDB_GET_FG_KEY_COL_ID   =$80000000; // Column ID
  CWBDB_GET_FG_KEY_SEQ      =$00010000; // Key sequence
  CWBDB_GET_FG_KEY_UPDATE   =$00020000; // Update rule
  CWBDB_GET_FG_KEY_DELETE   =$00040000; // Delete rule
  CWBDB_GET_FG_KEY_ALL      =$D0070000;

  CWBDB_NOT_NULLABLE        =$F0;       // not null capable
  CWBDB_NULLABLE            =$F1;       // Null capable

  CWBDB_SET_LIBRARY_CREATE_AUTHORITY=0; // *LIBCRTAUT
  CWBDB_SET_ALL_AUTHORITY           =1; // *ALL
  CWBDB_SET_CHANGE_AUTHORITY        =2; // *CHANGE
  CWBDB_SET_EXCLUDE_AUTHORITY       =3; // *EXCLUDE
  CWBDB_SET_USE_AUTHORITY           =4; // *USE
  CWBDB_SET_SAME_AUTHORITY          =5; // *SAME

  CWBDB_DO_NOT_COPY_DATA =0;   // Do not copy data to new file
  CWBDB_COPY_DATA        =1;   // Copy data to new file

  CWBDB_NORMAL_PREPARE   =0;   // Normal prepare (default)
  CWBDB_ENHANCED_PREPARE =1;   // Enhanced prepare

  CWBDB_DESC_ALIAS_NAMES =$D5; // Use alias names (default)
  CWBDB_DESC_NAMES_ONLY  =$E2; // Use names only
  CWBDB_DESC_LABELS      =$D3; // Use labels

  CWBDB_CURSOR_NOT_SCROLLABLE= 0; // Non-scrollable (default)
  CWBDB_CURSOR_SCROLLABLE    = 1; // Scrollable
  CWBDB_CURSOR_STATIC_SCROLLABLE=2; // Static Scrollable

  CWBDB_CURSOR_NOT_SCROLLABLE_ASENSITIVE     = 0; // Non-scrollable (default), dont care about changes
  CWBDB_CURSOR_SCROLLABLE_ASENSITIVE         = 1; // Scrollable, dont care about changes
  CWBDB_CURSOR_STATIC_SCROLLABLE_INSENSITIVE = 2; // Static scrollable, insensitive to changes
  CWBDB_CURSOR_SCROLLABLE_SENSITIVE          = 3; // Scrollable, sensitive to changes (>= V5R2)
  CWBDB_CURSOR_NOT_SCROLLABLE_SENSITIVE      = 4; // Non-scrollable, sensitive to changes (>= V5R2)
  CWBDB_CURSOR_NOT_SCROLLABLE_INSENSITIVE    = 5; // Non-scrollable, insensitive to changes (>= V5R2)

  CWBDB_SCROLL_NEXT        =0;   // Fetch next record
  CWBDB_SCROLL_PREVIOUS    =1;   // Fetch previous record
  CWBDB_SCROLL_FIRST       =2;   // Fetch first record
  CWBDB_SCROLL_LAST        =3;   // Fetch last record
  CWBDB_SCROLL_BEFORE_FIRST=4;   // Fetch before first record (BOF)
  CWBDB_SCROLL_AFTER_LAST  =5;   // Fetch after last record   (EOF)
  CWBDB_SCROLL_CURRENT     =6;   // Fetch current record
  CWBDB_SCROLL_RELATIVE    =7;   // Fetch relative from cursor
  CWBDB_SCROLL_DIRECT      =8;   // Fetch from absolute position

  CWBDB_WORK   = 0;              // Commit/Rollback work option
  CWBDB_HOLD   = 1;              // Commit/Rollback hold option

  CWBDB_READ    =$80;            // Indicates read intent
  CWBDB_WRITE   =$40;            // Indicates write intent
  CWBDB_UPDATE  =$20;            // Indicates update intent
  CWBDB_DELETE  =$10;            // Indicates delete intent
  CWBDB_OPEN_ALL=$F0;            // Indicates all of the above

  CWBDB_SYSTEM  = 0;             // Returns system format
  CWBDB_LOCAL   = 1;             // Returns local format

  CWBDB_PCNOCONVERSION     =     0;        // No conversion done
  CWBDB_PCSTRING           =     1;        // character data
  CWBDB_PCLONG             =     2;        //  4 byte integer
  CWBDB_PCSHORT            =     3;        //  2 byte integer
  CWBDB_PCFLOAT            =     4;        //  4 byte floating point
  CWBDB_PCDOUBLE           =     5;        //  8 byte floating point
  CWBDB_PCPACKED           =     6;        //    packed decimal
  CWBDB_PCZONED            =     7;        //    zoned decimal
  CWBDB_PCINVALIDTYPE      =     8;        //
  CWBDB_PCVARSTRING        =     9;        // Varying length string
  CWBDB_PCGRAPHIC          =    10;        // Graphic data "pure DBCS"
  CWBDB_PCVARGRAPHIC       =    11;        // Varying length graphic
  CWBDB_PCVARDATALINK      =    12;        // Varying length DataLink
  CWBDB_PCBLOB             =    13;        // BLOB data - binary
  CWBDB_PCCLOB             =    14;        // CLOB data - character
  CWBDB_PCDBCLOB           =    15;        // Double Byte CLOB
  CWBDB_PCBLOBLOCATOR      =    16;        // BLOB locator
  CWBDB_PCCLOBLOCATOR      =    17;        // CLOB locator
  CWBDB_PCDBCLOBLOCATOR    =    18;        // Double byte CLOB locator
  CWBDB_PCUNSUPPORTEDTYPE  =    19;        // Unsupported
  CWBDB_PCBIGINT           =    20;        // Big integer (8 byte)
  CWBDB_PCROWID            =    21;        // RowID

// These constants define the SQL type values from  Appendix C of the
// SQL Reference.  Each data type has two versions, one with NC at the
// end of the name, which is null capable and the other without NC at
// the end of the name, which is not null capable.  These constants are
// numbers where the value of the null capable type is odd and the
// value of the not null capable type is even and one less than the
// null capable value for the same type.

  CWBDB_SQLNullCapable         = 1;     // adding to any type makes it null capable

  CWBDB_SQLDate                = 384;        // 384/385 10 byte date
  CWBDB_SQLDateNC              = CWBDB_SQLDate +CWBDB_SQLNullCapable;
  CWBDB_SQLTime                = 388;        // 388/389  8 byte time
  CWBDB_SQLTimeNC              = CWBDB_SQLTime +CWBDB_SQLNullCapable;
  CWBDB_SQLTimeStamp           = 392;        // 392/393 26 byte date/time stamp
  CWBDB_SQLTimeStampNC         = CWBDB_SQLTimeStamp +CWBDB_SQLNullCapable;
  CWBDB_SQLVarDataLink         = 396;
  CWBDB_SQLVarDataLinkNC       = CWBDB_SQLVarDataLink +CWBDB_SQLNullCapable;
  CWBDB_SQLBLOB                = 404;
  CWBDB_SQLBLOBNC              = CWBDB_SQLBLOB +CWBDB_SQLNullCapable;
  CWBDB_SQLCLOB                = 408;
  CWBDB_SQLCLOBNC              = CWBDB_SQLCLOB +CWBDB_SQLNullCapable;
  CWBDB_SQLDBCLOB              = 412;
  CWBDB_SQLDBCLOBNC            = CWBDB_SQLDBCLOB +CWBDB_SQLNullCapable;
  CWBDB_SQLVaryingString       = 448;        // 448/449
  CWBDB_SQLVaryingStringNC     = CWBDB_SQLVaryingString +CWBDB_SQLNullCapable;
  CWBDB_SQLString              = 452;        // 452/453
  CWBDB_SQLStringNC            = CWBDB_SQLString +CWBDB_SQLNullCapable;
  CWBDB_SQLLongVaryingString   = 456;        // 456/457
  CWBDB_SQLLongVaryingStringNC = CWBDB_SQLLongVaryingString +CWBDB_SQLNullCapable;
  CWBDB_SQLVaryingGraphic      = 464;        // 464/465
  CWBDB_SQLVaryingGraphicNC    = CWBDB_SQLVaryingGraphic +CWBDB_SQLNullCapable;
  CWBDB_SQLGraphic             = 468;        // 468/469
  CWBDB_SQLGraphicNC           = CWBDB_SQLGraphic +CWBDB_SQLNullCapable;
  CWBDB_SQLLongVaryingGraphic  = 472;        // 472/473
  CWBDB_SQLLongVaryingGraphicNC = CWBDB_SQLLongVaryingGraphic+CWBDB_SQLNullCapable;
  CWBDB_SQLFloat            =  480;        // 480/481  4 or 8 byte binary float
  CWBDB_SQLFloatNC          =  CWBDB_SQLFloat +CWBDB_SQLNullCapable;
  CWBDB_SQLPacked           =  484;        // 484/485    packed decimal
  CWBDB_SQLPackedNC         =  CWBDB_SQLPacked +CWBDB_SQLNullCapable;
  CWBDB_SQLZoned            =  488;        // 488/489    zoned decimal
  CWBDB_SQLZonedNC          =  CWBDB_SQLZoned +CWBDB_SQLNullCapable;
  CWBDB_SQLBigInt           =  492;        // 492/493  8 byte integer
  CWBDB_SQLBigIntNC         =  CWBDB_SQLBigInt +CWBDB_SQLNullCapable;
  CWBDB_SQLLargeInt         =  496;        // 496/497  4 byte integer
  CWBDB_SQLLargeIntNC       =  CWBDB_SQLLargeInt +CWBDB_SQLNullCapable;
  CWBDB_SQLSmallInt         =  500;        // 500/501  2 byte integer
  CWBDB_SQLSmallIntNC       =  CWBDB_SQLSmallInt +CWBDB_SQLNullCapable;
  CWBDB_SQLRowId            =  904;
  CWBDB_SQLRowIdNC          =  CWBDB_SQLRowId + CWBDB_SQLNullCapable; // NOT valid in the database
  CWBDB_SQLBLOBLocator      =  960;
  CWBDB_SQLBLOBLocatorNC    =  CWBDB_SQLBLOBLocator +CWBDB_SQLNullCapable;
  CWBDB_SQLCLOBLocator      =  964;
  CWBDB_SQLCLOBLocatorNC    =  CWBDB_SQLCLOBLocator +CWBDB_SQLNullCapable;
  CWBDB_SQLDBCLOBLocator    =  968;
  CWBDB_SQLDBCLOBLocatorNC  =  CWBDB_SQLDBCLOBLocator +CWBDB_SQLNullCapable;
  CWBDB_SQLInvalidType      =  8;

// These are some SQL limits for Appendix A of the SQL Reference
  CWBDB_MAX_COLUMN_NAME     = 30;  // Longest unqualified column name
  CWBDB_MAX_PARAMETER_NAME  = 64;  // Longest unqualified SQL parameter name

  CWBDB_PATTERNMATCH_LIB    = 0;      // Library
  CWBDB_PATTERNMATCH_FILE   = 1;      // File
  CWBDB_PATTERNMATCH_MBR    = 2;      // Member
  CWBDB_PATTERNMATCH_FIELD  = 3;      // Field
  CWBDB_PATTERNMATCH_FORMAT = 4;      // Format
  CWBDB_PATTERNMATCH_RDB    = 5;      // RDB
  CWBDB_PATTERNMATCH_SQLPKG = 6;      // SQL Package

  CWBDB_DATE_FMT_JUL        = 0;      // Julian
  CWBDB_DATE_FMT_MDY        = 1;      // month day year
  CWBDB_DATE_FMT_DMY        = 2;      // day month year
  CWBDB_DATE_FMT_YMD        = 3;      // year month day
  CWBDB_DATE_FMT_USA        = 4;      // USA
  CWBDB_DATE_FMT_ISO        = 5;      // ISO
  CWBDB_DATE_FMT_EUR        = 6;      // IBM Europe
  CWBDB_DATE_FMT_JIS        = 7;      // IBM Japan

  CWBDB_DATE_SEP_SLASH      = 0;      // slash    03/17/94
  CWBDB_DATE_SEP_DASH       = 1;      // dash     03-17-94
  CWBDB_DATE_SEP_PERIOD     = 2;      // period   03.17.94
  CWBDB_DATE_SEP_COMMA      = 3;      // comma    03,17,94
  CWBDB_DATE_SEP_BLANK      = 4;      // blank    03 17 94

  CWBDB_TIME_FMT_HMS        = 0;      // hours minutes seconds
  CWBDB_TIME_FMT_USA        = 1;      // USA
  CWBDB_TIME_FMT_ISO        = 2;      // ISO
  CWBDB_TIME_FMT_EUR        = 3;      // Europe
  CWBDB_TIME_FMT_JIS        = 4;      // Japan

  CWBDB_TIME_SEP_COLON      = 0;      // colon    11:10:03
  CWBDB_TIME_SEP_PERIOD     = 1;      // period   11.10.03
  CWBDB_TIME_SEP_COMMA      = 2;      // comma    11,10,03
  CWBDB_TIME_SEP_BLANK      = 3;      // blank    11 10 03

  CWBDB_DECIMAL_SEP_PERIOD  = 0;      // period     123.45
  CWBDB_DECIMAL_SEP_COMMA   = 1;      // comma      123,45

  CWBDB_NLSS_SORT_HEX       = 0;      // *HEX
  CWBDB_NLSS_SORT_SHARED    = 1;      // *SHARED
  CWBDB_NLSS_SORT_UNIQUE    = 2;      // *UNIQUE
  CWBDB_NLSS_SORT_USER      = 3;      // *USER

  CWBDB_PZ_PC_SIGN          = 0;      // Packed/zoned use PC sign
  CWBDB_PZ_400_SIGN         = 1;      // Packed/zoned use 400 sign

  CWBDB_PZ_LEAVE_UNXLATE    = 0;      // Ignore untranslateble p/z
  CWBDB_PZ_UNXLATE_ERROR    = 1;      // Untranslateble p/z is error

  CWBDB_ADD_LIBRARY_TO_FRONT= 0;      // Add library to front of list
  CWBDB_ADD_LIBRARY_TO_END  = 1;      // Add library to end of list


  CWBDB_UPDATEABLE          = 0;      // Ambiguous Select updateable
  CWBDB_READONLY            = 1;      // Ambiguous Select read only

  CWBDB_CLOSE_ALL_CURSORS   = $F1;    // Close cursor/all result sets
  CWBDB_CLOSE_CURRENT_CURSOR= $F2;    // Close current result set

  CWBDB_PM_INPUT_ONLY       = 1;      // Input only parameter
  CWBDB_PM_INPUT_OUTPUT     = 2;      // Input output parameter
  CWBDB_PM_OUTPUT_ONLY      = 3;      // Output only parameter

  CWBDB_NO_AUTO_COMMIT      = 0;      // Do not perform implicit commits.
  CWBDB_AUTO_COMMIT         = 1;      // Implicit commits will be done.

// The following bit definitions apply to the extended column information returned from
// cwbDB_GetExtendedColumnInfo. The extended column info is a 4-byte field which is mapped below.

// Updatability - column is either writeable or read-only
  CWBDB_COLUMNINFO_UPDATE_READONLY            = $F0000000;
  CWBDB_COLUMNINFO_UPDATE_WRITEABLE           = $F1000000;

// Searchability - these flags are mutually exclusive
  CWBDB_COLUMNINFO_SEARCHABLE_NEVER           = $00F00000;
  CWBDB_COLUMNINFO_SEARCHABLE_LIKEONLY        = $00F10000;  // unused
  CWBDB_COLUMNINFO_SEARCHABLE_ALLEXCEPTLIKE   = $00F20000;
  CWBDB_COLUMNINFO_SEARCHABLE_ALWAYS          = $00F30000;

  CWBDB_COLUMNINFO_IDENTITY_COLUMN            = $00008000; // Identity column

// Column generation mode - Applies to both identity-column types and rowid types.
// Specifies whether it is generated always or by default.
  CWBDB_COLUMNINFO_GENERATION_DEFAULT         = $00004000;
  CWBDB_COLUMNINFO_PARTOFANYINDEX             = $00002000; // Part of any index
  CWBDB_COLUMNINFO_LONEUNIQUEINDEX            = $00001000; // Column comprises a unique index by itself
  CWBDB_COLUMNINFO_PARTOFUNIQUEINDEX          = $00000800; // Column is part of a unique index

// Parameter values for cwbDB_SetExtendedDataFormat
  CWBDB_USE_EXTENDED_FORMAT                   = $F1;       // use extended data fromat
  CWBDB_USE_NORMAL_FORMAT                     = $F0;       // use normal data  format

// CWBNL definitions
  CWBNL_START               = CWB_LAST+1;

  CWBNL_CP_UNICODE_F200   = $0000F200;  // UCS2 Version 1.1
  CWBNL_CP_UNICODE        = $000034B0;  // UCS2 Current Version
  CWBNL_CP_AS400          =         1;  // host code page
  CWBNL_CP_CLIENT_OEM     =         2;  // OEM client code page
  CWBNL_CP_CLIENT_ANSI    =         3;  // ANSI client code page
  CWBNL_CP_UTF8           =      1208;  // UTF-8
  CWBNL_CP_UTF16BE        =      1200;  // UTF-16 (Big-Endian)
  CWBNL_CP_UTF16LE        =      1202;  // UTF-16 (Little-Endian)
  CWBNL_CP_UTF32BE        =      1232;  // UTF-32 (Big-Endian)
  CWBNL_CP_UTF32LE        =      1234;  // UTF-34 (Little-Endian)

  CWBNL_CP_UTF16          = CWBNL_CP_UTF16LE;
  CWBNL_CP_UTF32          = CWBNL_CP_UTF32LE;
  CWBNL_CP_CLIENT_UNICODE = CWBNL_CP_UTF16;  // Little-endian Unicode
  CWBNL_CP_CLIENT   = CWBNL_CP_CLIENT_ANSI;

  CWBNL_ERR_CNV_UNSUPPORTED      = CWBNL_START+101;
  CWBNL_ERR_CNV_TBL_INVALID      = CWBNL_START+102;
  CWBNL_ERR_CNV_TBL_MISSING      = CWBNL_START+103;
  CWBNL_ERR_CNV_ERR_GET          = CWBNL_START+104;
  CWBNL_ERR_CNV_ERR_COMM         = CWBNL_START+105;
  CWBNL_ERR_CNV_ERR_SERVER       = CWBNL_START+106;
  CWBNL_ERR_CNV_ERR_STATUS       = CWBNL_START+107;
  CWBNL_ERROR_CONVERSION_INCOMPLETE_MULTIBYTE_INPUT_CHARACTER = CWBNL_START+108;
  CWBNL_ERR_CNV_INVALID_SISO_STATUS = CWBNL_START+109;
  CWBNL_ERR_CNV_INVALID_PAD_LENGTH  = CWBNL_START+110;

  CWBNL_ERR_STR_TBL_INVALID      = CWBNL_START+201;
  CWBNL_ERR_STR_TBL_MISSING      = CWBNL_START+202;
  CWBNL_ERR_STR_NOT_FOUND        = CWBNL_START+203;
  CWBNL_ERR_NLV_NO_CONFIG        = CWBNL_START+204;
  CWBNL_ERR_NLV_NO_SUBDIR        = CWBNL_START+205;
  CWBNL_DEFAULT_HOST_CCSID_USED  = CWBNL_START+206;

  CWBNL_ERR_LOC_TBL_INVALID      = CWBNL_START+301;
  CWBNL_ERR_LOC_TBL_MISSING      = CWBNL_START+302;
  CWBNL_ERR_LOC_NO_CONFIG        = CWBNL_START+303;
  CWBNL_ERR_LOC_NO_LOCPATH       = CWBNL_START+304;

// CWBOBJ definitions

  CWBOBJ_START              = CWB_LAST+1;
  CWBOBJ_RC_HOST_ERROR      = CWBOBJ_START;      // Error on AS/400
  CWBOBJ_RC_INVALID_TYPE    = CWBOBJ_START + 1;  // Invalid type
  CWBOBJ_RC_INVALID_KEY     = CWBOBJ_START + 2;  // Invalid key
  CWBOBJ_RC_INVALID_INDEX   = CWBOBJ_START + 3;  // Bad index to list
  CWBOBJ_RC_LIST_OPEN       = CWBOBJ_START + 4;  // The list is already opened
  CWBOBJ_RC_LIST_NOT_OPEN   = CWBOBJ_START + 5;  // The list has not been opened
  CWBOBJ_RC_SEEKOUTOFRANGE  = CWBOBJ_START + 6;  // Seek offset is out of range
  CWBOBJ_RC_SPLFNOTOPEN     = CWBOBJ_START + 7;  // Spooled file not opened
  CWBOBJ_RC_RSCNOTOPEN      = CWBOBJ_START + 7;  // Resource not opened
  CWBOBJ_RC_SPLFENDOFFILE   = CWBOBJ_START + 8;  // End of file was reached
  CWBOBJ_RC_ENDOFFILE       = CWBOBJ_START + 8;  // End of file was reached
  CWBOBJ_RC_SPLFNOMESSAGE   = CWBOBJ_START + 9;  // No message for spooled file
  CWBOBJ_RC_KEY_NOT_FOUND   = CWBOBJ_START + 10; // Key not found
  CWBOBJ_RC_NO_EXIT_PGM     = CWBOBJ_START + 11; // No Exit program registered
  CWBOBJ_RC_NOHOSTSUPPORT   = CWBOBJ_START + 12; // Host doesn't support function

// defined keys or attribute ID's
// These are the defined keys to be used with the CWBOBJ_ APIs.

  CWBOBJ_KEY_AFP           = $0000A; //   AFP resources used
  CWBOBJ_KEY_ALIGN         = $0000B; //   Align forms before printing
  CWBOBJ_KEY_ALWDRTPRT     = $0000C; //   Allow direct printing
  CWBOBJ_KEY_AUTHORITY     = $0000D; //   Authority to users not on  output queue
  CWBOBJ_KEY_AUTHCHCK      = $0000E; //   Authority allows user to all files on queue
  CWBOBJ_KEY_LIBRARY       = $0000F; //   Library name
  CWBOBJ_KEY_AUTOEND       = $00010; //   Automatically end writer *YES,*NO
  CWBOBJ_KEY_BKMGN_ACR     = $00011; // f Back margin across
  CWBOBJ_KEY_BKMGN_DWN     = $00012; // f Back margin down
  CWBOBJ_KEY_BKOVRLLIB     = $00013; //   Back side overlay library
  CWBOBJ_KEY_BKOVRLAY      = $00014; //   Back side overlay name
  CWBOBJ_KEY_BKOVL_DWN     = $00015; // f Back overlay offset down
  CWBOBJ_KEY_BKOVL_ACR     = $00016; // f Back overlay offset across
  CWBOBJ_KEY_CPI           = $00017; // f Characters per inch
  CWBOBJ_KEY_CODEDFNTLIB   = $00018; //   Coded font library name
  CWBOBJ_KEY_CODEPAGE      = $00019; //   Code page
  CWBOBJ_KEY_CODEDFNT      = $0001A; //   Coded font
  CWBOBJ_KEY_COPIES        = $0001C; // l Copies (total)
  CWBOBJ_KEY_COPIESLEFT    = $0001D; // l Copies left to produce
  CWBOBJ_KEY_CURPAGE       = $0001E; // l Current page
  CWBOBJ_KEY_DATAFORMAT    = $0001F; //   Data format
  CWBOBJ_KEY_DATAQUELIB    = $00020; //   Data queue library
  CWBOBJ_KEY_DATAQUE       = $00021; //   Data queue associated with output queue
  CWBOBJ_KEY_DATE          = $00022; //   Date file was opened/msg was posted
  CWBOBJ_KEY_DFR_WRITE     = $00023; //   Defer write
  CWBOBJ_KEY_PAGRTT        = $00024; // l Degree of page rotation
  CWBOBJ_KEY_DESTINATION   = $00025; //   Destination type
  CWBOBJ_KEY_DEVCLASS      = $00026; //   Device class
  CWBOBJ_KEY_DEVMODEL      = $00027; //   Device model
  CWBOBJ_KEY_DEVTYPE       = $00028; //   Device type
  CWBOBJ_KEY_DISPLAYANY    = $00029; //   Users can display any file on queue
  CWBOBJ_KEY_DRWRSEP       = $0002A; // l Drawer to use for separators
  CWBOBJ_KEY_ENDPAGE       = $0002B; // l Ending page number to print
  CWBOBJ_KEY_FILESEP       = $0002C; // l Number of file separators
  CWBOBJ_KEY_FOLDREC       = $0002D; //   Wrap text to next line
  CWBOBJ_KEY_FONTID        = $0002E; //   Font identifier to use (default)
  CWBOBJ_KEY_FORMFEED      = $0002F; //   Type of paper  to be used
  CWBOBJ_KEY_FORMTYPE      = $00030; //   Name of the form to be used
  CWBOBJ_KEY_FTMGN_ACR     = $00031; // f Front margin across
  CWBOBJ_KEY_FTMGN_DWN     = $00032; // f Front margin down
  CWBOBJ_KEY_FTOVRLLIB     = $00033; //   Front side overlay library
  CWBOBJ_KEY_FTOVRLAY      = $00034; //   Front side overlay name
  CWBOBJ_KEY_FTOVL_ACR     = $00036; // f Front overlay offset across
  CWBOBJ_KEY_FTOVL_DWN     = $00035; // f Front overlay offset down
  CWBOBJ_KEY_CHAR_ID       = $00037; //   Set of graphic characters for this file
  CWBOBJ_KEY_JUSTIFY       = $00038; // l Hardware justification
  CWBOBJ_KEY_HOLD          = $00039; //   Hold the spool file
  CWBOBJ_KEY_JOBNAME       = $0003B; //   Name of the job that created file
  CWBOBJ_KEY_JOBNUMBER     = $0003C; //   Number of the job that created file
  CWBOBJ_KEY_JOBSEPRATR    = $0003D; // l Number of job separators
  CWBOBJ_KEY_USER          = $0003E; //   Name of the user that created file
  CWBOBJ_KEY_LASTPAGE      = $0003F; // l Last page that printed
  CWBOBJ_KEY_LPI           = $00040; // f Lines per inch
  CWBOBJ_KEY_MFGTYPE       = $00041; //   Manufacturer's type & model
  CWBOBJ_KEY_MAXRECORDS    = $00042; // l Maximum number of records allowed
  CWBOBJ_KEY_FORMTYPEMSG   = $00043; //   Form type message option
  CWBOBJ_KEY_MSGQUELIB     = $00044; //   Message queue library
  CWBOBJ_KEY_NUMFILES      = $00045; // l Total spooled files on output queue
  CWBOBJ_KEY_OPCNTRL       = $00046; //   Operator controlled
  CWBOBJ_KEY_ORDER         = $00047; //   Order on queue (sequence) - *FIFO, *JOBNBR
  CWBOBJ_KEY_OUTPTY        = $00048; //   Output priority
  CWBOBJ_KEY_OUTQUELIB     = $00049; //   Output queue library
  CWBOBJ_KEY_OUTQUE        = $0004A; //   Output queue
  CWBOBJ_KEY_OUTQUESTS     = $0004B; //   output queue status
  CWBOBJ_KEY_OVERFLOW      = $0004C; // l Overflow line number
  CWBOBJ_KEY_PAGELEN       = $0004E; // f Page length
  CWBOBJ_KEY_MEASMETHOD    = $0004F; //   Measurement method (*ROWCOL or *UOM)
  CWBOBJ_KEY_PAGEWIDTH     = $00051; // f Page width
  CWBOBJ_KEY_MULTIUP       = $00052; // l Logical pages per physical side
  CWBOBJ_KEY_POINTSIZE     = $00053; // f The default font's point size
  CWBOBJ_KEY_FIDELITY      = $00054; //   The error handling when printing
  CWBOBJ_KEY_DUPLEX        = $00055; //   Print on both sides of paper
  CWBOBJ_KEY_PRTQUALITY    = $00056; //   Print quality
  CWBOBJ_KEY_PRTSEQUENCE   = $00057; //   Print sequence
  CWBOBJ_KEY_PRTTEXT       = $00058; //   Text printed at bottom of each page
  CWBOBJ_KEY_PRINTER       = $00059; //   Printer device name
  CWBOBJ_KEY_PRTDEVTYPE    = $0005A; //   Printer dev type (data stream type)
  CWBOBJ_KEY_PRTRFILELIB   = $0005B; //   Printer file library
  CWBOBJ_KEY_PRTRFILE      = $0005C; //   Printer file
  CWBOBJ_KEY_RMTPRTQ       = $0005D; //   Remote print queue used on SNDTCPSPLF
  CWBOBJ_KEY_MSGQUE        = $0005E; //   Message queue
  CWBOBJ_KEY_RECLENGTH     = $0005F; // l Record length
  CWBOBJ_KEY_RMTSYSTEM     = $00060; //   Remote system
  CWBOBJ_KEY_RPLUNPRT      = $00061; //   Replace unprintable characters
  CWBOBJ_KEY_RPLCHAR       = $00062; //   Character to replace unprintables with
  CWBOBJ_KEY_RESTART       = $00063; // l Where to restart printing at
  CWBOBJ_KEY_SAVESPLF      = $00064; //   Whether to save after printing or not
  CWBOBJ_KEY_SENDPTY       = $00065; //   Send priority
  CWBOBJ_KEY_SRCDRWR       = $00066; // l Source drawer
  CWBOBJ_KEY_SPOOL         = $00067; //   Spool the data
  CWBOBJ_KEY_SPOOLFILE     = $00068; //   Spool file name
  CWBOBJ_KEY_SPLFNUM       = $00069; // l Spool file number
  CWBOBJ_KEY_SPLFSTATUS    = $0006A; //   Spool file status
  CWBOBJ_KEY_SCHEDULE      = $0006B; //   When available to the writer
  CWBOBJ_KEY_STARTPAGE     = $0006C; // l Starting page to print
  CWBOBJ_KEY_DESCRIPTION   = $0006D; //   Text description
  CWBOBJ_KEY_TIME          = $0006E; //   Time (eg. spooled file was opened at)
  CWBOBJ_KEY_PAGES         = $0006F; // l Number of pages in spool file
  CWBOBJ_KEY_SCS2ASCII     = $00071; //   Transform SCS to ASCII
  CWBOBJ_KEY_UNITOFMEAS    = $00072; //   Unit of measure
  CWBOBJ_KEY_USERCMT       = $00073; //   User comment
  CWBOBJ_KEY_USERDATA      = $00074; //   User data
  CWBOBJ_KEY_TOUSERID      = $00075; //   User id to send spool file to
  CWBOBJ_KEY_TOADDRESS     = $00076; //   Address of user to send file to
  CWBOBJ_KEY_VMMVSCLASS    = $00077; //   VM/MVS SYSOUT class
  CWBOBJ_KEY_WTRAUTOEND    = $00078; //   When to automatically end writer
  CWBOBJ_KEY_WRITER        = $00079; //   Writer job name
  CWBOBJ_KEY_WTRJOBNUM     = $0007A; //   Writer job number
  CWBOBJ_KEY_WTRJOBSTS     = $0007B; //   Writer job status
  CWBOBJ_KEY_WTRJOBUSER    = $0007C; //   Writer job user name
  CWBOBJ_KEY_NUMBYTES      = $0007D; // l Number of bytes to read/write
  CWBOBJ_KEY_SEEKOFF       = $0007E; // l Seek offset
  CWBOBJ_KEY_SEEKORG       = $0007F; // l Seek origin
  CWBOBJ_KEY_MSGTEXT       = $00080; //   Message text
  CWBOBJ_KEY_MSGHELP       = $00081; //   Message help text
  CWBOBJ_KEY_MSGREPLY      = $00082; //   Message reply
  CWBOBJ_KEY_ATTRDEFAULT   = $00083; // * Attribute default value
  CWBOBJ_KEY_ATTRMAX       = $00084; // * Attribute maximum value
  CWBOBJ_KEY_ATTRID        = $00085; // l Attribute ID
  CWBOBJ_KEY_ATTRMIN       = $00086; // * Attribute minimum value
  CWBOBJ_KEY_ATTRPOSSIBL   = $00087; // * Possible value for attribute
  CWBOBJ_KEY_ATTRDESCRIPT  = $00088; //   Attribute description
  CWBOBJ_KEY_ATTRTYPE      = $00089; // l Attribute type
  CWBOBJ_KEY_NPSCCSID      = $0008A; // l Server CCSID
  CWBOBJ_KEY_NPSOBJECT     = $0008B; // l Object ID
  CWBOBJ_KEY_NPSACTION     = $0008C; // l Action ID
  CWBOBJ_KEY_NPSLEVEL      = $0008D; //   Server code level
  CWBOBJ_KEY_MSGTYPE       = $0008E; //   Message type
  CWBOBJ_KEY_WTRSTRPAGE    = $0008F; // l Page to start the writer on
  CWBOBJ_KEY_WTREND        = $00090; //   When to end the writer
  CWBOBJ_KEY_NUMWRITERS    = $00091; // l Number of writers started to queue
  CWBOBJ_KEY_MSGID         = $00093; //   Message ID
  CWBOBJ_KEY_INTERNETADDR  = $00094; //   Internet address
  CWBOBJ_KEY_WSCUSTMOBJ    = $00095; //   Workstation customizing object
  CWBOBJ_KEY_WSCUSTMOBJL   = $00096; //   Workstation customizing object library
  CWBOBJ_KEY_DELETESPLF    = $00097; //   Delete file after sending?
  CWBOBJ_KEY_DESTOPTION    = $00098; //   Destinaton option sent
  CWBOBJ_KEY_DBCSDATA      = $00099; //   Contains DBCS character set data
  CWBOBJ_KEY_DBCSEXTENSN   = $0009A; //   Process DBCS extension characters
  CWBOBJ_KEY_DBCSROTATE    = $0009B; //   Rotate DBCS characters
  CWBOBJ_KEY_DBCSCPI       = $0009C; // l DBCS CPI
  CWBOBJ_KEY_DBCSSISO      = $0009D; //   DBCS SI/SO positioning
  CWBOBJ_KEY_HOLDTYPE      = $0009E; //   When to hold spooled file
  CWBOBJ_KEY_MSGSEV        = $0009F; // l Message severity
  CWBOBJ_KEY_OPENCMDS      = $000A0; //
  CWBOBJ_KEY_SEPPAGE       = $000A1; //   Print banner page or not
  CWBOBJ_KEY_USRDFNDTA     = $000A2; //   User defined data
  CWBOBJ_KEY_USRDFNOPTS    = $000A3; //   User defined options
  CWBOBJ_KEY_USRDFNOBJLIB  = $000A4; //   User defined object library
  CWBOBJ_KEY_USRDFNOBJ     = $000A5; //   User defined object
  CWBOBJ_KEY_USRDFNOBJTYP  = $000A6; //   User defined object type
  CWBOBJ_KEY_USRTFMPGMLIB  = $000A7; //   User data transform program library
  CWBOBJ_KEY_USRTFMPGM     = $000A8; //   User data transform program
  CWBOBJ_KEY_USRDRVPGMDTA  = $000A9; //   User driver program data
  CWBOBJ_KEY_USRDRVPGMLIB  = $000AA; //   User driver program library
  CWBOBJ_KEY_USRDRVPGM     = $000AB; //   User driver program
  CWBOBJ_KEY_WTRINIT       = $000AC; //   When to initialize the printer device
  CWBOBJ_KEY_SPLSCS        = $000AD; // l Type of SCS spooling to do
  CWBOBJ_KEY_RSCLIB        = $000AE; //   Resource library name
  CWBOBJ_KEY_RSCNAME       = $000AF; //   Resource name
  CWBOBJ_KEY_RSCTYPE       = $000B0; // l Resource object type
  CWBOBJ_KEY_OBJEXTATTR    = $000B1; //   Object extended attribute
  CWBOBJ_KEY_PELDENSITY    = $000B2; //   Font Pel Density "1"=240;"2"=300;
  CWBOBJ_KEY_RSCAVAIL      = $000B3; //  Resource available?                    @B1A
  CWBOBJ_KEY_NPSNLV        = $000B4; //  NPS NLV ("2924") .                     @B1A
  CWBOBJ_KEY_INSERT_5A     = $000B5; //  Insert 5A?                             @B1A
  CWBOBJ_KEY_FORMDEF       = $000B6; //  Formdef name                           @B1A
  CWBOBJ_KEY_FORMDEFLIB    = $000B7; //  Formdef library                        @B1A
  CWBOBJ_KEY_PRECMPT_SIZE  = $000B8; //  Precompute the number of bytes?        @B1A
  CWBOBJ_KEY_DEV_OUTTYPE   = $000B9; // Type of output device ie printer,tape @F1A
  CWBOBJ_KEY_PRT_ASSIGNED  = $000BA; // Indicates how printer is assigned     @F1A
  CWBOBJ_KEY_WRITING_STAT  = $000BB; // Indicates whether writer is writing   @F1A
  CWBOBJ_KEY_SYS_WHERE_CRT = $000BC; // System where spooled file was created @F1A
  CWBOBJ_KEY_NETWORK_ID    = $000BD; // Network Id where file created         @F1A
  CWBOBJ_KEY_ALIGN_FORMS   = $000BE; // Time when align forms msg will be sen @F1A
  CWBOBJ_KEY_CHANGES_TIME  = $000BF; // Time changes take affect              @F1A
  CWBOBJ_KEY_OUTPUT_BIN    = $000C0; // Output bin used by printer            @F1A
  CWBOBJ_KEY_WRITER_START  = $000C1; // Indicates whether writer is started   @F1A
  CWBOBJ_KEY_REDUCE_OUPUT  = $000C2; // Indicates how logical pages print     @F1A
  CWBOBJ_KEY_LINE_SPACING  = $000C3; // Type of line spacing used             @F1A
  CWBOBJ_KEY_CONTROL_CHAR  = $000C4; // File contains ANS control chars?      @F1A
  CWBOBJ_KEY_WRITER_USER   = $000C5; // User writer was started by            @F1A
  CWBOBJ_KEY_API_CREATED   = $000C6; // Whether spooled file was create by API@F1A
  CWBOBJ_KEY_DEVICE_STATUS = $000C7; // Printer device status                 @F1A
  CWBOBJ_KEY_LOGICAL_STAT  = $000C8; // Logical status of printer             @F1A
  CWBOBJ_KEY_WAITING_DEV   = $000C9; // Waiting for device status             @F1A
  CWBOBJ_KEY_WAITING_MSG   = $000CA; // Waiting for message status            @F1A
  CWBOBJ_KEY_WAITING_DATA  = $000CB; // Waiting for data status of writer     @F1A
  CWBOBJ_KEY_END_PENDING   = $000CC; // End writer pending status             @F1A
  CWBOBJ_KEY_ON_JOB_QUEUE  = $000CD; // Indicates whether writer is on job que@F1A
  CWBOBJ_KEY_BTWEEN_COPIES = $000CE; // Writer between copies yes or no?      @F1A
  CWBOBJ_KEY_BTWEEN_FILES  = $000CF; // Writer between files yes or no?       @F1A
  CWBOBJ_KEY_HELD_STATUS   = $000D0; // Writer held yes or no?                @F1A
  CWBOBJ_KEY_HOLD_PENDING  = $000D1; // Hold pending status                   @F1A
  CWBOBJ_KEY_INIT_PRINTER  = $000D2; // Specify time to initialize printer    @F1A
  CWBOBJ_KEY_ENVELOPE_SIZE = $000D3; // Size of envelope                      @F1A
  CWBOBJ_KEY_PAPER_SOURCE1 = $000D4; // Size of paper in paper source 1       @F1A
  CWBOBJ_KEY_PAPER_SOURCE2 = $000D5; // Size of paper in paper source 2       @F1A
  CWBOBJ_KEY_PAGE_AT_TIME  = $000D6; // Open file to be read a page a time    @F1A
  CWBOBJ_KEY_PAGE_NUMBER   = $000D7; // Page number to be read page at a time @F1A
  CWBOBJ_KEY_VIEW_FIDELITY = $000D8; // Type of viewing fidelity requested    @F1A
  CWBOBJ_KEY_NUMBYTES_LRG  = $000D9; // Number of bytes in large files>2**31-1@F1A
  CWBOBJ_KEY_ESTIMATED_CNT = $000DA; // Page count estimated yes or no?       @F1A
  CWBOBJ_KEY_SEEK_OFF_LRG  = $000DB; // Seek offset for large files           @F1A
  CWBOBJ_KEY_ITEM_REP_CAP  = $000DC; // Return multiple items per reply       @F1A
  CWBOBJ_KEY_USER_CMT_LST  = $000DD; // Surpress user comment                 @F1A
  CWBOBJ_KEY_MAX_JOBS      = $000DE; // Max number of jobs to return in list  @F1A
  CWBOBJ_KEY_SEQ_READ      = $000DF; // Open spoolfile for sequential read    @F1A

  CWBOBJ_KEY_LASTKEY = CWBOBJ_KEY_SEQ_READ;


// define the possible data types for an attribute
// CWBOBJ_TYPE_SHORT is a two byte, unsigned, integer number
// CWBOBJ_TYPE_LONG is a four byte, unsigned, integer number
// CWBOBJ_TYPE_STRING is a null-terminated string.
// CWBOBJ_TYPE_FLOAT is a 4 byte floating point number in IEEE format
// CWBOBJ_TYPE_STRLIST is a list of null-terminated strings ending
//                     with an extra null byte.

  CWBOBJ_TYPE_SHORT    = $00001; // unsigned short integer
  CWBOBJ_TYPE_LONG     = $00002; // unsigned long integer
  CWBOBJ_TYPE_STRING   = $00003; // null-terminated string
  CWBOBJ_TYPE_FLOAT    = $00004; // IEEE floating point value
  CWBOBJ_TYPE_BINARY   = $00005; // binary data
  CWBOBJ_TYPE_STRLIST  = $00006; // list of strings


// different types of lists allowed

  CWBOBJ_LIST_SPLF  = $00001;   // list spooled files
  CWBOBJ_LIST_OUTQ  = $00002;   // list output queues
  CWBOBJ_LIST_PRTD  = $00003;   // list printer devices
  CWBOBJ_LIST_PRTF  = $00004;   // list printer files
  CWBOBJ_LIST_WTR   = $00005;   // list writers
  CWBOBJ_LIST_LIB   = $00006;   // list libraries
  CWBOBJ_LIST_RSC   = $00007;   // list afp resources

// types of AFP resources allowed.  Values can be OR'd together to
// provide input for listing multiple resource types or used alone
// to provide the type of one particular resource
  CWBOBJ_AFPRSC_FONT     = $00001; // Font resource
  CWBOBJ_AFPRSC_FORMDEF  = $00002; // Form definition
  CWBOBJ_AFPRSC_OVERLAY  = $00004; // Overlay
  CWBOBJ_AFPRSC_PAGESEG  = $00008; // Pagesegment
  CWBOBJ_AFPRSC_PAGEDEF  = $00010; // Page Definition

// Different types of list openings allowed
//  For the first release only synchronous list are allowed.
//
//  CWBOBJ_LIST_OPEN_SYNCHRONOUS - open the list synchronously. The
//   cwbOBJ_OpenList() API will not return until the list is built.
  CWBOBJ_LIST_OPEN_SYNCH  = $00001; // open list synchronously

// status that a list can be in
  CWBOBJ_LISTSTS_COMPLETED   = $00001; // list completely built
  CWBOBJ_LISTSTS_NOTDONEYET  = $00002; // list not yet done

// enumerated origins for seeking when reading a spooled file.
  CWBOBJ_SEEK_BEGINNING  = $00001;     // from beginning of file
  CWBOBJ_SEEK_CURRENT    = $00002;     // from current read position
  CWBOBJ_SEEK_ENDING     = $00003;     // from ending of file

// define the possible spooled file data types
  CWBOBJ_DT_USERASCII  = $00001; // *USERASCII default ascii transparent data
  CWBOBJ_DT_SCS        = $00002; // *SCS       SCS data
  CWBOBJ_DT_AFP        = $00003; // *AFPDS     AFP data

// define the possible spool SCS values - used when creating a new
// spooled file.
// CWBOBJ_SPLSCS_NO - file contains no SCS data
// CWBOBJ_SPLSCS_YES - file has SCS data
// CWBOBJ_SPLSCS_PASSTHRU - unsupported SCS cmds are passed thru
  CWBOBJ_SPLSCS_NO        = $00000; // NO SCS
  CWBOBJ_SPLSCS_YES       = $00001; // SCS
  CWBOBJ_SPLSCS_PASSTHRU  = $00002; // Passthru all SCS cmds

// define bits that can be turned on in the flags parameter to the
// cwbOBJ_DisplaySplF() API.
  CWBOBJ_DSPSPLF_WAIT   = $00001;   // Wait for viewer

  CWBCO_SERVICE_CENTRAL             = 1;
  CWBCO_SERVICE_NETFILE             = 2;
  CWBCO_SERVICE_NETPRINT            = 3;
  CWBCO_SERVICE_DATABASE            = 4;
  CWBCO_SERVICE_ODBC                = 5;
  CWBCO_SERVICE_DATAQUEUES          = 6;
  CWBCO_SERVICE_REMOTECMD           = 7;
  CWBCO_SERVICE_SECURITY            = 8;
  CWBCO_SERVICE_DDM                 = 9;
  CWBCO_SERVICE_MAPI                = 10;
  CWBCO_SERVICE_USF                 = 11;
  CWBCO_SERVICE_WEB_ADMIN           = 12;
  CWBCO_SERVICE_TELNET              = 13;
  CWBCO_SERVICE_MGMT_CENTRAL        = 14;
  CWBCO_SERVICE_ANY                 = 100;         // Apply to ANY service
  CWBCO_SERVICE_ALL                 = 101;         // Apply to ALL services

  CWBCO_PROMPT_IF_NECESSARY         = 0;
  CWBCO_PROMPT_ALWAYS               = 1;
  CWBCO_PROMPT_NEVER                = 2;
  CWBCO_PROMPT_DEFAULT              = CWBCO_PROMPT_IF_NECESSARY;

  CWBCO_VALIDATE_IF_NECESSARY       = 0;
  CWBCO_VALIDATE_ALWAYS             = 1;
  CWBCO_VALIDATE_DEFAULT            = CWBCO_VALIDATE_IF_NECESSARY;

  CWBCO_DEFAULT_USER_MODE_NOT_SET   = 0;  // not set, user may be prompted
  CWBCO_DEFAULT_USER_USE            = 1;
  CWBCO_DEFAULT_USER_IGNORE         = 2;
  CWBCO_DEFAULT_USER_USEWINLOGON    = 3;
  CWBCO_DEFAULT_USER_DEFAULT        = CWBCO_DEFAULT_USER_MODE_NOT_SET;

  CWBCO_IPADDR_LOOKUP_ALWAYS        = 0;
  CWBCO_IPADDR_LOOKUP_1HOUR         = 1;
  CWBCO_IPADDR_LOOKUP_1DAY          = 2;
  CWBCO_IPADDR_LOOKUP_1WEEK         = 3;
  CWBCO_IPADDR_LOOKUP_NEVER         = 4;
  CWBCO_IPADDR_LOOKUP_AFTER_STARTUP = 5;
  CWBCO_IPADDR_LOOKUP_DEFAULT       = CWBCO_IPADDR_LOOKUP_ALWAYS;

  CWBCO_PORT_LOOKUP_SERVER        = 0;   // ask AS/400 server mapper
  CWBCO_PORT_LOOKUP_LOCAL         = 1;   // look in PC services file
  CWBCO_PORT_LOOKUP_STANDARD      = 2;   // use standard port
  CWBCO_PORT_LOOKUP_DEFAULT       = CWBCO_PORT_LOOKUP_SERVER;

  CWBCO_MAY_MAKE_PERSISTENT       = 0;
  CWBCO_MAY_NOT_MAKE_PERSISTENT   = 1;
  CWBCO_PERSISTENCE_DEFAULT       = CWBCO_MAY_MAKE_PERSISTENT;

  CWBCO_USE_SECURE_SOCKETS        = CWB_TRUE;
  CWBCO_DO_NOT_USE_SECURE_SOCKETS = CWB_FALSE;
  CWBCO_SECURE_SOCKETS_DEFAULT    = CWBCO_DO_NOT_USE_SECURE_SOCKETS;

  CWBCO_MAX_USER_ID               = 10;
  CWBCO_MAX_SYS_NAME              = 255;
  CWBCO_MAX_SYS_DESCRIPTION       = 256;
  CWBCO_MAX_ENV_NAME              = 50;
  CWBCO_MAX_SERVICE_NAME          = 32;
  CWBCO_MAX_IP_ADDRESS            = 15;
  CWBCO_MAX_SSL_PASSWORD          = 128;

  CWBCO_MAX_PASSWORD              = 256; // bytes
  CWBCO_MAX_PASSWORD_BYTES        = CWBCO_MAX_PASSWORD; // bytes

  CWBCO_CONNECT_TIMEOUT_MIN       = 1;    // Minimum is 1 second
  CWBCO_CONNECT_TIMEOUT_MAX       = 3600; // Maximum is 1 hour
  CWBCO_CONNECT_TIMEOUT_DEFAULT   = 30;   // Default is 30 seconds
  CWBCO_CONNECT_TIMEOUT_NONE      = 0;    // 0 means do not timeout

// CWBSO* stuff

  CWBSO_NULL_HANDLE               = 0;  // Null handle (returned in low memory)

// error codes from APIs

  CWBSO_NO_ERROR                  = 0;      // No error occurred
  CWBSO_ERROR_OCCURRED            = 1;      // Check errorHandle parameter
  CWBSO_LOW_MEMORY                = 2;      // Cannot allocate enough memory
  CWBSO_BAD_LISTTYPE              = 3;      // List type specified not valid
  CWBSO_BAD_HANDLE                = 4;      // Handle specified is not valid
  CWBSO_BAD_LIST_HANDLE           = 5;      // Handle specified is not valid list handle
  CWBSO_BAD_OBJ_HANDLE            = 6;      // Handle specified is not valid object handle
  CWBSO_BAD_PARMOBJ_HANDLE        = 7;      // Handle specified is not valid parameter object handle
  CWBSO_BAD_ERR_HANDLE            = 8;      // Handle specified is not valid error handle
  CWBSO_BAD_LIST_POSITION         = 9;      // List position is not valid. Either less than zero or greater than liust size
  CWBSO_BAD_ACTION_ID             = 10;     // Action ID specified is not valid for this list
  CWBSO_NOT_ALLOWED_NOW           = 11;     // Function is not allowed at this time for this object
  CWBSO_BAD_INCLUDE_ID            = 12;     // Filter ID specified is not valid for this list
  CWBSO_DISP_MSG_FAILED           = 13;     // Display of error message failed
  CWBSO_GET_MSG_FAILED            = 14;     // Get error message text failed
  CWBSO_BAD_SORT_ID               = 15;     // Attribute ID for sorting is not valid for this list
  CWBSO_INTERNAL_ERROR            = 16;     // Internal processing error
  CWBSO_NO_ERROR_MESSAGE          = 17;     // There is no error message for the error handle specified
  CWBSO_BAD_ATTRIBUTE_ID          = 18;     // Attribute ID specified is not valid
  CWBSO_BAD_TITLE                 = 19;     // Title specified is not valid
  CWBSO_BAD_FILTER_VALUE          = 20;     // Filter value is not valid
  CWBSO_BAD_PROFILE_NAME          = 21;     // Profile name is not valid
  CWBSO_DISPLAY_FAILED            = 22;     // Display request failed
  CWBSO_SORT_NOT_ALLOWED          = 23;     // List can not be sorted
  CWBSO_CANNOT_CHANGE_ATTR        = 24;     // Object attribute cannot be changed
  CWBSO_CANNOT_READ_PROFILE       = 25;     // Cannot read from profile
  CWBSO_CANNOT_WRITE_PROFILE      = 26;     // Cannot write to profile
  CWBSO_BAD_SYSTEM_NAME           = 27;     // System name specified is not valid
  CWBSO_SYSTEM_NAME_DEFAULTED     = 28;     // Default system name was used
  CWBSO_BAD_FILTER_ID             = 29;     // Filter id is not valid
  CWBSO_BAD_OBJTYPE               = 30;     // Object type not valid
  CWBSO_DISPLAY_NOT_SUPPORTED     = 31;     // Display is not valid for this list type

// Menu action IDs (for pulldown and toolbar actions) for the CWBSO_DisallowListActions API
                                            // Object:      sfl job prt msg
  CWBSO_ACTN_PRINTNEXT            = 301;    //               Y
  CWBSO_ACTN_SEND                 = 302;    //               Y
  CWBSO_ACTN_HOLD                 = 303;    //               Y   Y   Y
  CWBSO_ACTN_DELETE               = 304;    //               Y   Y       Y
  CWBSO_ACTN_OPEN                 = 305;    //               Y           Y
  CWBSO_ACTN_RELEASE              = 306;    //               Y   Y   Y
  CWBSO_ACTN_PROPERTIES           = 307;    //               Y   Y   Y   Y
  CWBSO_ACTN_MSGWTG               = 308;    //               Y   Y   Y   Y
  CWBSO_ACTN_HELP                 = 309;    //               Y   Y   Y   Y
  CWBSO_ACTN_MOVE                 = 310;    //               Y   Y
  CWBSO_ACTN_RESTART              = 311;    //               Y       Y
  CWBSO_ACTN_PRINTEROUTPUT        = 312;    //                   Y   Y
  CWBSO_ACTN_JOBLOG               = 313;    //                   Y
  CWBSO_ACTN_START                = 315;    //                       Y
  CWBSO_ACTN_STOP                 = 316;    //                       Y
  CWBSO_ACTN_MAKEAVAILABLE        = 317;    //                       Y
  CWBSO_ACTN_MAKEUNAVAILABLE      = 318;    //                       Y
  CWBSO_ACTN_PUBLISH              = 319;    //                       Y
  CWBSO_ACTN_UNPUBLISH            = 320;    //                       Y

Type

  // Types of lists allowed
  CWBSO_LISTTYPE = (
    CWBSO_LIST_PRT  = $0001,                // list printer devices
    CWBSO_LIST_SFL  = $0002,                // list spooled files
    CWBSO_LIST_MSG  = $0003,                // list messages
    CWBSO_LIST_JOB  = $0004,                // list jobs
    CWBSO_LIST_SJOB = $0005,                // list server jobs
    CWBSO_LIST_IFC  = $0006,                // list interfaces
    CWBSO_LIST_ELN  = $0007,                // list ethernet lines
    CWBSO_LIST_TLN  = $0008,                // list token ring lines
    CWBSO_LIST_HW   = $0009,                // list hardware resources
    CWBSO_LIST_SW   = $000A,                // list software products
    CWBSO_LIST_RTE  = $000B,                // list TCP/IP routes
    CWBSO_LIST_PRF  = $000C,                // list user profiles
    CWBSO_LIST_SMP  = $000D,                // list libraries in QSYS
    CWBSO_LIST_DUMMY= $7FFF                 // Force two bytes
  );

  // types of objects allowed
  CWBSO_OBJTYPE = (CWBSO_OBJ_TCA = $0011);  // TCPIP Attributes

Const
  CWBSO_JOB_JobName                         = $0000; // QUSRJOBI
  CWBSO_JOB_UserName                        = $0001; // QUSRJOBI
  CWBSO_JOB_JobNumber                       = $0002; // QUSRJOBI
  CWBSO_JOB_JobType                         = $0003; // QUSRJOBI
  CWBSO_JOB_JobSubtype                      = $0004; // QUSRJOBI
  CWBSO_JOB_JobStatus                       = $0005; // QUSRJOBI
  CWBSO_JOB_DateEnteredSystem               = $0006; // QUSRJOBI  Date and time job entered system
  CWBSO_JOB_TimeEnteredSystem               = $0007; // QUSRJOBI  Date and time job entered system
  CWBSO_JOB_DateStarted                     = $0008; // QUSRJOBI  Date and time job became active
  CWBSO_JOB_TimeStarted                     = $0009; // QUSRJOBI  Date and time job became active
  CWBSO_JOB_JobDescriptionName              = $000A; // QUSRJOBI
  CWBSO_JOB_JobDescriptionLibrary           = $000B; // QUSRJOBI
  CWBSO_JOB_SubmittedByJobName              = $000C; // QUSRJOBI  Submitter's job name
  CWBSO_JOB_SubmittedByUser                 = $000D; // QUSRJOBI  Submitter's user name
  CWBSO_JOB_SubmittedByJobNumber            = $000E; // QUSRJOBI  Submitter's job number
  CWBSO_JOB_JobQueueName                    = $000F; // QUSRJOBI
  CWBSO_JOB_JobQueueLibrary                 = $0010; // QUSRJOBI
  CWBSO_JOB_PriorityOnJobQueue              = $0011; // QUSRJOBI  Job queue priority
  CWBSO_JOB_JobQueueDate                    = $0013; // QUSRJOBI  Date and time the job was put on this job queue
  CWBSO_JOB_JobQueueTime                    = $0014; // QUSRJOBI  Date and time the job was put on this job queue
  CWBSO_JOB_PriorityOnOutputQueue           = $0015; // QUSRJOBI  Output queue priority
  CWBSO_JOB_Printer                         = $0016; // QUSRJOBI  Printer device name
  CWBSO_JOB_OutputQueueName                 = $0017; // QUSRJOBI
  CWBSO_JOB_OutputQueueLibrary              = $0018; // QUSRJOBI
  CWBSO_JOB_PrintText                       = $0019; // QUSRJOBI
  CWBSO_JOB_PrintKeyFormat                  = $001A; // QUSRJOBI
  CWBSO_JOB_RunPriority                     = $001B; // QUSRJOBI
  CWBSO_JOB_SubsystemName                   = $001C; // QUSRJOBI  Subsystem description name
  CWBSO_JOB_SubsystemLibrary                = $001D; // QUSRJOBI  Subsystem description library name
  CWBSO_JOB_SystemPoolId                    = $001E; // QUSRJOBI
  CWBSO_JOB_CurrentUser                     = $001F; // QUSRJOBI  Current user profile
  CWBSO_JOB_SpecialEnvironment              = $0020; // QUSRJOBI
  CWBSO_JOB_MaxCpuTime                      = $0021; // QUSRJOBI  Maximum processing unit time
  CWBSO_JOB_CpuTimeUsed                     = $0022; // QUSRJOBI  Processing unit used
  CWBSO_JOB_MaxTempStorage                  = $0023; // QUSRJOBI  Maximum temporary storage
  CWBSO_JOB_TempStorageUsed                 = $0024; // QUSRJOBI  Temporary storage used
  CWBSO_JOB_AuxiliaryIORequests             = $0025; // QUSRJOBI  Number of auxiliary I/O requests
  CWBSO_JOB_InteractiveTransactions         = $0026; // QUSRJOBI  Number of interactive transactions
  CWBSO_JOB_TotalResponseTime               = $0027; // QUSRJOBI  Response time total
  CWBSO_JOB_TimeSlice                       = $0028; // QUSRJOBI
  CWBSO_JOB_TimeSliceEndPool                = $0029; // QUSRJOBI
  CWBSO_JOB_EligibleForPurge                = $002A; // QUSRJOBI  Purge
  CWBSO_JOB_DefaultWaitTime                 = $002B; // QUSRJOBI  Default wait
  CWBSO_JOB_ProductReturnCode               = $002C; // QUSRJOBI
  CWBSO_JOB_UserReturnCode                  = $002D; // QUSRJOBI
  CWBSO_JOB_ProgramReturnCode               = $002E; // QUSRJOBI
  CWBSO_JOB_ControlledEndRequested          = $002F; // QUSRJOBI  End status
  CWBSO_JOB_SwitchSettings                  = $0030; // QUSRJOBI  Job switches
  CWBSO_JOB_BreakMessageHandling            = $0031; // QUSRJOBI
  CWBSO_JOB_StatusMessageHandling           = $0032; // QUSRJOBI
  CWBSO_JOB_InquiryMessageReply             = $0033; // QUSRJOBI
  CWBSO_JOB_EndSeverity                     = $0034; // QUSRJOBI
  CWBSO_JOB_LogCLPrograms                   = $0035; // QUSRJOBI  Logging of CL programs
  CWBSO_JOB_MessageLoggingLevel             = $0036; // QUSRJOBI  Logging level
  CWBSO_JOB_MessageSeverityLevel            = $0037; // QUSRJOBI  Logging severity
  CWBSO_JOB_MessageInfoLogged               = $0038; // QUSRJOBI  Logging text
  CWBSO_JOB_MessageQueueMaxSize             = $0039; // QUSRJOBI  Job message queue maximum size
  CWBSO_JOB_MessageQueueAction              = $003A; // QUSRJOBI  Job message queue full action
  CWBSO_JOB_JobDate                         = $003B; // QUSRJOBI
  CWBSO_JOB_DateFormat                      = $003C; // QUSRJOBI
  CWBSO_JOB_DateSeparator                   = $003D; // QUSRJOBI
  CWBSO_JOB_TimeSeparator                   = $003E; // QUSRJOBI
  CWBSO_JOB_ScheduleDate                    = $0040; // QUSRJOBI  Date and time job is scheduled to run
  CWBSO_JOB_ScheduleTime                    = $0041; // QUSRJOBI  Date and time job is scheduled to run
  CWBSO_JOB_LanguageId                      = $0042; // QUSRJOBI
  CWBSO_JOB_CountryId                       = $0043; // QUSRJOBI
  CWBSO_JOB_SortSequenceTable               = $0044; // QUSRJOBI
  CWBSO_JOB_SortSequenceLibrary             = $0045; // QUSRJOBI
  CWBSO_JOB_CCSID                           = $0046; // QUSRJOBI  Coded character set ID
  CWBSO_JOB_DefaultCCSID                    = $0047; // QUSRJOBI  Default coded character set identifier
  CWBSO_JOB_DbcsCapable                     = $0048; // QUSRJOBI
  CWBSO_JOB_NetworkId                       = $0049; // QUSRJOBI  Unit of work ID
  CWBSO_JOB_LocationName                    = $004A; // QUSRJOBI  Unit of work ID
  CWBSO_JOB_Instance                        = $004B; // QUSRJOBI  Unit of work ID
  CWBSO_JOB_SequenceNumber                  = $004C; // QUSRJOBI  Unit of work ID
  CWBSO_JOB_Mode                            = $004D; // QUSRJOBI  Mode name
  CWBSO_JOB_DeviceRecoveryAction            = $004E; // QUSRJOBI
  CWBSO_JOB_KeepDDMConnectionsActive        = $004F; // QUSRJOBI  DDM conversation handling
  CWBSO_JOB_AccountingCode                  = $0050; // QUSRJOBI  Job accounting code
  CWBSO_JOB_ActiveJobStatus                 = $0051; // QUSRJOBI
  CWBSO_JOB_FunctionType                    = $0052; // QUSRJOBI
  CWBSO_JOB_FunctionName                    = $0053; // QUSRJOBI
  CWBSO_JOB_JobQueueStatus                  = $0054; // QUSRJOBI  Status of job on the job queue
  CWBSO_JOB_JobInformationStatus            = $0055; // QUSLJOB
  CWBSO_JOB_RoutingData                     = $0056; // QUSRJOBI
  CWBSO_JOB_CurrentSystemPoolId             = $0057; // QUSRJOBI
  CWBSO_JOB_ThreadCount                     = $0058; // QUSRJOBI
  CWBSO_JOB_DecimalFormat                   = $0059; // QUSRJOBI
  CWBSO_JOB_ServerType                      = $005A; // QUSRJOBI

// Job Sort IDs for CWBSO_SetListSortFields API
  CWBSO_JOB_SORT_Name                     = CWBSO_JOB_JobName;
  CWBSO_JOB_SORT_User                     = CWBSO_JOB_UserName;
  CWBSO_JOB_SORT_Number                   = CWBSO_JOB_JobNumber;
  CWBSO_JOB_SORT_Type                     = CWBSO_JOB_JobType;
  CWBSO_JOB_SORT_Subtype                  = CWBSO_JOB_JobSubtype;
  CWBSO_JOB_SORT_Status                   = CWBSO_JOB_JobStatus;
  CWBSO_JOB_SORT_Date                     = CWBSO_JOB_DateEnteredSystem;
  CWBSO_JOB_SORT_Time                     = CWBSO_JOB_TimeEnteredSystem;
  CWBSO_JOB_SORT_JobQ                     = CWBSO_JOB_JobQueueName;
  CWBSO_JOB_SORT_JobQLib                  = CWBSO_JOB_JobQueueLibrary;
  CWBSO_JOB_SORT_JobQPriority             = CWBSO_JOB_PriorityOnJobQueue;
  CWBSO_JOB_SORT_OutQPriority             = CWBSO_JOB_PriorityOnOutputQueue;
  CWBSO_JOB_SORT_RunPriority              = CWBSO_JOB_RunPriority;
  CWBSO_JOB_SORT_Sbs                      = CWBSO_JOB_SubsystemName;
  CWBSO_JOB_SORT_SbsLib                   = CWBSO_JOB_SubsystemLibrary;
  CWBSO_JOB_SORT_PoolId                   = CWBSO_JOB_SystemPoolId;
  CWBSO_JOB_SORT_CpuUsed                  = CWBSO_JOB_CpuTimeUsed;
  CWBSO_JOB_SORT_AuxIO                    = CWBSO_JOB_AuxiliaryIORequests;
  CWBSO_JOB_SORT_Transactions             = CWBSO_JOB_InteractiveTransactions;
  CWBSO_JOB_SORT_ResponseTime             = CWBSO_JOB_TotalResponseTime;

// Job List Filter Attribute IDs for CWBSO_SetListFilter API
  CWBSO_JOBF_JobNameFilter                =   $0000;
  CWBSO_JOBF_JobUserFilter                =   $0001;
  CWBSO_JOBF_JobNumberFilter              =   $0002;
  CWBSO_JOBF_JobTypeFilter                =   $0003;
  CWBSO_JOBF_JobQueueFilter               =   $0006;
  CWBSO_JOBF_JobsOnJobQueueFilter         =   $000A;
  CWBSO_JOBF_ActiveJobsFilter             =   $000C;
  CWBSO_JOBF_CompletedJobsFilter          =   $000E;

// Server Job filter IDs
  CWBSO_SJOBF_JobNameFilter               =   $0000;
  CWBSO_SJOBF_JobUserFilter               =   $0001;
  CWBSO_SJOBF_JobNumberFilter             =   $0002;
  CWBSO_SJOBF_JobTypeFilter               =   $0003;
  CWBSO_SJOBF_PrimaryStatusFilter         =   $0019;
  CWBSO_SJOBF_CurrentUserFilter           =   $001D;
  CWBSO_SJOBF_ServerTypeFilter            =   $001E;

// Message Attribute IDs
  CWBSO_MSG_MessageSeverity                 = $0000;  // QMHLSTM
  CWBSO_MSG_MessageIdentifier               = $0001;  // QMHLSTM
  CWBSO_MSG_MessageType                     = $0002;  // QMHLSTM
  CWBSO_MSG_MessageKey                      = $0003;  // QMHLSTM
  CWBSO_MSG_MessageFileName                 = $0004;  // QMHLSTM
  CWBSO_MSG_MessageFileLibrary              = $0005;  // QMHLSTM   Message file library specified at send time
  CWBSO_MSG_MessageQueueName                = $0006;  // QMHLSTM
  CWBSO_MSG_MessageQueueLibrary             = $0007;  // QMHLSTM
  CWBSO_MSG_DateSent                        = $0008;  // QMHLSTM
  CWBSO_MSG_TimeSent                        = $0009;  // QMHLSTM
  CWBSO_MSG_MessageText                     = $000A;  // QMHLSTM   Message with replacement data
  CWBSO_MSG_SenderJobName                   = $000B;  // QMHLSTM   Qualified sender job name
  CWBSO_MSG_SenderUserName                  = $000C;  // QMHLSTM   Qualified sender job name
  CWBSO_MSG_SenderJobNumber                 = $000D;  // QMHLSTM   Qualified sender job name
  CWBSO_MSG_SendingProgramName              = $000E;  // QMHLSTM
  CWBSO_MSG_ReplyStatus                     = $000F;  // QMHLSTM
  CWBSO_MSG_DefaultReply                    = $0010;  // QMHLSTM
  CWBSO_MSG_MessageHelp                     = $0011;  // QMHLSTM   Message help with replacement data

// Message List Filter Attribute IDs
   CWBSO_MSGF_SeverityCriteria              = $0002;
   CWBSO_MSGF_UserName                      = $0010;

//  Printer Attribute IDs
  CWBSO_PRT_DeviceName                      = $0000;
  CWBSO_PRT_PrinterDeviceType               = $0001;
  CWBSO_PRT_Description                     = $0002;
  CWBSO_PRT_Status                          = $0003;
  CWBSO_PRT_StartedByUser                   = $0004;
  CWBSO_PRT_ChangesTakeEffect               = $0005;
  CWBSO_PRT_MessageQueueName                = $0006;
  CWBSO_PRT_MessageQueueLibrary             = $0007;
  CWBSO_PRT_FileName                        = $0008;
  CWBSO_PRT_FileNumber                      = $0009;
  CWBSO_PRT_UserSpecifiedData               = $000A;
  CWBSO_PRT_JobName                         = $000B;
  CWBSO_PRT_User                            = $000C;
  CWBSO_PRT_JobNumber                       = $000D;
  CWBSO_PRT_TotalPages                      = $000E;
  CWBSO_PRT_CurrentPage                     = $000F;
  CWBSO_PRT_TotalCopies                     = $0010;
  CWBSO_PRT_CopiesLeftToProduce             = $0011;
  CWBSO_PRT_FormType                        = $0012;
  CWBSO_PRT_NextFormType                    = $0013;
  CWBSO_PRT_FormsAlignment                  = $0014;
  CWBSO_PRT_FormTypeNotification            = $0015;
  CWBSO_PRT_NextFormTypeNotification        = $0016;
  CWBSO_PRT_NumberOfSeparators              = $0017;
  CWBSO_PRT_NextSeparators                  = $0018;
  CWBSO_PRT_SeparatorDrawer                 = $0019;
  CWBSO_PRT_NextSeparatorDrawer             = $001A;
  CWBSO_PRT_OutputQueueName                 = $001B;
  CWBSO_PRT_OutputQueueLibrary              = $001C;
  CWBSO_PRT_OutputQueueStatus               = $001D;
  CWBSO_PRT_NextOutputQueueName             = $001E;
  CWBSO_PRT_NextOutputQueueLibrary          = $001F;
  CWBSO_PRT_WriterJobName                   = $0020;
  CWBSO_PRT_WriterJobUser                   = $0021;
  CWBSO_PRT_WriterJobNumber                 = $0022;
  CWBSO_PRT_WriterStatus                    = $0023;
  CWBSO_PRT_AllowDirectPrinting             = $0024;
  CWBSO_PRT_EndAutomatically                = $0025;
  CWBSO_PRT_DeviceStatus                    = $0026;
  CWBSO_PRT_MessageKey                      = $0027;
  CWBSO_PRT_WriterStarted                   = $0028;
  CWBSO_PRT_WritingStatus                   = $0029;
  CWBSO_PRT_MessageWaitingStatus            = $002A;
  CWBSO_PRT_HeldStatus                      = $002B;
  CWBSO_PRT_EndPendingStatus                = $002C;
  CWBSO_PRT_HoldPendingStatus               = $002D;
  CWBSO_PRT_BetweenFilesStatus              = $002E;
  CWBSO_PRT_BetweenCopiesStatus             = $002F;
  CWBSO_PRT_WaitingForDataStatus            = $0030;
  CWBSO_PRT_WaitingForDeviceStatus          = $0031;
  CWBSO_PRT_OnJobQueueStatus                = $0032;
  CWBSO_PRT_AdvancedFunctionPrinting        = $0033;
  CWBSO_PRT_PublishingStatus                = $0034;

// Printer List Filter Attribute IDs
  CWBSO_PRTF_PrinterNameFilter              = $0001;

// Spooled File Attribute IDs
  CWBSO_SFL_SpooledFileName                  = $0000;  // QUSRSPLA
  CWBSO_SFL_JobName                          = $0001;  // QUSRSPLA
  CWBSO_SFL_UserName                         = $0002;  // QUSRSPLA
  CWBSO_SFL_JobNumber                        = $0003;  // QUSRSPLA
  CWBSO_SFL_SpooledFileNumber                = $0004;  // QUSRSPLA
  CWBSO_SFL_OutputQueueName                  = $0005;  // QUSRSPLA
  CWBSO_SFL_OutputQueueLibraryName           = $0006;  // QUSRSPLA
  CWBSO_SFL_DeviceNames                      = $0007;  // See the appendix of the System Object Access API Guide and Reference, Printer Output section
  CWBSO_SFL_UserSpecifiedData                = $0008;  // QUSRSPLA
  CWBSO_SFL_Status                           = $0009;  // QUSRSPLA
  CWBSO_SFL_TotalPages                       = $000A;  // QUSRSPLA
  CWBSO_SFL_CurrentPage                      = $000B;  // QUSRSPLA   Page or record being written
  CWBSO_SFL_CopiesLeftToProduce              = $000C;  // QUSRSPLA
  CWBSO_SFL_FormType                         = $000D;  // QUSRSPLA
  CWBSO_SFL_OutputPriority                   = $000E;  // QUSRSPLA
  CWBSO_SFL_DateFileOpened                   = $000F;  // QUSRSPLA
  CWBSO_SFL_TimeFileOpened                   = $0010;  // QUSRSPLA
  CWBSO_SFL_DeviceType                       = $0011;  // QUSRSPLA
  CWBSO_SFL_FileAvailable                    = $0012;  // QUSRSPLA
  CWBSO_SFL_HoldFileBeforeWritten            = $0013;  // QUSRSPLA
  CWBSO_SFL_SaveFileAfterWritten             = $0014;  // QUSRSPLA
  CWBSO_SFL_StartingPage                     = $0015;  // QUSRSPLA
  CWBSO_SFL_EndingPage                       = $0016;  // QUSRSPLA
  CWBSO_SFL_LastPagePrinted                  = $0017;  // QUSRSPLA
  CWBSO_SFL_RestartPrinting                  = $0018;  // QUSRSPLA
  CWBSO_SFL_TotalCopies                      = $0019;  // QUSRSPLA
  CWBSO_SFL_LinesPerInch                     = $001A;  // QUSRSPLA
  CWBSO_SFL_CharactersPerInch                = $001B;  // QUSRSPLA
  CWBSO_SFL_DeviceFileName                   = $001C;  // QUSRSPLA
  CWBSO_SFL_DeviceFileLibraryName            = $001D;  // QUSRSPLA
  CWBSO_SFL_ProgramThatOpenedFileName        = $001E;  // QUSRSPLA
  CWBSO_SFL_ProgramThatOpenedFileLibraryName = $001F;  // QUSRSPLA
  CWBSO_SFL_AccountingCode                   = $0020;  // QUSRSPLA
  CWBSO_SFL_RecordLength                     = $0021;  // QUSRSPLA
  CWBSO_SFL_MaximumRecords                   = $0022;  // QUSRSPLA
  CWBSO_SFL_PrinterDeviceType                = $0023;  // QUSRSPLA
  CWBSO_SFL_PrintFidelity                    = $0024;  // QUSRSPLA
  CWBSO_SFL_ReplaceUnprintableCharacters     = $0025;  // QUSRSPLA
  CWBSO_SFL_ReplacementCharacter             = $0026;  // QUSRSPLA
  CWBSO_SFL_PageLength                       = $0027;  // QUSRSPLA
  CWBSO_SFL_PageWidth                        = $0028;  // QUSRSPLA
  CWBSO_SFL_NumberOfSeparators               = $0029;  // QUSRSPLA
  CWBSO_SFL_OverflowLineNumber               = $002A;  // QUSRSPLA
  CWBSO_SFL_DbcsData                         = $002B;  // QUSRSPLA
  CWBSO_SFL_DbcsExtensionCharacters          = $002C;  // QUSRSPLA
  CWBSO_SFL_DbcsShiftOutShiftIn              = $002D;  // QUSRSPLA   DBCS shift-out shift-in (SO/SI) spacing
  CWBSO_SFL_DbcsCharacterRotation            = $002E;  // QUSRSPLA
  CWBSO_SFL_DbcsCharactersPerInch            = $002F;  // QUSRSPLA
  CWBSO_SFL_GraphicCharacterSet              = $0030;  // QUSRSPLA
  CWBSO_SFL_CodePage                         = $0031;  // QUSRSPLA
  CWBSO_SFL_FormDefinitionName               = $0032;  // QUSRSPLA
  CWBSO_SFL_FormDefinitionLibraryName        = $0033;  // QUSRSPLA
  CWBSO_SFL_SourceDrawer                     = $0034;  // QUSRSPLA
  CWBSO_SFL_PrinterFont                      = $0035;  // QUSRSPLA
  CWBSO_SFL_PageRotation                     = $0036;  // QUSRSPLA
  CWBSO_SFL_Justification                    = $0037;  // QUSRSPLA
  CWBSO_SFL_PrintOnBothSides                 = $0038;  // QUSRSPLA   Print on both sides (duplex)
  CWBSO_SFL_FoldRecords                      = $0039;  // QUSRSPLA
  CWBSO_SFL_ControlCharacter                 = $003A;  // QUSRSPLA
  CWBSO_SFL_AlignForms                       = $003B;  // QUSRSPLA
  CWBSO_SFL_PrintQuality                     = $003C;  // QUSRSPLA
  CWBSO_SFL_FormFeed                         = $003D;  // QUSRSPLA
  CWBSO_SFL_PagesPerSide                     = $003E;  // QUSRSPLA   Multiple up (pages per side)
  CWBSO_SFL_FrontOverlayName                 = $003F;  // QUSRSPLA
  CWBSO_SFL_FrontOverlayLibraryName          = $0040;  // QUSRSPLA
  CWBSO_SFL_FrontOverlayOffsetDown           = $0041;  // QUSRSPLA
  CWBSO_SFL_FrontOverlayOffsetAcross         = $0042;  // QUSRSPLA
  CWBSO_SFL_BackOverlayName                  = $0043;  // QUSRSPLA
  CWBSO_SFL_BackOverlayLibraryName           = $0044;  // QUSRSPLA
  CWBSO_SFL_BackOverlayOffsetDown            = $0045;  // QUSRSPLA
  CWBSO_SFL_BackOverlayOffsetAcross          = $0046;  // QUSRSPLA
  CWBSO_SFL_UnitOfMeasure                    = $0047;  // QUSRSPLA
  CWBSO_SFL_PageDefinitionName               = $0048;  // QUSRSPLA
  CWBSO_SFL_PageDefinitionLibraryName        = $0049;  // QUSRSPLA
  CWBSO_SFL_LineSpacing                      = $004A;  // QUSRSPLA
  CWBSO_SFL_PointSize                        = $004B;  // QUSRSPLA
  CWBSO_SFL_FrontMarginOffsetDown            = $004C;  // QUSRSPLA
  CWBSO_SFL_FrontMarginOffsetAcross          = $004D;  // QUSRSPLA
  CWBSO_SFL_BackMarginOffsetDown             = $004E;  // QUSRSPLA
  CWBSO_SFL_BackMarginOffsetAcross           = $004F;  // QUSRSPLA
  CWBSO_SFL_LengthOfPage                     = $0050;  // QUSRSPLA
  CWBSO_SFL_WidthOfPage                      = $0051;  // QUSRSPLA
  CWBSO_SFL_MeasurementMethod                = $0052;  // QUSRSPLA
  CWBSO_SFL_CharacterSetName                 = $0053;  // QUSRSPLA
  CWBSO_SFL_CharacterSetLibraryName          = $0054;  // QUSRSPLA
  CWBSO_SFL_CodePageName                     = $0055;  // QUSRSPLA
  CWBSO_SFL_CodePageLibraryName              = $0056;  // QUSRSPLA
  CWBSO_SFL_CodedFontName                    = $0057;  // QUSRSPLA
  CWBSO_SFL_CodedFontLibraryName             = $0058;  // QUSRSPLA
  CWBSO_SFL_DbcsCodedFontName                = $0059;  // QUSRSPLA
  CWBSO_SFL_DbcsCodedFontLibraryName         = $005A;  // QUSRSPLA
  CWBSO_SFL_UserDefinedFile                  = $005B;  // QUSRSPLA
  CWBSO_SFL_ReduceOutput                     = $005C;  // QUSRSPLA
  CWBSO_SFL_OutputBin                        = $005D;  // QUSRSPLA
  CWBSO_SFL_CodedCharacterSetId              = $005E;  // QUSRSPLA   CCSID
  CWBSO_SFL_UserSpecifiedText                = $005F;  // QUSRSPLA   User-defined text
  CWBSO_SFL_SystemWhereCreated               = $0060;  // QUSRSPLA
  CWBSO_SFL_NetworkIdWhereCreated            = $0061;  // QUSRSPLA
  CWBSO_SFL_UserWhoCreated                   = $0062;  // QUSRSPLA
  CWBSO_SFL_AS400CreatedAFPDS                = $0063;  // QUSRSPLA
  CWBSO_SFL_AdvancedFunctionPrintingResource = $0064;  // QUSRSPLA   Advanced Function Printing (AFP) resource
  CWBSO_SFL_DefineCharacters                 = $0065;  // QUSRSPLA
  CWBSO_SFL_CharacterPerInchChanges          = $0066;  // QUSRSPLA
  CWBSO_SFL_Transparency                     = $0067;  // QUSRSPLA
  CWBSO_SFL_DoubleWideCharacters             = $0068;  // QUSRSPLA
  CWBSO_SFL_DbcsCharacterRotationCommands    = $0069;  // QUSRSPLA
  CWBSO_SFL_Extended3812Font                 = $006A;  // QUSRSPLA   3812 SCS
  CWBSO_SFL_FieldOutlining                   = $006B;  // QUSRSPLA
  CWBSO_SFL_FinalFormText                    = $006C;  // QUSRSPLA
  CWBSO_SFL_BarCode                          = $006D;  // QUSRSPLA
  CWBSO_SFL_DrawerChange                     = $006E;  // QUSRSPLA
  CWBSO_SFL_CharacterId                      = $006F;  // QUSRSPLA
  CWBSO_SFL_LinesPerInchChanges              = $0070;  // QUSRSPLA
  CWBSO_SFL_VariableFont                     = $0071;  // QUSRSPLA   Font
  CWBSO_SFL_Highlight                        = $0072;  // QUSRSPLA
  CWBSO_SFL_PageRotate                       = $0073;  // QUSRSPLA
  CWBSO_SFL_Subscript                        = $0074;  // QUSRSPLA
  CWBSO_SFL_Superscript                      = $0075;  // QUSRSPLA
  CWBSO_SFL_Graphics                         = $0076;  // QUSRSPLA
  CWBSO_SFL_ASCIITransparency                = $0077;  // QUSRSPLA
  CWBSO_SFL_IPDSTransparentData              = $0078;  // QUSRSPLA
  CWBSO_SFL_PrinterAssigned                  = $0079;  // Not documented
  CWBSO_SFL_PrinterGroup                     = $007A;  // Not documented
  CWBSO_SFL_DateLastAccessed                 = $007B;  //
  CWBSO_SFL_PageCountEstimated               = $007C;  //
  CWBSO_SFL_FileSize                         = $007D;  //
  CWBSO_SFL_SpooledFileSizeMultiplier        = $007E;  //
  CWBSO_SFL_AuxilliaryStoragePool            = $007F;  //
  CWBSO_SFL_CornerStapling                   = $0080;  //
  CWBSO_SFL_ReferenceEdge                    = $0081;  // Edge stitching
  CWBSO_SFL_ReferenceEdgeOffset              = $0082;  // Edge stitching
  CWBSO_SFL_NumberOfStaples                  = $0083;  // Edge stitching
  CWBSO_SFL_ReplacementFontResolution        = $008A;  //
  CWBSO_SFL_CodedFontPointSize               = $008B;  //
  CWBSO_SFL_FontCharacterSetPointSize        = $008C;  //
  CWBSO_SFL_DbcsCodedFontPointSize           = $008D;  //
  CWBSO_SFL_UserDefinedObject                = $0091;  //
  CWBSO_SFL_UserDefinedObjectLib             = $0092;  //
  CWBSO_SFL_UserDefinedObjectType            = $0093;  //
  CWBSO_SFL_UserDefinedData                  = $0094;  //
  CWBSO_SFL_AFPCharacters                    = $0095;  //
  CWBSO_SFL_DecimalFormat                    = $0096;  //
  CWBSO_SFL_TableReferenceCharacter          = $0097;  //
  CWBSO_SFL_IPDSPassThrough                  = $0098;  //
  CWBSO_SFL_UserDefinedOptions               = $0099;  //
  CWBSO_SFL_UserResourceLibrary              = $009A;  //
  CWBSO_SFL_StapleOffsets                    = $009B;  //
  CWBSO_SFL_ConstantBack                     = $009C;  //
  CWBSO_SFL_SaddleReferenceEdge              = $009D;  //
  CWBSO_SFL_SaddleNumberOfStaples            = $009E;
  CWBSO_SFL_JobSystemName                    = $009F;

// Spooled File Sort IDs
  CWBSO_SFL_SORT_FileName              = CWBSO_SFL_SpooledFileName;
  CWBSO_SFL_SORT_JobName               = CWBSO_SFL_JobName;
  CWBSO_SFL_SORT_UserName              = CWBSO_SFL_UserName;
  CWBSO_SFL_SORT_JobNumber             = CWBSO_SFL_JobNumber;
  CWBSO_SFL_SORT_FileNumber            = CWBSO_SFL_SpooledFileNumber;
  CWBSO_SFL_SORT_OutQ                  = CWBSO_SFL_OutputQueueName;
  CWBSO_SFL_SORT_OutQLib               = CWBSO_SFL_OutputQueueLibraryName;
  CWBSO_SFL_SORT_Printer               = CWBSO_SFL_DeviceNames;
  CWBSO_SFL_SORT_UserData              = CWBSO_SFL_UserSpecifiedData;
  CWBSO_SFL_SORT_Status                = CWBSO_SFL_Status;
  CWBSO_SFL_SORT_Pages                 = CWBSO_SFL_TotalPages;
  CWBSO_SFL_SORT_Copies                = CWBSO_SFL_CopiesLeftToProduce;
  CWBSO_SFL_SORT_FormType              = CWBSO_SFL_FormType;
  CWBSO_SFL_SORT_Priority              = CWBSO_SFL_OutputPriority;
  CWBSO_SFL_SORT_Date                  = CWBSO_SFL_DateFileOpened;
  CWBSO_SFL_SORT_Time                  = CWBSO_SFL_TimeFileOpened;

// Spooled File List Filter Attribute IDs
  CWBSO_SFLF_UserFilter                      = $0001;
  CWBSO_SFLF_OutputQueueFilter               = $0003;
  CWBSO_SFLF_FormTypeFilter                  = $0004;
  CWBSO_SFLF_UserDataFilter                  = $0005;
  CWBSO_SFLF_StatusFilter                    = $0007;
  CWBSO_SFLF_DeviceFilter                    = $0009;
  CWBSO_SFLF_JobNameFilter                   = $000A;

// Attribute ids for TCPIPInterfaces
  CWBSO_TIF_TCPIPNetworkName              = $0000;
  CWBSO_TIF_InternetAddress               = $0001;
  CWBSO_TIF_BinaryInternetAddress         = $0002;
  CWBSO_TIF_SubnetMask                    = $0003;
  CWBSO_TIF_BinarySubnetMask              = $0004;
  CWBSO_TIF_AssociatedLocalInterface      = $0005;
  CWBSO_TIF_BinaryLocalIP                 = $0006;
  CWBSO_TIF_LineDescriptionName           = $0007;
  CWBSO_TIF_TypeOfLine                    = $0008;
  CWBSO_TIF_MaximumTransmissionUnit       = $0009;
  CWBSO_TIF_TypeOfService                 = $000a;
  CWBSO_TIF_AutomaticStart                = $000b;
  CWBSO_TIF_TokenRingBitSequence          = $000c;
  CWBSO_TIF_Status                        = $000d;
  CWBSO_TIF_InterfaceName                 = $000e;
  CWBSO_TIF_PPPProfile                    = $000f;
  CWBSO_TIF_PPPRemoteIP                   = $0010;
  CWBSO_TIF_ApplicationDefined            = $0011;
  CWBSO_TIF_AllowProxyARP                 = $0012;
  CWBSO_TIF_LastAttribute                 = $0012;

// Attribute ids for EthernetLine
  CWBSO_LET_CurrentStatusCode                            = $0000;
  CWBSO_LET_ConfigurationDescriptionName                 = $0001;
  CWBSO_LET_ConfigurationDescriptionCategory             = $0002;
  CWBSO_LET_CurrentStatus                                = $0003;
  CWBSO_LET_Description                                  = $0004;
  CWBSO_LET_JobName                                      = $0005;
  CWBSO_LET_JobUser                                      = $0006;
  CWBSO_LET_JobNumber                                    = $0007;
  CWBSO_LET_PassThroughDevice                            = $0008;
  CWBSO_LET_NumberOfAttachedControllers                  = $0009;
  CWBSO_LET_RetrieveDate                                 = $000a;
  CWBSO_LET_RetrieveTime                                 = $000b;
  CWBSO_LET_OnlineAtIPL                                  = $000c;
  CWBSO_LET_VaryOnWait                                   = $000d;
  CWBSO_LET_MaximumControllers                           = $000e;
  CWBSO_LET_LinkSpeed                                    = $000f;
  CWBSO_LET_CostPerConnectTime                           = $0010;
  CWBSO_LET_CostPerByte                                  = $0011;
  CWBSO_LET_UserDefined1                                 = $0012;
  CWBSO_LET_UserDefined2                                 = $0013;
  CWBSO_LET_UserDefined3                                 = $0014;
  CWBSO_LET_AutodeleteController                         = $0015;
  CWBSO_LET_RecoveryLimitsCountLimit                     = $0016;
  CWBSO_LET_RecoveryLimitsTimeInterval                   = $0017;
  CWBSO_LET_ResourceName                                 = $0018;
  CWBSO_LET_NetworkController                            = $0019;
  CWBSO_LET_LocalAdapterAddress                          = $001a;
  CWBSO_LET_ExchangeID                                   = $001b;
  CWBSO_LET_EthernetStandard                             = $001c;
  CWBSO_LET_ErrorThresholdLevel                          = $001d;
  CWBSO_LET_SecurityForLine                              = $001e;
  CWBSO_LET_PropagationDelay                             = $001f;
  CWBSO_LET_AutocreateController                         = $0020;
  CWBSO_LET_PortNumber                                   = $0021;
  CWBSO_LET_AttachedNonswitchedNWI                       = $0022;
  CWBSO_LET_NetworkInterfaceDLCIdentifier                = $0023;
  CWBSO_LET_NetworkServerDescription                     = $0024;
  CWBSO_LET_Duplex                                       = $0025;
  CWBSO_LET_LineSpeed                                    = $0026;
  CWBSO_LET_GenerateTestFrame                            = $0027;
  CWBSO_LET_LECCacheAgingTime                            = $0028;
  CWBSO_LET_ARPRetryCount                                = $0029;
  CWBSO_LET_ARPRetryTimer                                = $002a;
  CWBSO_LET_MaximumARPEntries                            = $002b;
  CWBSO_LET_LECDisconnectTimeOut                         = $002c;
  CWBSO_LET_ATMAccessType                                = $002d;
  CWBSO_LET_EmulatedLANName                              = $002e;
  CWBSO_LET_LocalATMAddressNetworkPrefix                 = $002f;
  CWBSO_LET_LocalATMAddressEndSystemID                   = $0030;
  CWBSO_LET_LocalATMAddressLECSelectorByte               = $0031;
  CWBSO_LET_LESATMAddressNetworkPrefix                   = $0032;
  CWBSO_LET_LESATMAddressEndSystemID                     = $0033;
  CWBSO_LET_LESATMAddressLECSelectorByte                 = $0034;
  CWBSO_LET_LastContactedLESATMAddressNetworkPrefix      = $0035;
  CWBSO_LET_LastContactedLESATMAddressEndSystemID        = $0036;
  CWBSO_LET_LastContactedLESATMAddressLECSelectorByte    = $0037;
  CWBSO_LET_UseLECSAddress                               = $0038;
  CWBSO_LET_NetworkInterfaceType                         = $0039;
  CWBSO_LET_ReportedEmulatedLANName                      = $003a;
  CWBSO_LET_MaxTransmissionUnitSize                      = $003b;
  CWBSO_LET_LinkSpeedMultiplier                          = $003c;
  CWBSO_LET_MessageQueueName                             = $003d;
  CWBSO_LET_MessageQueueLibrary                          = $003e;
  CWBSO_LET_CurrentMessageQueueName                      = $003f;
  CWBSO_LET_CurrentMessageQueueLibrary                   = $0040;
  CWBSO_LET_EnableTCPOnly                                = $0041;
  CWBSO_LET_MaximumFrameSize                             = $0042;
  CWBSO_LET_CurrentLineSpeed                             = $0043;
  CWBSO_LET_CurrentDuplex                                = $0044;
  CWBSO_LET_LastAttribute                                = $0044;

// Attribute ids for TokenringLine
  CWBSO_LTR_CurrentStatusCode                            = $0000;
  CWBSO_LTR_ConfigurationDescriptionName                 = $0001;
  CWBSO_LTR_ConfigurationDescriptionCategory             = $0002;
  CWBSO_LTR_CurrentStatus                                = $0003;
  CWBSO_LTR_Description                                  = $0004;
  CWBSO_LTR_JobName                                      = $0005;
  CWBSO_LTR_JobUser                                      = $0006;
  CWBSO_LTR_JobNumber                                    = $0007;
  CWBSO_LTR_PassThroughDevice                            = $0008;
  CWBSO_LTR_NumberOfAttachedControllers                  = $0009;
  CWBSO_LTR_RetrieveDate                                 = $000a;
  CWBSO_LTR_RetrieveTime                                 = $000b;
  CWBSO_LTR_OnlineAtIPL                                  = $000c;
  CWBSO_LTR_VaryOnWait                                   = $000d;
  CWBSO_LTR_MaximumControllers                           = $000e;
  CWBSO_LTR_LineSpeed                                    = $000f;
  CWBSO_LTR_MaximumFrameSize                             = $0010;
  CWBSO_LTR_LinkSpeed                                    = $0011;
  CWBSO_LTR_CostPerConnectTime                           = $0012;
  CWBSO_LTR_CostPerByte                                  = $0013;
  CWBSO_LTR_UserDefined1                                 = $0014;
  CWBSO_LTR_UserDefined2                                 = $0015;
  CWBSO_LTR_UserDefined3                                 = $0016;
  CWBSO_LTR_AutodeleteController                         = $0017;
  CWBSO_LTR_RecoveryLimitsCountLimit                     = $0018;
  CWBSO_LTR_RecoveryLimitsTimeInterval                   = $0019;
  CWBSO_LTR_ResourceName                                 = $001a;
  CWBSO_LTR_NetworkController                            = $001b;
  CWBSO_LTR_TRLANManagerLoggingLevelConfigured           = $001c;
  CWBSO_LTR_TRLANManagerLoggingLevelCurrent              = $001d;
  CWBSO_LTR_TRLANManagerMode                             = $001e;
  CWBSO_LTR_LogConfigurationChanges                      = $001f;
  CWBSO_LTR_TokenringInformOfBeacon                      = $0020;
  CWBSO_LTR_LocalAdapterAddress                          = $0021;
  CWBSO_LTR_ExchangeID                                   = $0022;
  CWBSO_LTR_EarlyTokenRelease                            = $0023;
  CWBSO_LTR_ErrorThresholdLevel                          = $0024;
  CWBSO_LTR_SecurityForLine                              = $0025;
  CWBSO_LTR_PropagationDelay                             = $0026;
  CWBSO_LTR_AutocreateController                         = $0027;
  CWBSO_LTR_PortNumber                                   = $0028;
  CWBSO_LTR_AttachedNonswitchedNWI                       = $0029;
  CWBSO_LTR_NetworkInterfaceDLCIdentifier                = $002a;
  CWBSO_LTR_NetworkServerDescription                     = $002b;
  CWBSO_LTR_AutoconfiguredForAS36                        = $002c;
  CWBSO_LTR_Duplex                                       = $002d;
  CWBSO_LTR_ActiveLANManager                             = $002e;
  CWBSO_LTR_LECCacheAgingTime                            = $002f;
  CWBSO_LTR_ARPRetryCount                                = $0030;
  CWBSO_LTR_ARPRetryTimer                                = $0031;
  CWBSO_LTR_LECFrameSize                                 = $0032;
  CWBSO_LTR_MaximumARPEntries                            = $0033;
  CWBSO_LTR_LECDisconnectTimeOut                         = $0034;
  CWBSO_LTR_ATMAccessType                                = $0035;
  CWBSO_LTR_EmulatedLANName                              = $0036;
  CWBSO_LTR_LocalATMAddressNetworkPrefix                 = $0037;
  CWBSO_LTR_LocalATMAddressEndSystemID                   = $0038;
  CWBSO_LTR_LocalATMAddressLECSelectorByte               = $0039;
  CWBSO_LTR_LESATMAddressNetworkPrefix                   = $003a;
  CWBSO_LTR_LESATMAddressEndSystemID                     = $003b;
  CWBSO_LTR_LESATMAddressLECSelectorByte                 = $003c;
  CWBSO_LTR_LastContactedLESATMAddressNetworkPrefix      = $003d;
  CWBSO_LTR_LastContactedLESATMAddressEndSystemID        = $003e;
  CWBSO_LTR_LastContactedLESATMAddressLECSelectorByte    = $003f;
  CWBSO_LTR_UseLECSAddress                               = $0040;
  CWBSO_LTR_NetworkInterfaceType                         = $0041;
  CWBSO_LTR_ReportedEmulatedLANName                      = $0042;
  CWBSO_LTR_LinkSpeedMultiplier                          = $0043;
  CWBSO_LTR_MessageQueueName                             = $0044;
  CWBSO_LTR_MessageQueueLibrary                          = $0045;
  CWBSO_LTR_CurrentMessageQueueName                      = $0046;
  CWBSO_LTR_CurrentMessageQueueLibrary                   = $0047;
  CWBSO_LTR_CurrentLineSpeed                             = $0048;
  CWBSO_LTR_CurrentDuplex                                = $0049;
  CWBSO_LTR_LastAttribute                                = $0049;

// Attribute ids for Hardwareresources
  CWBSO_HWR_ResourceCategory            = $0000;
  CWBSO_HWR_FamilyLevel                 = $0001;
  CWBSO_HWR_LineType                    = $0002;
  CWBSO_HWR_ResourceName                = $0003;
  CWBSO_HWR_Type                        = $0004;
  CWBSO_HWR_Model                       = $0005;
  CWBSO_HWR_Status                      = $0006;
  CWBSO_HWR_SystemConnectedTo           = $0007;
  CWBSO_HWR_AdapterAdress               = $0008;
  CWBSO_HWR_Description                 = $0009;
  CWBSO_HWR_Kind1                       = $000a;
  CWBSO_HWR_Kind2                       = $000b;
  CWBSO_HWR_Kind3                       = $000c;
  CWBSO_HWR_LastAttribute               = $000c;

// HardwareResource Filter Attribute IDs
  CWBSO_HWRF_ResourceCategory           = $0000;

// CommunicationsResource
  CWBSO_HW2_ResourceCategory            = CWBSO_HWR_ResourceCategory;
  CWBSO_HW2_FamilyLevel                 = CWBSO_HWR_FamilyLevel;
  CWBSO_HW2_LineType                    = CWBSO_HWR_LineType;
  CWBSO_HW2_ResourceName                = CWBSO_HWR_ResourceName;
  CWBSO_HW2_Type                        = CWBSO_HWR_Type;
  CWBSO_HW2_Model                       = CWBSO_HWR_Model;
  CWBSO_HW2_Status                      = CWBSO_HWR_Status;
  CWBSO_HW2_SystemConnectedTo           = CWBSO_HWR_SystemConnectedTo;
  CWBSO_HW2_AdapterAdress               = CWBSO_HWR_AdapterAdress;
  CWBSO_HW2_Description                 = CWBSO_HWR_Description;
  CWBSO_HW2_Kind1                       = CWBSO_HWR_Kind1;
  CWBSO_HW2_Kind2                       = CWBSO_HWR_Kind2;
  CWBSO_HW2_Kind3                       = CWBSO_HWR_Kind3;
  CWBSO_HW2_SystemBusNumber             = $000d;
  CWBSO_HW2_SystemBoardNumber           = $000e;
  CWBSO_HW2_SystemCardNumber            = $000f;
  CWBSO_HW2_IOBusAddress                = $0010;
  CWBSO_HW2_AdapterAddress              = $0011;
  CWBSO_HW2_PortNumber                  = $0012;
  CWBSO_HW2_SerialNumber                = $0013;
  CWBSO_HW2_PartNumber                  = $0014;
  CWBSO_HW2_FrameID                     = $0015;
  CWBSO_HW2_CardPosition                = $0016;
  CWBSO_HW2_LastAttribute               = $0016;

// LocalWorkStationResource
  CWBSO_HW3_ResourceCategory            = CWBSO_HWR_ResourceCategory;
  CWBSO_HW3_FamilyLevel                 = CWBSO_HWR_FamilyLevel;
  CWBSO_HW3_LineType                    = CWBSO_HWR_LineType;
  CWBSO_HW3_ResourceName                = CWBSO_HWR_ResourceName;
  CWBSO_HW3_Type                        = CWBSO_HWR_Type;
  CWBSO_HW3_Model                       = CWBSO_HWR_Model;
  CWBSO_HW3_Status                      = CWBSO_HWR_Status;
  CWBSO_HW3_SystemConnectedTo           = CWBSO_HWR_SystemConnectedTo;
  CWBSO_HW3_AdapterAdress               = CWBSO_HWR_AdapterAdress;
  CWBSO_HW3_Description                 = CWBSO_HWR_Description;
  CWBSO_HW3_Kind1                       = CWBSO_HWR_Kind1;
  CWBSO_HW3_Kind2                       = CWBSO_HWR_Kind2;
  CWBSO_HW3_Kind3                       = CWBSO_HWR_Kind3;
  CWBSO_HW3_SystemBusNumber             = $000d;
  CWBSO_HW3_SystemBoardNumber           = $000e;
  CWBSO_HW3_SystemCardNumber            = $000f;
  CWBSO_HW3_IOBusAddress                = $0010;
  CWBSO_HW3_AdapterAddress              = $0011;
  CWBSO_HW3_PortNumber                  = $0012;
  CWBSO_HW3_DeviceAddress               = $0013;
  CWBSO_HW3_SharedSessionNumber         = $0014;
  CWBSO_HW3_SerialNumber                = $0015;
  CWBSO_HW3_PartNumber                  = $0016;
  CWBSO_HW3_FrameID                     = $0017;
  CWBSO_HW3_CardPosition                = $0018;
  CWBSO_HW3_LastAttribute               = $0018;

// ProcessorResource
  CWBSO_HW4_ResourceCategory            = CWBSO_HWR_ResourceCategory;
  CWBSO_HW4_FamilyLevel                 = CWBSO_HWR_FamilyLevel;
  CWBSO_HW4_LineType                    = CWBSO_HWR_LineType;
  CWBSO_HW4_ResourceName                = CWBSO_HWR_ResourceName;
  CWBSO_HW4_Type                        = CWBSO_HWR_Type;
  CWBSO_HW4_Model                       = CWBSO_HWR_Model;
  CWBSO_HW4_Status                      = CWBSO_HWR_Status;
  CWBSO_HW4_SystemConnectedTo           = CWBSO_HWR_SystemConnectedTo;
  CWBSO_HW4_AdapterAdress               = CWBSO_HWR_AdapterAdress;
  CWBSO_HW4_Description                 = CWBSO_HWR_Description;
  CWBSO_HW4_Kind1                       = CWBSO_HWR_Kind1;
  CWBSO_HW4_Kind2                       = CWBSO_HWR_Kind2;
  CWBSO_HW4_Kind3                       = CWBSO_HWR_Kind3;
  CWBSO_HW4_SystemBusNumber             = $000d;
  CWBSO_HW4_SystemBoardNumber           = $000e;
  CWBSO_HW4_SystemCardNumber            = $000f;
  CWBSO_HW4_SerialNumber                = $0010;
  CWBSO_HW4_PartNumber                  = $0011;
  CWBSO_HW4_FrameID                     = $0012;
  CWBSO_HW4_CardPosition                = $0013;
  CWBSO_HW4_ProcessorFeatureCode        = $0014;
  CWBSO_HW4_ProcessorFeature            = $0015;
  CWBSO_HW4_InteractiveFeatureCode      = $0016;
  CWBSO_HW4_LastAttribute               = $0016;

// StorageDeviceResource

  CWBSO_HW5_ResourceCategory            = CWBSO_HWR_ResourceCategory;
  CWBSO_HW5_FamilyLevel                 = CWBSO_HWR_FamilyLevel;
  CWBSO_HW5_LineType                    = CWBSO_HWR_LineType;
  CWBSO_HW5_ResourceName                = CWBSO_HWR_ResourceName;
  CWBSO_HW5_Type                        = CWBSO_HWR_Type;
  CWBSO_HW5_Model                       = CWBSO_HWR_Model;
  CWBSO_HW5_Status                      = CWBSO_HWR_Status;
  CWBSO_HW5_SystemConnectedTo           = CWBSO_HWR_SystemConnectedTo;
  CWBSO_HW5_AdapterAdress               = CWBSO_HWR_AdapterAdress;
  CWBSO_HW5_Description                 = CWBSO_HWR_Description;
  CWBSO_HW5_Kind1                       = CWBSO_HWR_Kind1;
  CWBSO_HW5_Kind2                       = CWBSO_HWR_Kind2;
  CWBSO_HW5_Kind3                       = CWBSO_HWR_Kind3;
  CWBSO_HW5_SystemBusNumber             = $000d;
  CWBSO_HW5_SystemBoardNumber           = $000e;
  CWBSO_HW5_SystemCardNumber            = $000f;
  CWBSO_HW5_IOBusAddress                = $0010;
  CWBSO_HW5_ControllerAddress           = $0011;
  CWBSO_HW5_DeviceAddress               = $0012;
  CWBSO_HW5_DevicePosition              = $0013;
  CWBSO_HW5_SerialNumber                = $0014;
  CWBSO_HW5_PartNumber                  = $0015;
  CWBSO_HW5_FrameID                     = $0016;
  CWBSO_HW5_CardPosition                = $0017;
  CWBSO_HW5_LastAttribute               = $0017;

// CoupledSystemAdapterResource
  CWBSO_HW6_ResourceCategory            = CWBSO_HWR_ResourceCategory;
  CWBSO_HW6_FamilyLevel                 = CWBSO_HWR_FamilyLevel;
  CWBSO_HW6_LineType                    = CWBSO_HWR_LineType;
  CWBSO_HW6_ResourceName                = CWBSO_HWR_ResourceName;
  CWBSO_HW6_Type                        = CWBSO_HWR_Type;
  CWBSO_HW6_Model                       = CWBSO_HWR_Model;
  CWBSO_HW6_Status                      = CWBSO_HWR_Status;
  CWBSO_HW6_SystemConnectedTo           = CWBSO_HWR_SystemConnectedTo;
  CWBSO_HW6_AdapterAdress               = CWBSO_HWR_AdapterAdress;
  CWBSO_HW6_Description                 = CWBSO_HWR_Description;
  CWBSO_HW6_Kind1                       = CWBSO_HWR_Kind1;
  CWBSO_HW6_Kind2                       = CWBSO_HWR_Kind2;
  CWBSO_HW6_Kind3                       = CWBSO_HWR_Kind3;
  CWBSO_HW6_SystemBusNumber             = $000d;
  CWBSO_HW6_SystemBoardNumber           = $000e;
  CWBSO_HW6_SystemCardNumber            = $000f;
  CWBSO_HW6_SerialNumber                = $0010;
  CWBSO_HW6_PartNumber                  = $0011;
  CWBSO_HW6_FrameID                     = $0012;
  CWBSO_HW6_CardPosition                = $0013;
  CWBSO_HW6_LastAttribute               = $0013;

// LocalAreaNetworkResource
  CWBSO_HW7_ResourceCategory            = CWBSO_HWR_ResourceCategory;
  CWBSO_HW7_FamilyLevel                 = CWBSO_HWR_FamilyLevel;
  CWBSO_HW7_LineType                    = CWBSO_HWR_LineType;
  CWBSO_HW7_ResourceName                = CWBSO_HWR_ResourceName;
  CWBSO_HW7_Type                        = CWBSO_HWR_Type;
  CWBSO_HW7_Model                       = CWBSO_HWR_Model;
  CWBSO_HW7_Status                      = CWBSO_HWR_Status;
  CWBSO_HW7_SystemConnectedTo           = CWBSO_HWR_SystemConnectedTo;
  CWBSO_HW7_AdapterAdress               = CWBSO_HWR_AdapterAdress;
  CWBSO_HW7_Description                 = CWBSO_HWR_Description;
  CWBSO_HW7_Kind1                       = CWBSO_HWR_Kind1;
  CWBSO_HW7_Kind2                       = CWBSO_HWR_Kind2;
  CWBSO_HW7_Kind3                       = CWBSO_HWR_Kind3;
  CWBSO_HW7_LastAttribute               = CWBSO_HW7_Kind3;

// CryptographyResources
  CWBSO_HW8_ResourceCategory            = CWBSO_HWR_ResourceCategory;
  CWBSO_HW8_FamilyLevel                 = CWBSO_HWR_FamilyLevel;
  CWBSO_HW8_LineType                    = CWBSO_HWR_LineType;
  CWBSO_HW8_ResourceName                = CWBSO_HWR_ResourceName;
  CWBSO_HW8_Type                        = CWBSO_HWR_Type;
  CWBSO_HW8_Model                       = CWBSO_HWR_Model;
  CWBSO_HW8_Status                      = CWBSO_HWR_Status;
  CWBSO_HW8_SystemConnectedTo           = CWBSO_HWR_SystemConnectedTo;
  CWBSO_HW8_AdapterAdress               = CWBSO_HWR_AdapterAdress;
  CWBSO_HW8_Description                 = CWBSO_HWR_Description;
  CWBSO_HW8_Kind1                       = CWBSO_HWR_Kind1;
  CWBSO_HW8_Kind2                       = CWBSO_HWR_Kind2;
  CWBSO_HW8_Kind3                       = CWBSO_HWR_Kind3;
  CWBSO_HW8_SystemBusNumber             = $000d;
  CWBSO_HW8_SystemBoardNumber           = $000e;
  CWBSO_HW8_SystemCardNumber            = $000f;
  CWBSO_HW8_IOBusAddress                = $0010;
  CWBSO_HW8_AdapterAddress              = $0011;
  CWBSO_HW8_DeviceAddress               = $0012;
  CWBSO_HW8_SerialNumber                = $0013;
  CWBSO_HW8_PartNumber                  = $0014;
  CWBSO_HW8_FrameID                     = $0015;
  CWBSO_HW8_CardPosition                = $0016;
  CWBSO_HW8_LastAttribute               = $0016;

// TapeUnits
  CWBSO_HWA_ResourceCategory            = CWBSO_HWR_ResourceCategory;
  CWBSO_HWA_FamilyLevel                 = CWBSO_HWR_FamilyLevel;
  CWBSO_HWA_LineType                    = CWBSO_HWR_LineType;
  CWBSO_HWA_ResourceName                = CWBSO_HWR_ResourceName;
  CWBSO_HWA_Type                        = CWBSO_HWR_Type;
  CWBSO_HWA_Model                       = CWBSO_HWR_Model;
  CWBSO_HWA_Status                      = CWBSO_HWR_Status;
  CWBSO_HWA_SystemConnectedTo           = CWBSO_HWR_SystemConnectedTo;
  CWBSO_HWA_AdapterAdress               = CWBSO_HWR_AdapterAdress;
  CWBSO_HWA_Description                 = CWBSO_HWR_Description;
  CWBSO_HWA_Kind1                       = CWBSO_HWR_Kind1;
  CWBSO_HWA_Kind2                       = CWBSO_HWR_Kind2;
  CWBSO_HWA_Kind3                       = CWBSO_HWR_Kind3;
  CWBSO_HWA_SystemBusNumber             = $000d;
  CWBSO_HWA_SystemBoardNumber           = $000e;
  CWBSO_HWA_SystemCardNumber            = $000f;
  CWBSO_HWA_IOBusAddress                = $0010;
  CWBSO_HWA_ControllerAddress           = $0011;
  CWBSO_HWA_DeviceAddress               = $0012;
  CWBSO_HWA_DevicePosition              = $0013;
  CWBSO_HWA_SerialNumber                = $0014;
  CWBSO_HWA_PartNumber                  = $0015;
  CWBSO_HWA_FrameID                     = $0016;
  CWBSO_HWA_CardPosition                = $0017;
  CWBSO_HWA_LastAttribute               = $0017;

// OpticalUnits
  CWBSO_HWB_ResourceCategory            = CWBSO_HWR_ResourceCategory;
  CWBSO_HWB_FamilyLevel                 = CWBSO_HWR_FamilyLevel;
  CWBSO_HWB_LineType                    = CWBSO_HWR_LineType;
  CWBSO_HWB_ResourceName                = CWBSO_HWR_ResourceName;
  CWBSO_HWB_Type                        = CWBSO_HWR_Type;
  CWBSO_HWB_Model                       = CWBSO_HWR_Model;
  CWBSO_HWB_Status                      = CWBSO_HWR_Status;
  CWBSO_HWB_SystemConnectedTo           = CWBSO_HWR_SystemConnectedTo;
  CWBSO_HWB_AdapterAdress               = CWBSO_HWR_AdapterAdress;
  CWBSO_HWB_Description                 = CWBSO_HWR_Description;
  CWBSO_HWB_Kind1                       = CWBSO_HWR_Kind1;
  CWBSO_HWB_Kind2                       = CWBSO_HWR_Kind2;
  CWBSO_HWB_Kind3                       = CWBSO_HWR_Kind3;
  CWBSO_HWB_SystemBusNumber             = $000d;
  CWBSO_HWB_SystemBoardNumber           = $000e;
  CWBSO_HWB_SystemCardNumber            = $000f;
  CWBSO_HWB_IOBusAddress                = $0010;
  CWBSO_HWB_ControllerAddress           = $0011;
  CWBSO_HWB_DeviceAddress               = $0012;
  CWBSO_HWB_DevicePosition              = $0013;
  CWBSO_HWB_SerialNumber                = $0014;
  CWBSO_HWB_PartNumber                  = $0015;
  CWBSO_HWB_FrameID                     = $0016;
  CWBSO_HWB_CardPosition                = $0017;
  CWBSO_HWB_LastAttribute               = $0017;

// SoftwareProduct
  CWBSO_SWP_ProductID                                     = $0000;
  CWBSO_SWP_ProductOption                                 = $0001;
  CWBSO_SWP_ReleaseLevel                                  = $0002;
  CWBSO_SWP_MessageID                                     = $0003;
  CWBSO_SWP_MessageFileName                               = $0004;
  CWBSO_SWP_DescriptionText                               = $0005;
  CWBSO_SWP_LoadID                                        = $0006;
  CWBSO_SWP_LoadType                                      = $0007;
  CWBSO_SWP_SymbolicLoadState                             = $0008;
  CWBSO_SWP_LoadErrorIndicator                            = $0009;
  CWBSO_SWP_LoadState                                     = $000a;
  CWBSO_SWP_SupportedFlag                                 = $000b;
  CWBSO_SWP_RegistrationType                              = $000c;
  CWBSO_SWP_RegistrationValue                             = $000d;
  CWBSO_SWP_PrimaryLanguageLoadID                         = $000e;
  CWBSO_SWP_MinimumTargetRelease                          = $000f;
  CWBSO_SWP_MinimumVRMOfBaseRequiredByOption              = $0010;
  CWBSO_SWP_RequirementsMetBetweenBaseAndOptionValue      = $0011;
  CWBSO_SWP_Level                                         = $0012;
  CWBSO_SWP_SecondaryLanguageLibraryName                  = $0013;
  CWBSO_SWP_PrimaryLibraryName                            = $0014;
  CWBSO_SWP_InstalledLibraryName                          = $0015;
  CWBSO_SWP_LibraryType                                   = $0016;
  CWBSO_SWP_LibraryAuthority                              = $0017;
  CWBSO_SWP_LibraryCreateAuthority                        = $0018;
  CWBSO_SWP_LastAttribute                                 = $0018;

// SoftwareProduct Filter Attribute IDs for CWBSO_SetListFilter API
  CWBSO_SWPF_ProductOptions                               = $0000;
  CWBSO_SWPF_Product                                      = $0001;

// TCPIPRoutes
  CWBSO_RTE_TCPIPNetworkName           = $0000;
  CWBSO_RTE_InternetAddress            = $0001;
  CWBSO_RTE_BinaryInternetAddress      = $0002;
  CWBSO_RTE_SubnetMask                 = $0003;
  CWBSO_RTE_BinarySubnetMask           = $0004;
  CWBSO_RTE_NextHopAddress             = $0005;
  CWBSO_RTE_BinaryNextHop              = $0006;
  CWBSO_RTE_BindingInterface           = $0007;
  CWBSO_RTE_BinaryBindingIP            = $0008;
  CWBSO_RTE_MaximumTransmissionUnit    = $0009;
  CWBSO_RTE_TypeOfService              = $000a;
  CWBSO_RTE_RoutePrecedence            = $000b;
  CWBSO_RTE_RIPMetric                  = $000c;
  CWBSO_RTE_RIPRedistribution          = $000d;
  CWBSO_RTE_PPPProfile                 = $000e;
  CWBSO_RTE_PPPCallerUserid            = $000f;
  CWBSO_RTE_PPPCallerIP                = $0010;
  CWBSO_RTE_ApplicationDefined         = $0011;
  CWBSO_RTE_DependentDODProfile        = $0012;
  CWBSO_RTE_LastAttribute              = $0012;

// UserProfile
  CWBSO_PRF_ProfileName                = $0000;
  CWBSO_PRF_ProfileOrGroupIndicator    = $0001;
  CWBSO_PRF_GroupHasMembers            = $0002;
  CWBSO_PRF_TextDescription            = $0003;

  CWBSO_PRF_LastAttribute              = $0003;

// UserProfileList Filter Attribute IDs for CWBSO_SetListFilter API
  CWBSO_PRFF_Profile                   = $0001;   // Selection Criteria
  CWBSO_PRFF_GroupName                 = $0002;   // Group Profile Name
  CWBSO_PRFF_ProfileMatch              = $0004;   // Profile Name (for profile pattern matching)

// TCPIPAttributes

  CWBSO_TCA_IPDatagramForwarding           = $0000;
  CWBSO_TCA_UDPChecks                      = $0001;
  CWBSO_TCA_LogProtocolErrors              = $0002;
  CWBSO_TCA_IPSourceRouting                = $0003;
  CWBSO_TCA_TCPUrgentPointer               = $0004;
  CWBSO_TCA_IPReassemblyTimeout            = $0005;
  CWBSO_TCA_IPTimeToLive                   = $0006;
  CWBSO_TCA_TCPKeepAlive                   = $0007;
  CWBSO_TCA_TCPReceiveBuffer               = $0008;
  CWBSO_TCA_TCPSendBuffer                  = $0009;
  CWBSO_TCA_ARPCacheTimeout                = $000a;
  CWBSO_TCA_MTUPathDiscovery               = $000b;
  CWBSO_TCA_MTUDiscoveryInterval           = $000c;
  CWBSO_TCA_HostName                       = $000d;
  CWBSO_TCA_DomainName                     = $000e;
  CWBSO_TCA_InternetAddress1               = $000f;
  CWBSO_TCA_InternetAddress2               = $0010;
  CWBSO_TCA_InternetAddress3               = $0011;
  CWBSO_TCA_DNSProtocol                    = $0012;
  CWBSO_TCA_Retries                        = $0013;
  CWBSO_TCA_TimeInterval                   = $0014;
  CWBSO_TCA_SearchOrder                    = $0015;
  CWBSO_TCA_DNSListeningPort               = $0016;

// new ones for V5R1
  CWBSO_TCA_QOSEnablement                  = $0017;
  CWBSO_TCA_QOSTimerResolution             = $0018;
  CWBSO_TCA_QOSDataPathOptimization        = $0019;
  CWBSO_TCA_DeadGatewayDetectionEnablement = $001a;
  CWBSO_TCA_DeadGatewayDetectionInterval   = $001b;
  CWBSO_TCA_TCPTimeWaitTimeout             = $001c;
  CWBSO_TCA_TCPR1RetransmissionCount       = $001d;
  CWBSO_TCA_TCPR2RetransmissionCount       = $001e;
  CWBSO_TCA_InitialDomainNameServer        = $001f;
  CWBSO_TCA_DomainSearchList               = $0020;
  CWBSO_TCA_LastAttribute                  = $0020;

// user
  CWBSO_USR_ProfileName                                = CWBSO_PRF_ProfileName;
  CWBSO_USR_ProfileOrGroupIndicator                    = CWBSO_PRF_ProfileOrGroupIndicator;
  CWBSO_USR_GroupHasMembers                            = CWBSO_PRF_GroupHasMembers;
  CWBSO_USR_TextDescription                            = CWBSO_PRF_TextDescription;
  CWBSO_USR_PreviousSignonDate                         = $0004;
  CWBSO_USR_PreviousSignonTime                         = $0005;
  CWBSO_USR_SignonAttemptsNotValid                     = $0006;
  CWBSO_USR_Status                                     = $0007;
  CWBSO_USR_NoPasswordIndicator                        = $0009;
  CWBSO_USR_PasswordExpirationInterval                 = $000a;
  CWBSO_USR_DaysUntilPasswordExpires                   = $000c;
  CWBSO_USR_SetPasswordToExpire                        = $000d;
  CWBSO_USR_DisplaySignonInformation                   = $000e;
  CWBSO_USR_UserClassName                              = $000f;
  CWBSO_USR_AllObjectAccess                            = $0010;
  CWBSO_USR_SecurityAdministration                     = $0011;
  CWBSO_USR_JobControl                                 = $0012;
  CWBSO_USR_SpoolControl                               = $0013;
  CWBSO_USR_SaveAndRestore                             = $0014;
  CWBSO_USR_SystemServiceAccess                        = $0015;
  CWBSO_USR_AuditingControl                            = $0016;
  CWBSO_USR_SystemConfiguration                        = $0017;
  CWBSO_USR_GroupProfileName                           = $0018;
  CWBSO_USR_Owner                                      = $0019;
  CWBSO_USR_GroupAuthority                             = $001a;
  CWBSO_USR_LimitCapabilities                          = $001b;
  CWBSO_USR_GroupAuthorityType                         = $001c;
  CWBSO_USR_SupplementalGroups                         = $001d;
  CWBSO_USR_AssistanceLevel                            = $001e;
  CWBSO_USR_CurrentLibraryName                         = $001f;
  CWBSO_USR_InitialMenuName                            = $0020;
  CWBSO_USR_InitialMenuLibraryName                     = $0021;
  CWBSO_USR_InitialProgramName                         = $0022;
  CWBSO_USR_InitialProgramLibraryName                  = $0023;
  CWBSO_USR_LimitDeviceSessions                        = $0024;
  CWBSO_USR_KeyboardBuffering                          = $0025;
  CWBSO_USR_MaximumAllowedStorage                      = $0026;
  CWBSO_USR_StorageUsed                                = $0027;
  CWBSO_USR_HighestSchedulingPriority                  = $0028;
  CWBSO_USR_JobDescriptionName                         = $0029;
  CWBSO_USR_JobDescriptionNameLibrary                  = $002a;
  CWBSO_USR_AccountingCode                             = $002b;
  CWBSO_USR_MessageQueueName                           = $002c;
  CWBSO_USR_MessageQueueLibraryName                    = $002d;
  CWBSO_USR_MessageQueueDeliveryMethod                 = $002e;
  CWBSO_USR_MessageQueueSeverity                       = $002f;
  CWBSO_USR_OutputQueue                                = $0030;
  CWBSO_USR_OutputQueueLibrary                         = $0031;
  CWBSO_USR_PrintDevice                                = $0032;
  CWBSO_USR_SpecialEnvironment                         = $0033;
  CWBSO_USR_AttentionKeyHandlingProgramName            = $0034;
  CWBSO_USR_AttentionKeyHandlingProgramLibrary         = $0035;
  CWBSO_USR_LanguageID                                 = $0036;
  CWBSO_USR_CountryID                                  = $0037;
  CWBSO_USR_CharacterCodeSetID                         = $0038;
  CWBSO_USR_ShowParameterKeywords                      = $0039;
  CWBSO_USR_ShowAllDetails                             = $003a;
  CWBSO_USR_DisplayHelpOnFullScreen                    = $003b;
  CWBSO_USR_ShowStatusMessages                         = $003c;
  CWBSO_USR_DoNotShowStatusMessages                    = $003d;
  CWBSO_USR_ChangeDirectionOfRollkey                   = $003e;
  CWBSO_USR_SendMessageToSpoolFileOwner                = $003f;
  CWBSO_USR_SortSequenceTableName                      = $0040;
  CWBSO_USR_SortSequenceTableLibraryName               = $0041;
  CWBSO_USR_DigitalCertificateIndicator                = $0042;
  CWBSO_USR_CharacterIDControl                         = $0043;
  CWBSO_USR_ObjectAuditValue                           = $0044;
  CWBSO_USR_CommandUsage                               = $0045;
  CWBSO_USR_ObjectCreation                             = $0046;
  CWBSO_USR_ObjectDeletion                             = $0047;
  CWBSO_USR_JobTasks                                   = $0048;
  CWBSO_USR_ObjectManagement                           = $0049;
  CWBSO_USR_OfficeTasks                                = $004a;
  CWBSO_USR_ProgramAdoption                            = $004b;
  CWBSO_USR_SaveAndRestoreTasks                        = $004c;
  CWBSO_USR_SecurityTasks                              = $004d;
  CWBSO_USR_ServiceTasks                               = $004e;
  CWBSO_USR_SpoolManagement                            = $004f;
  CWBSO_USR_SystemManagement                           = $0050;
  CWBSO_USR_OpticalTasks                               = $0051;
  CWBSO_USR_UserIDNumber                               = $0052;
  CWBSO_USR_GroupIDNumber                              = $0053;
  CWBSO_USR_DoNotSetAnyJobAttributes                   = $0054;
  CWBSO_USR_UseSystemValue                             = $0055;
  CWBSO_USR_CodedCharacterSetID                        = $0056;
  CWBSO_USR_DateFormat                                 = $0057;
  CWBSO_USR_DateSeparator                              = $0058;
  CWBSO_USR_SortSequenceTable                          = $0059;
  CWBSO_USR_TimeSeparator                              = $005a;
  CWBSO_USR_DecimalFormat                              = $005b;
  CWBSO_USR_HomeDirectoryDelimiter                     = $005c;
  CWBSO_USR_HomeDirectory                              = $005d;
  CWBSO_USR_Locale                                     = $005e;
  CWBSO_USR_IndirectUser                               = $005f;
  CWBSO_USR_PrintCoverPage                             = $0060;
  CWBSO_USR_MailNotification                           = $0061;
  CWBSO_USR_UserID                                     = $0062;
  CWBSO_USR_LocalDataIndicator                         = $0063;
  CWBSO_USR_UserAddress                                = $0064;
  CWBSO_USR_SystemName                                 = $0065;
  CWBSO_USR_SystemGroup                                = $0066;
  CWBSO_USR_UserDescription                            = $0067;
  CWBSO_USR_FirstName                                  = $0068;
  CWBSO_USR_PreferredName                              = $0069;
  CWBSO_USR_MiddleName                                 = $006a;
  CWBSO_USR_LastName                                   = $006b;
  CWBSO_USR_FullName                                   = $006c;
  CWBSO_USR_JobTitle                                   = $006d;
  CWBSO_USR_CompanyName                                = $006e;
  CWBSO_USR_DepartmentName                             = $006f;
  CWBSO_USR_NetworkUserID                              = $0070;
  CWBSO_USR_PrimaryTelephoneNumber                     = $0071;
  CWBSO_USR_SecondaryTelephoneNumber                   = $0072;
  CWBSO_USR_FaxNumber                                  = $0073;
  CWBSO_USR_Location                                   = $0074;
  CWBSO_USR_BuildingNumber                             = $0075;
  CWBSO_USR_OfficeNumber                               = $0076;
  CWBSO_USR_MailingAddress                             = $0077;
  CWBSO_USR_MailingAddress2                            = $0078;
  CWBSO_USR_MailingAddress3                            = $0079;
  CWBSO_USR_MailingAddress4                            = $007a;
  CWBSO_USR_CCMailAddress                              = $007b;
  CWBSO_USR_CCMailComment                              = $007c;
  CWBSO_USR_MailServerFrameworkServiceLevel            = $007d;
  CWBSO_USR_PreferredAddressFieldName                  = $007e;
  CWBSO_USR_PreferredAddressProductID                  = $007f;
  CWBSO_USR_PreferredAddressTypeValue                  = $0080;
  CWBSO_USR_PreferredAddressTypeName                   = $0081;
  CWBSO_USR_PreferredAddress                           = $0082;
  CWBSO_USR_ManagerCode                                = $0083;
  CWBSO_USR_SMTPUserID                                 = $0084;
  CWBSO_USR_SMTPDomain                                 = $0085;
  CWBSO_USR_SMTPRoute                                  = $0086;

// In release/version V4R4 and above, the attributes $87-$99 are
// only meaningful when Lotus Notes is installed on the AS/400
  CWBSO_USR_NotesServerName                            = $0087;
  CWBSO_USR_NotesCertifierID                           = $0088;
  CWBSO_USR_MailType                                   = $0089;
  CWBSO_USR_NotesMailFileName                          = $008a;
  CWBSO_USR_CreateMailFiles                            = $008b;
  CWBSO_USR_NotesForwardingAddress                     = $008c;
  CWBSO_USR_SecurityType                               = $008d;
  CWBSO_USR_LicenseType                                = $008e;
  CWBSO_USR_MinimumNotesPasswordLength                 = $008f;
  CWBSO_USR_UpdateExistingNotesUser                    = $0090;
  CWBSO_USR_NotesMailServer                            = $0091;
  CWBSO_USR_LocationWhereUserIDIsStored                = $0092;
  CWBSO_USR_ReplaceExistingNotesID                     = $0093;
  CWBSO_USR_NotesComment                               = $0094;
  CWBSO_USR_NotesUserLocation                          = $0095;
  CWBSO_USR_UserPassword                               = $0096;
  CWBSO_USR_NotesUserPassword                          = $0097;
  CWBSO_USR_NotesCertifierPassword                     = $0098;
  CWBSO_USR_ShortName                                  = $0099;

  CWBSO_USR_PasswordChangeDate                         = $009a;
  CWBSO_USR_PasswordChangeDateFmt                      = $009b;
  CWBSO_USR_PasswordChangeTimeFmt                      = $009c;
  CWBSO_USR_DatePasswordExpires                        = $009d;
  CWBSO_USR_DatePasswordExpiresFmt                     = $009e;
  CWBSO_USR_TimePasswordExpiresFmt                     = $009f;
  CWBSO_USR_LastAttribute                              = $009f;

// user group
  CWBSO_USG_ProfileName                                =  CWBSO_PRF_ProfileName;
  CWBSO_USG_ProfileOrGroupIndicator                    =  CWBSO_PRF_ProfileOrGroupIndicator;
  CWBSO_USG_GroupHasMembers                            =  CWBSO_PRF_GroupHasMembers;
  CWBSO_USG_TextDescription                            =  CWBSO_PRF_TextDescription;
  CWBSO_USG_UserClassName                              = $0004;
  CWBSO_USG_AllObjectAccess                            = $0005;
  CWBSO_USG_SecurityAdministration                     = $0006;
  CWBSO_USG_JobControl                                 = $0007;
  CWBSO_USG_SpoolControl                               = $0008;
  CWBSO_USG_SaveAndRestore                             = $0009;
  CWBSO_USG_SystemServiceAccess                        = $000a;
  CWBSO_USG_AuditingControl                            = $000b;
  CWBSO_USG_SystemConfiguration                        = $000c;
  CWBSO_USG_GroupProfileName                           = $000d;
  CWBSO_USG_GroupIDNumber                              = $000e;
  CWBSO_USG_GroupUIDNumber                             = $000f;
  CWBSO_USG_LastAttribute                              = $000f;

// sample library
  CWBSO_SMP_Library                                    = $0000;
  CWBSO_SMP_InformationStatus                          = $0001;
  CWBSO_SMP_ExtendedAttribute                          = $0002;
  CWBSO_SMP_Description                                = $0003;
  CWBSO_SMP_UserDefinedAttribute                       = $0004;
  CWBSO_SMP_TypeOfLibrary                              = $0005;
  CWBSO_SMP_AuxilliaryStoragePool                      = $0006;
  CWBSO_SMP_CreateAuthority                            = $0007;
  CWBSO_SMP_CreateObjectAuditing                       = $0008;
  CWBSO_SMP_LastAttribute                              = $0008;

// Remote Command definition for parameter types
  CWBRC_INPUT                 = 1;
  CWBRC_OUTPUT                = 2;
  CWBRC_INOUT                 = 3;

  CWBRC_TEXT_CONVERT          = $0030;
  CWBRC_TEXT_CONVERT_INPUT    = $0010;
  CWBRC_TEXT_CONVERT_OUTPUT   = $0020;

// Remote Command return codes
  CWBRC_START                  = CWB_LAST+1;
  CWBRC_INVALID_SYSTEM_HANDLE  = CWBRC_START;
  CWBRC_INVALID_PROGRAM        = CWBRC_START+1;
  CWBRC_SYSTEM_NAME            = CWBRC_START+2;
  CWBRC_COMMAND_STRING         = CWBRC_START+3;
  CWBRC_PROGRAM_NAME           = CWBRC_START+4;
  CWBRC_LIBRARY_NAME           = CWBRC_START+5;
  CWBRC_INVALID_TYPE           = CWBRC_START+6;
  CWBRC_INVALID_PARM_LENGTH    = CWBRC_START+7;
  CWBRC_INVALID_PARM           = CWBRC_START+8;
  CWBRC_TOO_MANY_PARMS         = CWBRC_START+9;
  CWBRC_INDEX_RANGE_ERROR      = CWBRC_START+10;
  CWBRC_REJECTED_USER_EXIT     = CWBRC_START+11;
  CWBRC_USER_EXIT_ERROR        = CWBRC_START+12;
  CWBRC_COMMAND_FAILED         = CWBRC_START+13;
  CWBRC_PROGRAM_NOT_FOUND      = CWBRC_START+14;
  CWBRC_PROGRAM_ERROR          = CWBRC_START+15;
  CWBRC_COMMAND_TOO_LONG       = CWBRC_START+16;
  CWBRC_UNEXPECTED_ERROR       = CWBRC_START+99;

// autoinserted from mkinclude
{.Interface ca400procs begin}
Const
  icwbAD_GetClientVersion                  = 0;
  icwbAD_GetProductFixLevel                = 1;
  icwbCO_CanModifyDefaultUserMode          = 2;
  icwbCO_CanModifyIPAddress                = 3;
  icwbCO_CanModifyIPAddressLookupMode      = 4;
  icwbCO_CanModifyPersistenceMode          = 5;
  icwbCO_CanModifyPortLookupMode           = 6;
  icwbCO_CanModifyUseSecureSockets         = 7;
  icwbCO_ChangePassword                    = 8;
  icwbCO_Connect                           = 9;
  icwbCO_CreateSystem                      = 10;
  icwbCO_CreateSystemLike                  = 11;
  icwbCO_DeleteSystem                      = 12;
  icwbCO_Disconnect                        = 13;
  icwbCO_GetConnectTimeout                 = 14;
  icwbCO_GetDefaultSysName                 = 15;
  icwbCO_GetDefaultUserMode                = 16;
  icwbCO_GetDescription                    = 17;
  icwbCO_GetFailedSignons                  = 18;
  icwbCO_GetHostCCSID                      = 19;
  icwbCO_GetHostVersionEx                  = 20;
  icwbCO_GetIPAddress                      = 21;
  icwbCO_GetIPAddressLookupMode            = 22;
  icwbCO_GetPasswordExpireDate             = 23;
  icwbCO_GetPersistenceMode                = 24;
  icwbCO_GetPortLookupMode                 = 25;
  icwbCO_GetPrevSignonDate                 = 26;
  icwbCO_GetPromptMode                     = 27;
  icwbCO_GetSignonDate                     = 28;
  icwbCO_GetSystemName                     = 29;
  icwbCO_GetUserIDEx                       = 30;
  icwbCO_GetValidateMode                   = 31;
  icwbCO_GetWindowHandle                   = 32;
  icwbCO_HasSignedOn                       = 33;
  icwbCO_IsConnected                       = 34;
  icwbCO_IsSecureSockets                   = 35;
  icwbCO_SetConnectTimeout                 = 36;
  icwbCO_SetDefaultUserMode                = 37;
  icwbCO_SetIPAddress                      = 38;
  icwbCO_SetIPAddressLookupMode            = 39;
  icwbCO_SetPassword                       = 40;
  icwbCO_SetPersistenceMode                = 41;
  icwbCO_SetPortLookupMode                 = 42;
  icwbCO_SetPromptMode                     = 43;
  icwbCO_SetUserIDEx                       = 44;
  icwbCO_SetValidateMode                   = 45;
  icwbCO_SetWindowHandle                   = 46;
  icwbCO_Signon                            = 47;
  icwbCO_UseSecureSockets                  = 48;
  icwbCO_Verify                            = 49;
  icwbCO_VerifyUserIDPassword              = 50;
  icwbDB_AddLibraryToList                  = 51;
  icwbDB_AddMember                         = 52;
  icwbDB_ApplyAttributes                   = 53;
  icwbDB_ClearMember                       = 54;
  icwbDB_ClearPackage                      = 55;
  icwbDB_Close                             = 56;
  icwbDB_Commit                            = 57;
  icwbDB_Connect                           = 58;
  icwbDB_CreateCatalogRequestHandle        = 59;
  icwbDB_CreateConnectionHandle            = 60;
  icwbDB_CreateConnectionHandleEx          = 61;
  icwbDB_CreateDataFormatHandle            = 62;
  icwbDB_CreateDataHandle                  = 63;
  icwbDB_CreateDuplicateFile               = 64;
  icwbDB_CreateNDBRequestHandle            = 65;
  icwbDB_CreatePackage                     = 66;
  icwbDB_CreateParameterMarkerFormatHandle = 67;
  icwbDB_CreateSourcePhysicalFile          = 68;
  icwbDB_CreateSQLRequestHandle            = 69;
  icwbDB_DeleteCatalogRequestHandle        = 70;
  icwbDB_DeleteConnectionHandle            = 71;
  icwbDB_DeleteDataFormatHandle            = 72;
  icwbDB_DeleteDataHandle                  = 73;
  icwbDB_DeleteFile                        = 74;
  icwbDB_DeleteNDBRequestHandle            = 75;
  icwbDB_DeletePackage                     = 76;
  icwbDB_DeleteParameterMarkerFormatHandle = 77;
  icwbDB_DeleteSQLRequestHandle            = 78;
  icwbDB_Describe                          = 79;
  icwbDB_DescribeParameterMarkers          = 80;
  icwbDB_DynamicStreamFetch                = 81;
  icwbDB_EndStreamFetch                    = 82;
  icwbDB_Execute                           = 83;
  icwbDB_ExecuteImmediate                  = 84;
  icwbDB_ExtendedDynamicStreamFetch        = 85;
  icwbDB_Fetch                             = 86;
  icwbDB_GetBaseColumnName                 = 87;
  icwbDB_GetBaseSchemaName                 = 88;
  icwbDB_GetBaseTableName                  = 89;
  icwbDB_GetColumnCCSID                    = 90;
  icwbDB_GetColumnCount                    = 91;
  icwbDB_GetColumnLength                   = 92;
  icwbDB_GetColumnName                     = 93;
  icwbDB_GetColumnPrecision                = 94;
  icwbDB_GetColumnScale                    = 95;
  icwbDB_GetColumnType                     = 96;
  icwbDB_GetCommitmentControl              = 97;
  icwbDB_GetConversionIndicator            = 98;
  icwbDB_GetData                           = 99;
  icwbDB_GetDataLength                     = 100;
  icwbDB_GetDataPointer                    = 101;
  icwbDB_GetDateFormat                     = 102;
  icwbDB_GetDateSeparator                  = 103;
  icwbDB_GetDecimalSeparator               = 104;
  icwbDB_GetExtendedColumnInfo             = 105;
  icwbDB_GetIgnoreDecimalDataError         = 106;
  icwbDB_GetLabelName                      = 107;
  icwbDB_GetLOBLocator                     = 108;
  icwbDB_GetLOBMaxSize                     = 109;
  icwbDB_GetNamingConvention               = 110;
  icwbDB_GetParameterCCSID                 = 111;
  icwbDB_GetParameterCount                 = 112;
  icwbDB_GetParameterDirection             = 113;
  icwbDB_GetParameterLength                = 114;
  icwbDB_GetParameterName                  = 115;
  icwbDB_GetParameterPrecision             = 116;
  icwbDB_GetParameterScale                 = 117;
  icwbDB_GetParameterType                  = 118;
  icwbDB_GetRelationalDBName               = 119;
  icwbDB_GetRowSize                        = 120;
  icwbDB_GetServerFunctionalLevel          = 121;
  icwbDB_GetSizeOfInputParameters          = 122;
  icwbDB_GetSizeOfOutputParameters         = 123;
  icwbDB_GetSizeOfParameters               = 124;
  icwbDB_GetTimeFormat                     = 125;
  icwbDB_GetTimeSeparator                  = 126;
  icwbDB_IsParameterInput                  = 127;
  icwbDB_IsParameterInputOutput            = 128;
  icwbDB_MoreStreamData                    = 129;
  icwbDB_Open                              = 130;
  icwbDB_OpenDescribeFetch                 = 131;
  icwbDB_OverrideFile                      = 132;
  icwbDB_Prepare                           = 133;
  icwbDB_PrepareDescribe                   = 134;
  icwbDB_PrepareDescribeOpenFetch          = 135;
  icwbDB_RemoveMember                      = 136;
  icwbDB_RemoveOverride                    = 137;
  icwbDB_RetrieveFieldInformation          = 138;
  icwbDB_RetrieveFileInformation           = 139;
  icwbDB_RetrieveForeignKeyInformation     = 140;
  icwbDB_RetrieveIndexInformation          = 141;
  icwbDB_RetrieveLibraryInformation        = 142;
  icwbDB_RetrieveLOBData                   = 143;
  icwbDB_RetrieveMemberInformation         = 144;
  icwbDB_RetrievePackageStatementInformation= 145;
  icwbDB_RetrievePrimaryKeyInformation     = 146;
  icwbDB_RetrieveRDBInformation            = 147;
  icwbDB_RetrieveRecordFormatInformation   = 148;
  icwbDB_RetrieveSpecialColumnInformation  = 149;
  icwbDB_RetrieveSQLPackageInformation     = 150;
  icwbDB_ReturnData                        = 151;
  icwbDB_ReturnDataFormat                  = 152;
  icwbDB_ReturnExtendedDataFormat          = 153;
  icwbDB_ReturnHostErrorInfo               = 154;
  icwbDB_ReturnParameterMarkerFormat       = 155;
  icwbDB_ReturnSQLCA                       = 156;
  icwbDB_Rollback                          = 157;
  icwbDB_SetAddLibraryName                 = 158;
  icwbDB_SetAddLibraryPosition             = 159;
  icwbDB_SetAllowAddStatementToPackage     = 160;
  icwbDB_SetAmbiguousSelectOption          = 161;
  icwbDB_SetAuthority                      = 162;
  icwbDB_SetAutoCommit                     = 163;
  icwbDB_SetBaseFile                       = 164;
  icwbDB_SetBlockCount                     = 165;
  icwbDB_SetClientColumnToNumeric          = 166;
  icwbDB_SetClientColumnToString           = 167;
  icwbDB_SetClientDataCCSID                = 168;
  icwbDB_SetClientHostErrorCCSID           = 169;
  icwbDB_SetClientInputCCSID               = 170;
  icwbDB_SetClientParameterToNumeric       = 171;
  icwbDB_SetClientParameterToString        = 172;
  icwbDB_SetCommitmentControl              = 173;
  icwbDB_SetConversionIndicator            = 174;
  icwbDB_SetConvert65535                   = 175;
  icwbDB_SetCursorName                     = 176;
  icwbDB_SetCursorReuse                    = 177;
  icwbDB_SetDateFormat                     = 178;
  icwbDB_SetDateSeparator                  = 179;
  icwbDB_SetDecimalSeparator               = 180;
  icwbDB_SetDefaultSQLLibraryName          = 181;
  icwbDB_SetDescribeOption                 = 182;
  icwbDB_SetExtendedDataFormat             = 183;
  icwbDB_SetFetchScrollOptions             = 184;
  icwbDB_SetFieldName                      = 185;
  icwbDB_SetFileAttributes                 = 186;
  icwbDB_SetFileInfoOrdering               = 187;
  icwbDB_SetFileName                       = 188;
  icwbDB_SetFileText                       = 189;
  icwbDB_SetFileType                       = 190;
  icwbDB_SetForeignKeyFileName             = 191;
  icwbDB_SetForeignKeyLibName              = 192;
  icwbDB_SetFormatName                     = 193;
  icwbDB_SetHoldIndicator                  = 194;
  icwbDB_SetIgnoreDecimalDataError         = 195;
  icwbDB_SetIndexType                      = 196;
  icwbDB_SetLibraryName                    = 197;
  icwbDB_SetLOBFieldThreshold              = 198;
  icwbDB_SetLongFileName                   = 199;
  icwbDB_SetMaximumMembers                 = 200;
  icwbDB_SetMemberName                     = 201;
  icwbDB_SetMemberText                     = 202;
  icwbDB_SetNamingConvention               = 203;
  icwbDB_SetNLSS                           = 204;
  icwbDB_SetNullable                       = 205;
  icwbDB_SetOverrideInformation            = 206;
  icwbDB_SetPackageName                    = 207;
  icwbDB_SetParameterMarkerBlock           = 208;
  icwbDB_SetParameterMarkers               = 209;
  icwbDB_SetPatternMatching                = 210;
  icwbDB_SetPrepareOption                  = 211;
  icwbDB_SetPrimaryKeyFileName             = 212;
  icwbDB_SetPrimaryKeyLibName              = 213;
  icwbDB_SetQueryTimeoutValue              = 214;
  icwbDB_SetRDBName                        = 215;
  icwbDB_SetRecordLength                   = 216;
  icwbDB_SetRelationalDBName               = 217;
  icwbDB_SetScrollableCursor               = 218;
  icwbDB_SetStatementName                  = 219;
  icwbDB_SetStatementText                  = 220;
  icwbDB_SetStatementType                  = 221;
  icwbDB_SetStaticCursorResultSetThreshold = 222;
  icwbDB_SetStreamFetchSyncCount           = 223;
  icwbDB_SetTimeFormat                     = 224;
  icwbDB_SetTimeSeparator                  = 225;
  icwbDB_StartServer                       = 226;
  icwbDB_StartServerDetailed               = 227;
  icwbDB_StopServer                        = 228;
  icwbDB_StoreRequestParameters            = 229;
  icwbDB_WriteLOBData                      = 230;
  icwbNL_CCSIDToCodePage                   = 231;
  icwbNL_CodePageToCCSID                   = 232;
  icwbNL_Convert                           = 233;
  icwbNL_ConvertCodePages                  = 234;
  icwbNL_CreateConverter                   = 235;
  icwbNL_DeleteConverter                   = 236;
  icwbNL_GetANSICodePage                   = 237;
  icwbNL_GetCodePage                       = 238;
  icwbNL_GetHostCCSID                      = 239;
  icwbOBJ_AnalyzeSplFData                  = 240;
  icwbOBJ_AnswerSplFMsg                    = 241;
  icwbOBJ_CallExitPgmForSplF               = 242;
  icwbOBJ_CloseList                        = 243;
  icwbOBJ_CloseNewSplF                     = 244;
  icwbOBJ_CloseNewSplFAndGetHandle         = 245;
  icwbOBJ_CloseResource                    = 246;
  icwbOBJ_CloseSplF                        = 247;
  icwbOBJ_CopyObjHandle                    = 248;
  icwbOBJ_CopyParmObjHandle                = 249;
  icwbOBJ_CreateListHandle                 = 250;
  icwbOBJ_CreateNewSplF                    = 251;
  icwbOBJ_CreateParmObjHandle              = 252;
  icwbOBJ_CreateResourceHandle             = 253;
  icwbOBJ_CreateSplFHandle                 = 254;
  icwbOBJ_CreateSplFHandleEx               = 255;
  icwbOBJ_DeleteListHandle                 = 256;
  icwbOBJ_DeleteObjHandle                  = 257;
  icwbOBJ_DeleteParmObjHandle              = 258;
  icwbOBJ_DeleteSplF                       = 259;
  icwbOBJ_DisplayResource                  = 260;
  icwbOBJ_DisplaySplF                      = 261;
  icwbOBJ_DropConnections                  = 262;
  icwbOBJ_EndWriter                        = 263;
  icwbOBJ_GetListSize                      = 264;
  icwbOBJ_GetNPServerAttr                  = 265;
  icwbOBJ_GetObjAttr                       = 266;
  icwbOBJ_GetObjAttrs                      = 267;
  icwbOBJ_GetObjHandle                     = 268;
  icwbOBJ_GetObjHandleFromID               = 269;
  icwbOBJ_GetObjID                         = 270;
  icwbOBJ_GetParameter                     = 271;
  icwbOBJ_GetSplFHandleFromNewSplF         = 272;
  icwbOBJ_GetSplFMsgAttr                   = 273;
  icwbOBJ_HoldOutputQueue                  = 274;
  icwbOBJ_HoldSplF                         = 275;
  icwbOBJ_IsViewerAvailable                = 276;
  icwbOBJ_MoveSplF                         = 277;
  icwbOBJ_OpenList                         = 278;
  icwbOBJ_OpenResource                     = 279;
  icwbOBJ_OpenResourceForSplF              = 280;
  icwbOBJ_OpenSplF                         = 281;
  icwbOBJ_OpenSplFEx                       = 282;
  icwbOBJ_PurgeOutputQueue                 = 283;
  icwbOBJ_ReadResource                     = 284;
  icwbOBJ_ReadSplF                         = 285;
  icwbOBJ_RefreshObj                       = 286;
  icwbOBJ_ReleaseOutputQueue               = 287;
  icwbOBJ_ReleaseSplF                      = 288;
  icwbOBJ_ResetListAttrsToRetrieve         = 289;
  icwbOBJ_ResetListFilter                  = 290;
  icwbOBJ_SeekResource                     = 291;
  icwbOBJ_SeekSplF                         = 292;
  icwbOBJ_SendNetSplF                      = 293;
  icwbOBJ_SendTCPSplF                      = 294;
  icwbOBJ_SetConnectionsToKeep             = 295;
  icwbOBJ_SetListAttrsToRetrieve           = 296;
  icwbOBJ_SetListFilter                    = 297;
  icwbOBJ_SetListFilterWithSplF            = 298;
  icwbOBJ_SetObjAttrs                      = 299;
  icwbOBJ_SetParameter                     = 300;
  icwbOBJ_StartWriter                      = 301;
  icwbOBJ_WriteNewSplF                     = 302;
  icwbRC_AddParm                           = 303;
  icwbRC_CallPgm                           = 304;
  icwbRC_CreatePgm                         = 305;
  icwbRC_DeletePgm                         = 306;
  icwbRC_GetClientCCSID                    = 307;
  icwbRC_GetHostCCSID                      = 308;
  icwbRC_GetLibName                        = 309;
  icwbRC_GetParm                           = 310;
  icwbRC_GetParmCount                      = 311;
  icwbRC_GetPgmName                        = 312;
  icwbRC_GetSysName                        = 313;
  icwbRC_RunCmd                            = 314;
  icwbRC_SetLibName                        = 315;
  icwbRC_SetParm                           = 316;
  icwbRC_SetPgmName                        = 317;
  icwbRC_StartSys                          = 318;
  icwbRC_StartSysEx                        = 319;
  icwbRC_StopSys                           = 320;
  iCWBSO_CloseList                         = 321;
  iCWBSO_CopyObjHandle                     = 322;
  iCWBSO_CreateErrorHandle                 = 323;
  iCWBSO_CreateListHandle                  = 324;
  iCWBSO_CreateListHandleEx                = 325;
  iCWBSO_CreateObjHandle                   = 326;
  iCWBSO_CreateParmObjHandle               = 327;
  iCWBSO_DeleteErrorHandle                 = 328;
  iCWBSO_DeleteListHandle                  = 329;
  iCWBSO_DeleteObjHandle                   = 330;
  iCWBSO_DeleteParmObjHandle               = 331;
  iCWBSO_DisallowListActions               = 332;
  iCWBSO_DisallowListFilter                = 333;
  iCWBSO_DisplayErrMsg                     = 334;
  iCWBSO_DisplayList                       = 335;
  iCWBSO_DisplayObjAttr                    = 336;
  iCWBSO_DisplaySplf                       = 337;
  iCWBSO_GetErrMsgText                     = 338;
  iCWBSO_GetListSize                       = 339;
  iCWBSO_GetObjAttr                        = 340;
  iCWBSO_GetObjHandle                      = 341;
  iCWBSO_OpenList                          = 342;
  iCWBSO_ReadListProfile                   = 343;
  iCWBSO_RefreshObj                        = 344;
  iCWBSO_ResetParmObj                      = 345;
  iCWBSO_SetListFilter                     = 346;
  iCWBSO_SetListProfile                    = 347;
  iCWBSO_SetListSortFields                 = 348;
  iCWBSO_SetListTitle                      = 349;
  iCWBSO_SetObjAttr                        = 350;
  iCWBSO_SetParameter                      = 351;
  iCWBSO_WaitForObj                        = 352;
  iCWBSO_WriteListProfile                  = 353;
  icwbSV_CreateErrHandle                   = 354;
  icwbSV_DeleteErrHandle                   = 355;
  icwbSV_GetErrCount                       = 356;
  icwbSV_GetErrTextIndexed                 = 357;
  icwbSY_CreateSecurityObj                 = 358;
  icwbSY_DeleteSecurityObj                 = 359;
  icwbSY_GetUserID                         = 360;
  icwbSY_LogonUser                         = 361;
  icwbSY_SetSys                            = 362;
  Function cwbAD_GetClientVersion(Var version: Cardinal; Var release: Cardinal; Var modificationlevel: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbAD_GetProductFixLevel(szBuffer: LPCSTR; Var ulBufLen: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_CanModifyDefaultUserMode(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_CanModifyIPAddress(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_CanModifyIPAddressLookupMode(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_CanModifyPersistenceMode(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_CanModifyPortLookupMode(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_CanModifyUseSecureSockets(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_ChangePassword(system: cwbCO_SysHandle; userID: LPCSTR; oldPassword: LPCSTR; newPassword: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_Connect(system: cwbCO_SysHandle; service: cwbCO_Service; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_CreateSystem(systemName: LPCSTR; Var system: cwbCO_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_CreateSystemLike(systemToCopy: cwbCO_SysHandle; systemName: LPCSTR; Var system: cwbCO_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_DeleteSystem(system: cwbCO_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_Disconnect(system: cwbCO_SysHandle; service: cwbCO_Service; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetConnectTimeout(system: cwbCO_SysHandle; Var timeout: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetDefaultSysName(defaultSystemName: LPCSTR; bufferSize: Cardinal; Var needed: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetDefaultUserMode(system: cwbCO_SysHandle; Var mode: cwbCO_DefaultUserMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetDescription(system: cwbCO_SysHandle; description: LPCSTR; Var length: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetFailedSignons(system: cwbCO_SysHandle; Var numberFailedAttempts: Word; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetHostCCSID(system: cwbCO_SysHandle; Var CCSID: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetHostVersionEx(system: cwbCO_SysHandle; Var version: Cardinal; Var release: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetIPAddress(system: cwbCO_SysHandle; IPAddress: LPCSTR; Var length: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetIPAddressLookupMode(system: cwbCO_SysHandle; Var mode: cwbCO_IPAddressLookupMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetPasswordExpireDate(system: cwbCO_SysHandle; Var expirationDateTime: cwb_DateTime; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetPersistenceMode(system: cwbCO_SysHandle; Var mode: cwbCO_PersistenceMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetPortLookupMode(system: cwbCO_SysHandle; Var mode: cwbCO_PortLookupMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetPrevSignonDate(system: cwbCO_SysHandle; Var signonDateTime: cwb_DateTime; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetPromptMode(system: cwbCO_SysHandle; Var mode: cwbCO_PromptMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetSignonDate(system: cwbCO_SysHandle; Var signonDateTime: cwb_DateTime; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetSystemName(system: cwbCO_SysHandle; sysName: LPCSTR; Var length: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetUserIDEx(system: cwbCO_SysHandle; userID: LPCSTR; Var length: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetValidateMode(system: cwbCO_SysHandle; Var mode: cwbCO_ValidateMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_GetWindowHandle(system: cwbCO_SysHandle; Var windowHandle: THandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_HasSignedOn(system: cwbCO_SysHandle; Var signedOn: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_IsConnected(system: cwbCO_SysHandle; service: cwbCO_Service; Var numberOfConnections: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_IsSecureSockets(system: cwbCO_SysHandle; Var inUse: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetConnectTimeout(system: cwbCO_SysHandle; timeout: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetDefaultUserMode(system: cwbCO_SysHandle; mode: cwbCO_DefaultUserMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetIPAddress(system: cwbCO_SysHandle; IPAddress: LPCSTR; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetIPAddressLookupMode(system: cwbCO_SysHandle; mode: cwbCO_IPAddressLookupMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetPassword(system: cwbCO_SysHandle; password: LPCSTR; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetPersistenceMode(system: cwbCO_SysHandle; mode: cwbCO_PersistenceMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetPortLookupMode(system: cwbCO_SysHandle; mode: cwbCO_PortLookupMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetPromptMode(system: cwbCO_SysHandle; mode: cwbCO_PromptMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetUserIDEx(system: cwbCO_SysHandle; userID: LPCSTR; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetValidateMode(system: cwbCO_SysHandle; mode: cwbCO_ValidateMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_SetWindowHandle(system: cwbCO_SysHandle; windowHandle: THandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_Signon(system: cwbCO_SysHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_UseSecureSockets(system: cwbCO_SysHandle; useSecureSockets: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_Verify(system: cwbCO_SysHandle; service: cwbCO_Service; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbCO_VerifyUserIDPassword(system: cwbCO_SysHandle; userID: LPCSTR; password: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_AddLibraryToList(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_AddMember(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ApplyAttributes(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ClearMember(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ClearPackage(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_Close(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_Commit(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_Connect(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateCatalogRequestHandle(connection: cwbDB_ConnectionHandle; Var request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateConnectionHandle(systemName: LPCSTR; Var connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateConnectionHandleEx(sysHandle: cwbCO_SysHandle; Var connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateDataFormatHandle(connection: cwbDB_ConnectionHandle; Var format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateDataHandle(Var dataHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateDuplicateFile(request: cwbDB_RequestHandle; copyDataIndicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateNDBRequestHandle(connection: cwbDB_ConnectionHandle; Var request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreatePackage(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateParameterMarkerFormatHandle(connection: cwbDB_ConnectionHandle; Var format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateSourcePhysicalFile(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_CreateSQLRequestHandle(connection: cwbDB_ConnectionHandle; Var request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DeleteCatalogRequestHandle(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DeleteConnectionHandle(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DeleteDataFormatHandle(format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DeleteDataHandle(dataHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DeleteFile(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DeleteNDBRequestHandle(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DeletePackage(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DeleteParameterMarkerFormatHandle(format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DeleteSQLRequestHandle(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_Describe(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DescribeParameterMarkers(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_DynamicStreamFetch(request: cwbDB_RequestHandle; statementText: PChar; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_EndStreamFetch(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_Execute(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ExecuteImmediate(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ExtendedDynamicStreamFetch(request: cwbDB_RequestHandle; libraryName: PChar; packageName: PChar; statementName: PChar; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_Fetch(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetBaseColumnName(format: cwbDB_FormatHandle; columnPosition: Cardinal; columnHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetBaseSchemaName(format: cwbDB_FormatHandle; columnPosition: Cardinal; schemaHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetBaseTableName(format: cwbDB_FormatHandle; columnPosition: Cardinal; tableHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetColumnCCSID(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetColumnCount(format: cwbDB_FormatHandle; Var columnCount: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetColumnLength(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataLength: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetColumnName(format: cwbDB_FormatHandle; columnPosition: Cardinal; columnHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetColumnPrecision(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataPrecision: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetColumnScale(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataScale: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetColumnType(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataType: SmallInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetCommitmentControl(connection: cwbDB_ConnectionHandle; Var commitmentLevel: Word;  errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetConversionIndicator(format: cwbDB_FormatHandle; Var conversionIndicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetData(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetDataLength(dataHandle: cwbDB_DataHandle; Var dataLength: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetDataPointer(dataHandle: cwbDB_DataHandle; Var data: Pointer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetDateFormat(connection: cwbDB_ConnectionHandle; Var dateFormat: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetDateSeparator(connection: cwbDB_ConnectionHandle; Var dateSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetDecimalSeparator(connection: cwbDB_ConnectionHandle; Var decimalSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetExtendedColumnInfo(format: cwbDB_FormatHandle; columnPosition: Cardinal; Var columnInfo: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetIgnoreDecimalDataError(connection: cwbDB_ConnectionHandle; Var ignoreDecimalError: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetLabelName(format: cwbDB_FormatHandle; columnPosition: Cardinal; labelHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetLOBLocator(format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var dataLocator: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetLOBMaxSize(format: cwbDB_FormatHandle; columnPosition: Cardinal; Var maxSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetNamingConvention(connection: cwbDB_ConnectionHandle; Var namingConvention: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetParameterCCSID(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetParameterCount(format: cwbDB_FormatHandle; Var parameterCount: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetParameterDirection(format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var columnDirection: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetParameterLength(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataLength: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetParameterName(format: cwbDB_FormatHandle; parameterPosition: Cardinal; parameterHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetParameterPrecision(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataPrecision: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetParameterScale(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataScale: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetParameterType(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataType: SmallInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetRelationalDBName(connection: cwbDB_ConnectionHandle; relationalDBName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetRowSize(format: cwbDB_FormatHandle; location: Cardinal; Var rowSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetServerFunctionalLevel(connection: cwbDB_ConnectionHandle; serverFunctionalLevel: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetSizeOfInputParameters(format: cwbDB_FormatHandle; location: Cardinal; Var inputSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetSizeOfOutputParameters(format: cwbDB_FormatHandle; location: Cardinal; Var outputSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetSizeOfParameters(format: cwbDB_FormatHandle; Var Size: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetTimeFormat(connection: cwbDB_ConnectionHandle; Var timeFormat: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_GetTimeSeparator(connection: cwbDB_ConnectionHandle; Var timeSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_IsParameterInput(format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var parameterIsInput: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_IsParameterInputOutput(format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var parameterIsInputOutput: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_MoreStreamData(request: cwbDB_RequestHandle; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_Open(request: cwbDB_RequestHandle; openOptions: Byte; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_OpenDescribeFetch(request: cwbDB_RequestHandle; openOptions: Byte; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_OverrideFile(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_Prepare(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_PrepareDescribe(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_PrepareDescribeOpenFetch(request: cwbDB_RequestHandle; openOptions: Byte; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RemoveMember(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RemoveOverride(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveFieldInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveFileInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveForeignKeyInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveIndexInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveLibraryInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveLOBData(request: cwbDB_RequestHandle; data: cwbDB_DataHandle; locator: Cardinal; size: Cardinal; start: Cardinal; columnIndex: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveMemberInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrievePackageStatementInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrievePrimaryKeyInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveRDBInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveRecordFormatInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveSpecialColumnInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_RetrieveSQLPackageInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ReturnData(request: cwbDB_RequestHandle; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ReturnDataFormat(request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ReturnExtendedDataFormat(request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ReturnHostErrorInfo(request: cwbDB_RequestHandle; Var hostErrorClass: Word; Var hostErrorCode: Integer; hostMsgID: cwbDB_DataHandle; firstLevelMessageText: cwbDB_DataHandle; secondLevelMessageText: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ReturnParameterMarkerFormat(request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_ReturnSQLCA(request: cwbDB_RequestHandle; Var sqlca: cwbDB_SQLCA; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_Rollback(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetAddLibraryName(request: cwbDB_RequestHandle; addLibraryName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetAddLibraryPosition(request: cwbDB_RequestHandle; position: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetAllowAddStatementToPackage(connection: cwbDB_ConnectionHandle; allowAdd: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetAmbiguousSelectOption(connection: cwbDB_ConnectionHandle; updateability: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetAuthority(request: cwbDB_RequestHandle; authority: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetAutoCommit(connection: cwbDB_ConnectionHandle; autoCommit: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetBaseFile(request: cwbDB_RequestHandle; baseLibraryName: PChar; baseFileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetBlockCount(request: cwbDB_RequestHandle; blockCount: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetClientColumnToNumeric(format: cwbDB_FormatHandle; columnPosition: Cardinal; columnType: ShortInt; columnLength: Cardinal; columnPrecision: Word; columnScale: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetClientColumnToString(format: cwbDB_FormatHandle; columnPosition: Cardinal; columnType: ShortInt; columnLength: Cardinal; columnCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetClientDataCCSID(connection: cwbDB_ConnectionHandle; clientDataCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetClientHostErrorCCSID(connection: cwbDB_ConnectionHandle; clientHostErrorCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetClientInputCCSID(connection: cwbDB_ConnectionHandle; inputCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetClientParameterToNumeric(format: cwbDB_FormatHandle; parameterPosition: Cardinal; parameterType: ShortInt; parameterLength: Cardinal; parameterPrecision: Word; parameterScale: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetClientParameterToString(format: cwbDB_FormatHandle; parameterPosition: Cardinal; parameterType: ShortInt; parameterLength: Cardinal; parameterCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetCommitmentControl(connection: cwbDB_ConnectionHandle; commitmentLevel: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetConversionIndicator(format: cwbDB_FormatHandle; conversionIndicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetConvert65535(connection: cwbDB_ConnectionHandle; convert65535indicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetCursorName(request: cwbDB_RequestHandle; cursorName: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetCursorReuse(request: cwbDB_RequestHandle; reuseIndicator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetDateFormat(connection: cwbDB_ConnectionHandle; dateFormat: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetDateSeparator(connection: cwbDB_ConnectionHandle; dateSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetDecimalSeparator(connection: cwbDB_ConnectionHandle; decimalSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetDefaultSQLLibraryName(connection: cwbDB_ConnectionHandle; libraryName: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetDescribeOption(request: cwbDB_RequestHandle; describeOption: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetExtendedDataFormat(request: cwbDB_RequestHandle; extendedFormatIndicator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetFetchScrollOptions(request: cwbDB_RequestHandle; scrollType: Word; relativeDistance: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetFieldName(request: cwbDB_RequestHandle; fieldName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetFileAttributes(request: cwbDB_RequestHandle; fileAttributes: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetFileInfoOrdering(request: cwbDB_RequestHandle; fileInfoOrder: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetFileName(request: cwbDB_RequestHandle; fileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetFileText(request: cwbDB_RequestHandle; fileText: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetFileType(request: cwbDB_RequestHandle; fileType: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetForeignKeyFileName(request: cwbDB_RequestHandle; fileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetForeignKeyLibName(request: cwbDB_RequestHandle; libName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetFormatName(request: cwbDB_RequestHandle; formatName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetHoldIndicator(request: cwbDB_RequestHandle; holdIndicator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetIgnoreDecimalDataError(connection: cwbDB_ConnectionHandle; ignoreDecimalError: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetIndexType(request: cwbDB_RequestHandle; indexType: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetLibraryName(request: cwbDB_RequestHandle; libraryName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetLOBFieldThreshold(connection: cwbDB_ConnectionHandle; thresholdSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetLongFileName(request: cwbDB_RequestHandle; longFileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetMaximumMembers(request: cwbDB_RequestHandle; maxMembers: ShortInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetMemberName(request: cwbDB_RequestHandle; memberName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetMemberText(request: cwbDB_RequestHandle; memberText: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetNamingConvention(connection: cwbDB_ConnectionHandle; newNamingConvention: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetNLSS(connection: cwbDB_ConnectionHandle; NLSSTypeID: Word; tableOrLangID: PChar; lib: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetNullable(request: cwbDB_RequestHandle; nullableInd: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetOverrideInformation(request: cwbDB_RequestHandle; overrideLibraryName: PChar; overrideFileName: PChar; overrideMemberName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetPackageName(request: cwbDB_RequestHandle; packageName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetParameterMarkerBlock(request: cwbDB_RequestHandle; numberOfRows: Cardinal; format: cwbDB_FormatHandle; dataPointer: Pointer; indicators: PShortInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetParameterMarkers(request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; dataBuffer: Pointer; indicators: PSmallInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetPatternMatching(request: cwbDB_RequestHandle; objectType: Word; patternMatch: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetPrepareOption(request: cwbDB_RequestHandle; prepareOption: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetPrimaryKeyFileName(request: cwbDB_RequestHandle; fileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetPrimaryKeyLibName(request: cwbDB_RequestHandle; libName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetQueryTimeoutValue(request: cwbDB_RequestHandle; timeout: Integer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetRDBName(request: cwbDB_RequestHandle; RDBName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetRecordLength(request: cwbDB_RequestHandle; recordLength: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetRelationalDBName(connection: cwbDB_ConnectionHandle; relationalDBName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetScrollableCursor(request: cwbDB_RequestHandle; scrollIndicator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetStatementName(request: cwbDB_RequestHandle; statementName: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetStatementText(request: cwbDB_RequestHandle; statementText: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetStatementType(request: cwbDB_RequestHandle; statementType: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetStaticCursorResultSetThreshold(request: cwbDB_RequestHandle; thresholdSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetStreamFetchSyncCount(request: cwbDB_RequestHandle; syncCount: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetTimeFormat(connection: cwbDB_ConnectionHandle; timeFormat: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_SetTimeSeparator(connection: cwbDB_ConnectionHandle; timeSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_StartServer(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_StartServerDetailed(connection: cwbDB_ConnectionHandle; Var returnCode: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_StopServer(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_StoreRequestParameters(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbDB_WriteLOBData(request: cwbDB_RequestHandle; dataPointer: Pointer; locator: Cardinal; ccsid: Word; size: Cardinal; start: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbNL_CCSIDToCodePage(CCSID: Cardinal; Var codePage: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbNL_CodePageToCCSID(codePage: Cardinal; Var CCSID: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbNL_Convert(theConverter: cwbNL_Converter; sourceLength: Cardinal; targetLength: Cardinal; sourceBuffer: PChar; targetBuffer: PChar; Var numberOfErrors: Cardinal; Var firstErrorIndex: Cardinal; Var requiredLen: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbNL_ConvertCodePages(sourceCodePage: Cardinal; targetCodePage: Cardinal; sourceLength: Cardinal; targetLength: Cardinal; sourceBuffer: PChar; targetBuffer: PChar; Var numberOfErrors: Cardinal; Var firstErrorIndex: Cardinal; Var requiredLen: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbNL_CreateConverter(sourceCodePage: Cardinal; targetCodePage: Cardinal; Var theConverter: cwbNL_Converter; errorHandle: cwbSV_ErrHandle; shiftInShiftOutStatus: Cardinal; padLength: Cardinal; pad: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbNL_DeleteConverter(theConverter: cwbNL_Converter; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbNL_GetANSICodePage(Var codePage: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbNL_GetCodePage(Var codePage: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbNL_GetHostCCSID(system: PChar; Var CCSID: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_AnalyzeSplFData(data: PChar; bufLen: Cardinal; Var dataType: cwbOBJ_SplFDataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_AnswerSplFMsg(splFHandle: cwbOBJ_ObjHandle; msgAnswer: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CallExitPgmForSplF(splFHandle: cwbOBJ_ObjHandle; data: Pointer; dataLen: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CloseList(listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CloseNewSplF(newsplFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CloseNewSplFAndGetHandle(newsplFHandle: cwbOBJ_ObjHandle; Var splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CloseResource(resourceHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CloseSplF(splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CopyObjHandle(objectHandle: cwbOBJ_ObjHandle; Var newObjectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CopyParmObjHandle(parmListHandle: cwbOBJ_ObjHandle; Var newParmListHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CreateListHandle(systemName: LPCSTR; Atype: cwbOBJ_ListType; Var listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CreateNewSplF(systemName: LPCSTR; parmListHandle: cwbOBJ_ObjHandle; Var printerFileHandle: cwbOBJ_ObjHandle; Var outputQueueHandle: cwbOBJ_ObjHandle; Var newSplFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CreateParmObjHandle(Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CreateResourceHandle(systemName: LPCSTR; resourceName: LPCSTR; resourceLibrary: LPCSTR; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CreateSplFHandle(systemName: LPCSTR; jobName: LPCSTR; jobNumber: LPCSTR; jobUser: LPCSTR; splFName: LPCSTR; splFNumber: Cardinal; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_CreateSplFHandleEx(systemName: LPCSTR; jobName: LPCSTR; jobNumber: LPCSTR; jobUser: LPCSTR; splFName: LPCSTR; splFNumber: Cardinal; createdSystem: LPCSTR; createdDate: LPCSTR; createdTime: LPCSTR; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_DeleteListHandle(listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_DeleteObjHandle(objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_DeleteParmObjHandle(parmListHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_DeleteSplF(splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_DisplayResource(resourceHandle: cwbOBJ_ObjHandle; view: LPCSTR; flags: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_DisplaySplF(splFHandle: cwbOBJ_ObjHandle; view: LPCSTR; flags: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_DropConnections(errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_EndWriter(writerHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetListSize(listHandle: cwbOBJ_ListHandle; Var size: Integer; Var listStatus: cwbOBJ_List_Status; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetNPServerAttr(systemName: LPCSTR; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetObjAttr(objectHandle: cwbOBJ_ObjHandle; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetObjAttrs(objectHandle: cwbOBJ_ObjHandle; numAttrs: Cardinal; Var getAttrParms: cwbOBJ_GetObjAttrParms; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetObjHandle(listHandle: cwbOBJ_ListHandle; position: Cardinal; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetObjHandleFromID(idBuffer: Pointer; bufLen: Cardinal; objectType: cwbOBJ_ObjType; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetObjID(objectHandle: cwbOBJ_ObjHandle; idBuffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetParameter(parmListHandle: cwbOBJ_ParmHandle; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetSplFHandleFromNewSplF(newSplFHandle: cwbOBJ_ObjHandle; Var splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_GetSplFMsgAttr(splFHandle: cwbOBJ_ObjHandle; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_HoldOutputQueue(queueHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_HoldSplF(splFHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_IsViewerAvailable(errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_MoveSplF(splFHandle: cwbOBJ_ObjHandle; Var targetSplFHandle: cwbOBJ_ObjHandle; Var outputQueueHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_OpenList(listHandle: cwbOBJ_ListHandle; openType: cwbOBJ_List_OpenType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_OpenResource(resourceHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_OpenResourceForSplF(splFHandle: cwbOBJ_ObjHandle; resourceName: LPCSTR; resourceLibrary: LPCSTR; resourceType: Cardinal; reserved: LPCSTR; Var resourceHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_OpenSplF(splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_OpenSplFEx(splFHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_PurgeOutputQueue(queueHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_ReadResource(resourceHandle: cwbOBJ_ObjHandle; bBuffer: PChar; bytesToRead: Cardinal; Var bytesRead: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_ReadSplF(splFHandle: cwbOBJ_ObjHandle; Var bBuffer: PChar; bytesToRead: Cardinal; Var bytesRead: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_RefreshObj(objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_ReleaseOutputQueue(queueHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_ReleaseSplF(splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_ResetListAttrsToRetrieve(listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_ResetListFilter(listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SeekResource(resourceHandle: cwbOBJ_ListHandle; seekOrigin: cwbOBJ_SeekOrigin; seekOffset: Integer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SeekSplF(splFHandle: cwbOBJ_ListHandle; seekOrigin: cwbOBJ_SeekOrigin; seekOffset: Integer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SendNetSplF(splFHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SendTCPSplF(splFHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SetConnectionsToKeep(systemName: LPCSTR; connections: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SetListAttrsToRetrieve(listHandle: cwbOBJ_ListHandle; numKeys: Cardinal; keys: Array Of cwbOBJ_KeyID; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SetListFilter(listHandle: cwbOBJ_ListHandle; key: cwbOBJ_KeyID; Value: Pointer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SetListFilterWithSplF(listHandle: cwbOBJ_ListHandle; splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SetObjAttrs(objectHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_SetParameter(parmListHandle: cwbOBJ_ParmHandle; key: cwbOBJ_KeyID; Value: Pointer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_StartWriter(Var printerHandle: cwbOBJ_ObjHandle; Var outputQueueHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; Var writerHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbOBJ_WriteNewSplF(newSplFHandle: cwbOBJ_ObjHandle; data: PChar; dataLen: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_AddParm(pgm: cwbRC_PgmHandle; ParamType: Word; length: Cardinal; Parameter: Pointer; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_CallPgm(system: cwbRC_SysHandle; pgm: cwbRC_PgmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_CreatePgm(programName: PChar; libraryName: PChar; Var pgm: cwbRC_PgmHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_DeletePgm(pgm: cwbRC_PgmHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_GetClientCCSID(system: cwbRC_SysHandle; Var clientCCSID: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_GetHostCCSID(system: cwbRC_SysHandle; Var hostCCSID: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_GetLibName(pgm: cwbRC_PgmHandle; libraryName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_GetParm(pgm: cwbRC_PgmHandle; index: Word; Var ParamType: Word; Var length: Cardinal; Var parameter: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_GetParmCount(pgm: cwbRC_PgmHandle; Var Count: Word; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_GetPgmName(pgm: cwbRC_PgmHandle; programName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_GetSysName(system: cwbRC_SysHandle; systemName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_RunCmd(system: cwbRC_SysHandle; commandString: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_SetLibName(pgm: cwbRC_PgmHandle; libraryName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_SetParm(pgm: cwbRC_PgmHandle; index: Word; ParamType: Word; Length: Cardinal; parameter: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_SetPgmName(pgm: cwbRC_PgmHandle; programName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_StartSys(systemName: PChar; appName: PChar; Var system: cwbRC_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_StartSysEx(systemObj: cwbCO_SysHandle; Var system: cwbRC_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbRC_StopSys(system: cwbRC_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_CloseList(listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_CopyObjHandle(objectHandle: cwbSO_ObjHandle; Var newObjectHandle: cwbSO_ObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_CreateErrorHandle(Var ErrorHandle: cwbSO_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_CreateListHandle(szSystemName: PChar; szApplicationName: PChar; listtype: CWBSO_LISTTYPE; Var listHandle: cwbSO_ListHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_CreateListHandleEx(systemObjectHandle: cwbCO_SysHandle; listType: CWBSO_LISTTYPE; Var listHandle: cwbSO_ListHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_CreateObjHandle(szSystemName: PChar; szApplicationName: PChar; objtype: CWBSO_OBJTYPE; Var objHandle: cwbSO_ObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_CreateParmObjHandle(Var parmObjHandle: cwbSO_ParmObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DeleteErrorHandle(errorHandle: cwbSO_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DeleteListHandle(listHandle: cwbSO_ListHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DeleteObjHandle(objectHandle: cwbSO_ObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DeleteParmObjHandle(parmObjHandle: cwbSO_ParmObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DisallowListActions(listHandle: cwbSO_ListHandle; Var usActionIDs: Word; Count: Word; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DisallowListFilter(listHandle: cwbSO_ListHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DisplayErrMsg(errorHandle: cwbSO_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DisplayList(listHandle: cwbSO_ListHandle; Instance: THandle; cmdShow: Integer; Var hWnd: THandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DisplayObjAttr(objectHandle: cwbSO_ObjHandle; Instance: THandle; cmdShow: Integer; Var hWnd: THandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_DisplaySplf(objectHandle: cwbSO_ObjHandle; View: PChar; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_GetErrMsgText(errorHandle: cwbSO_ErrHandle; msgBuffer: PChar; bufferLength: Cardinal; Var bytesNeeded: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_GetListSize(listHandle: cwbSO_ListHandle; Var Size: Integer; Var Status: Word; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_GetObjAttr(objectHandle: cwbSO_ObjHandle; AttributeID: Word; Buffer: PChar; bufferLength: Cardinal; Var bytesNeeded: Cardinal; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_GetObjHandle(listHandle: cwbSO_ListHandle; position: Cardinal; Var objectHandle: cwbSO_ObjHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_OpenList(listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_ReadListProfile(listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_RefreshObj(objectHandle: cwbSO_ObjHandle; Wnd: HWND; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_ResetParmObj(parmObjHandle: cwbSO_ParmObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_SetListFilter(listHandle: cwbSO_ListHandle; FilterID: Word; Value: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_SetListProfile(listHandle: cwbSO_ListHandle; FilterID: Word; Key: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_SetListSortFields(listHandle: cwbSO_ListHandle; SortIDs: PChar; Count: Word; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_SetListTitle(listHandle: cwbSO_ListHandle; Title: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_SetObjAttr(objectHandle: cwbSO_ObjHandle; parmObjHandle: cwbSO_ParmObjHandle; Var errorIndex: Word; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_SetParameter(parmObjHandle: cwbSO_ParmObjHandle; AttributeID: Word; Value: PChar; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_WaitForObj(listHandle: cwbSO_ListHandle; Position: Cardinal; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function CWBSO_WriteListProfile(listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbSV_CreateErrHandle(Var errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbSV_DeleteErrHandle(errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbSV_GetErrCount(errorHandle: cwbSV_ErrHandle; Var count: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbSV_GetErrTextIndexed(errorHandle: cwbSV_ErrHandle; index: Cardinal; messageText: pChar; messageTextLength: Cardinal; Var returnlength: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbSY_CreateSecurityObj(Var securityHandle: cwbSY_SecurityHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbSY_DeleteSecurityObj(securityHandle: cwbSY_SecurityHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbSY_GetUserID(securityHandle: cwbSY_SecurityHandle; systemName: PChar; userID: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbSY_LogonUser(securityHandle: cwbSY_SecurityHandle; userID: LPCSTR; password: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;
  Function cwbSY_SetSys(securityHandle: cwbSY_SecurityHandle; systemName: LPCSTR; Handler: TCustomcwbErrorHandler=Nil): cwb_Result; StdCall;

{.Interface ca400procs end}

Type
  TDebugCallBack = Function (Const Value: String): Boolean Of Object;
  Procedure RegisterDebug (Value: TDebugCallBack);
  Procedure UnRegisterDebug (Value: TDebugCallBack);

Var
  BindError: Boolean;

  Function cwbReleaseStr: String;
  Function cwbRelease: Integer;
  Function cwbCheck (Index: Integer; Value: cwb_Result; Handler: TCustomcwbErrorHandler; Where: Pointer=Nil): cwb_Result;
  Function cwbIsCallable (Index: Integer): Boolean;
  Function BindErrors: String;

  Function ConvertCP (LenSrc: Integer; Src: PChar; LenDst: Integer; Dst: PChar; SrcCP, DstCP: Cardinal; Var Count: Cardinal;  errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
  Function ConvertCPStr (Const Value: String; Var Dst: String; SrcCP, DstCP: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;

Implementation

Type
  TCallEntry = Record
    DllIndex: Integer;
    Name: PChar;
    Proc: Pointer;
    Options: Integer;
  End;

  Function cwbInvalid (Index: Integer; Var Func): Boolean; Forward;

Function ReturnAddr: Pointer;
Asm
  Mov EAx, [EBP+4]
End;

// autoinserted from mkinclude
{.Implementation ca400procs begin}
Var
  DllHandles: Array[0..8] Of THandle;
  DllNames: Array[0..8] Of PChar = ('cwbad.dll','cwbco.dll','cwbdb.dll','cwbnl.dll','cwbobj.dll','cwbrc.dll','cwbsoapi.dll','cwbsv.dll','cwbsy.dll');
  CallTable: Array[0..362] Of TCallEntry = (
  (DllIndex: 0; Name: 'cwbAD_GetClientVersion'                  ; Options: 1;),
  (DllIndex: 0; Name: 'cwbAD_GetProductFixLevel'                ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_CanModifyDefaultUserMode'          ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_CanModifyIPAddress'                ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_CanModifyIPAddressLookupMode'      ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_CanModifyPersistenceMode'          ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_CanModifyPortLookupMode'           ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_CanModifyUseSecureSockets'         ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_ChangePasswordA'                   ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_Connect'                           ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_CreateSystemA'                     ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_CreateSystemLikeA'                 ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_DeleteSystem'                      ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_Disconnect'                        ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetConnectTimeout'                 ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetDefaultSysNameA'                ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetDefaultUserMode'                ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetDescriptionA'                   ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetFailedSignons'                  ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetHostCCSID'                      ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetHostVersionEx'                  ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetIPAddressA'                     ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetIPAddressLookupMode'            ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetPasswordExpireDate'             ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetPersistenceMode'                ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetPortLookupMode'                 ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetPrevSignonDate'                 ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetPromptMode'                     ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetSignonDate'                     ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetSystemNameA'                    ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetUserIDExA'                      ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetValidateMode'                   ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_GetWindowHandle'                   ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_HasSignedOn'                       ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_IsConnected'                       ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_IsSecureSockets'                   ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetConnectTimeout'                 ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetDefaultUserMode'                ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetIPAddressA'                     ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetIPAddressLookupMode'            ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetPasswordA'                      ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetPersistenceMode'                ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetPortLookupMode'                 ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetPromptMode'                     ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetUserIDExA'                      ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetValidateMode'                   ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_SetWindowHandle'                   ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_Signon'                            ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_UseSecureSockets'                  ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_Verify'                            ; Options: 1;),
  (DllIndex: 1; Name: 'cwbCO_VerifyUserIDPasswordA'             ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_AddLibraryToList'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_AddMember'                         ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_ApplyAttributes'                   ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_ClearMember'                       ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_ClearPackage'                      ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_Close'                             ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_Commit'                            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_ConnectA'                          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_CreateCatalogRequestHandle'        ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_CreateConnectionHandleA'           ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_CreateConnectionHandleEx'          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_CreateDataFormatHandle'            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_CreateDataHandle'                  ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_CreateDuplicateFile'               ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_CreateNDBRequestHandle'            ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_CreatePackage'                     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_CreateParameterMarkerFormatHandle' ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_CreateSourcePhysicalFile'          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_CreateSQLRequestHandle'            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_DeleteCatalogRequestHandle'        ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_DeleteConnectionHandle'            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_DeleteDataFormatHandle'            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_DeleteDataHandle'                  ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_DeleteFile'                        ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_DeleteNDBRequestHandle'            ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_DeletePackage'                     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_DeleteParameterMarkerFormatHandle' ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_DeleteSQLRequestHandle'            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_Describe'                          ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_DescribeParameterMarkers'          ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_DynamicStreamFetchA'               ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_EndStreamFetch'                    ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_Execute'                           ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_ExecuteImmediate'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_ExtendedDynamicStreamFetchA'       ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_Fetch'                             ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetBaseColumnName'                 ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetBaseSchemaName'                 ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetBaseTableName'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetColumnCCSID'                    ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetColumnCount'                    ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetColumnLength'                   ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetColumnName'                     ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetColumnPrecision'                ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetColumnScale'                    ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetColumnType'                     ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetCommitmentControl'              ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetConversionIndicator'            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetData'                           ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetDataLength'                     ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetDataPointer'                    ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetDateFormat'                     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetDateSeparator'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetDecimalSeparator'               ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetExtendedColumnInfo'             ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetIgnoreDecimalDataError'         ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetLabelName'                      ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetLOBLocator'                     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetLOBMaxSize'                     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetNamingConvention'               ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetParameterCCSID'                 ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetParameterCount'                 ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetParameterDirection'             ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetParameterLength'                ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetParameterName'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetParameterPrecision'             ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetParameterScale'                 ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetParameterType'                  ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetRelationalDBName'               ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetRowSize'                        ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetServerFunctionalLevel'          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetSizeOfInputParameters'          ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetSizeOfOutputParameters'         ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_GetSizeOfParameters'               ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetTimeFormat'                     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_GetTimeSeparator'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_IsParameterInput'                  ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_IsParameterInputOutput'            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_MoreStreamData'                    ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_Open'                              ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_OpenDescribeFetch'                 ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_OverrideFile'                      ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_Prepare'                           ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_PrepareDescribe'                   ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_PrepareDescribeOpenFetch'          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RemoveMember'                      ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RemoveOverride'                    ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveFieldInformation'          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveFileInformation'           ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveForeignKeyInformation'     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveIndexInformation'          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveLibraryInformation'        ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveLOBData'                   ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveMemberInformation'         ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrievePackageStatementInformation'; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrievePrimaryKeyInformation'     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveRDBInformation'            ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveRecordFormatInformation'   ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveSpecialColumnInformation'  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_RetrieveSQLPackageInformation'     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_ReturnData'                        ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_ReturnDataFormat'                  ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_ReturnExtendedDataFormat'          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_ReturnHostErrorInfo'               ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_ReturnParameterMarkerFormat'       ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_ReturnSQLCA'                       ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_Rollback'                          ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetAddLibraryNameA'                ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetAddLibraryPosition'             ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetAllowAddStatementToPackage'     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetAmbiguousSelectOption'          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetAuthority'                      ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetAutoCommit'                     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetBaseFileA'                      ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetBlockCount'                     ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetClientColumnToNumeric'          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetClientColumnToString'           ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetClientDataCCSID'                ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetClientHostErrorCCSID'           ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetClientInputCCSID'               ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetClientParameterToNumeric'       ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetClientParameterToString'        ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetCommitmentControl'              ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetConversionIndicator'            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetConvert65535'                   ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetCursorNameA'                    ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetCursorReuse'                    ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetDateFormat'                     ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetDateSeparator'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetDecimalSeparator'               ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetDefaultSQLLibraryNameA'         ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetDescribeOption'                 ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetExtendedDataFormat'             ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetFetchScrollOptions'             ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetFieldNameA'                     ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetFileAttributes'                 ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetFileInfoOrdering'               ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetFileNameA'                      ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetFileTextA'                      ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetFileType'                       ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetForeignKeyFileNameA'            ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetForeignKeyLibNameA'             ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetFormatNameA'                    ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetHoldIndicator'                  ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetIgnoreDecimalDataError'         ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetIndexType'                      ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetLibraryNameA'                   ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetLOBFieldThreshold'              ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetLongFileNameA'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetMaximumMembers'                 ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetMemberNameA'                    ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetMemberTextA'                    ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetNamingConvention'               ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetNLSSA'                          ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetNullable'                       ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetOverrideInformationA'           ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetPackageNameA'                   ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetParameterMarkerBlock'           ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetParameterMarkers'               ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetPatternMatching'                ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetPrepareOption'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetPrimaryKeyFileNameA'            ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetPrimaryKeyLibNameA'             ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetQueryTimeoutValue'              ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetRDBNameA'                       ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetRecordLength'                   ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetRelationalDBNameA'              ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetScrollableCursor'               ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetStatementNameA'                 ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetStatementText'                  ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetStatementType'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetStaticCursorResultSetThreshold' ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetStreamFetchSyncCount'           ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_SetTimeFormat'                     ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_SetTimeSeparator'                  ; Options: 1;),
  (DllIndex: 2; Name: 'cwbDB_StartServer'                       ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_StartServerDetailed'               ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_StopServer'                        ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_StoreRequestParameters'            ; Options: 0;),
  (DllIndex: 2; Name: 'cwbDB_WriteLOBData'                      ; Options: 1;),
  (DllIndex: 3; Name: 'cwbNL_CCSIDToCodePage'                   ; Options: 1;),
  (DllIndex: 3; Name: 'cwbNL_CodePageToCCSID'                   ; Options: 1;),
  (DllIndex: 3; Name: 'cwbNL_Convert'                           ; Options: 1;),
  (DllIndex: 3; Name: 'cwbNL_ConvertCodePages'                  ; Options: 0;),
  (DllIndex: 3; Name: 'cwbNL_CreateConverter'                   ; Options: 1;),
  (DllIndex: 3; Name: 'cwbNL_DeleteConverter'                   ; Options: 1;),
  (DllIndex: 3; Name: 'cwbNL_GetANSICodePage'                   ; Options: 0;),
  (DllIndex: 3; Name: 'cwbNL_GetCodePage'                       ; Options: 1;),
  (DllIndex: 3; Name: 'cwbNL_GetHostCCSID'                      ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_AnalyzeSplFData'                  ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_AnswerSplFMsgA'                   ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CallExitPgmForSplF'               ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CloseList'                        ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CloseNewSplF'                     ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CloseNewSplFAndGetHandle'         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CloseResource'                    ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CloseSplF'                        ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CopyObjHandle'                    ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CopyParmObjHandle'                ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CreateListHandleA'                ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CreateNewSplFA'                   ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CreateParmObjHandle'              ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CreateResourceHandleA'            ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CreateSplFHandleA'                ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_CreateSplFHandleExA'              ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_DeleteListHandle'                 ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_DeleteObjHandle'                  ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_DeleteParmObjHandle'              ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_DeleteSplF'                       ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_DisplayResourceA'                 ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_DisplaySplFA'                     ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_DropConnections'                  ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_EndWriter'                        ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetListSize'                      ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetNPServerAttrA'                 ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetObjAttrA'                      ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetObjAttrsA'                     ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetObjHandle'                     ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetObjHandleFromID'               ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetObjID'                         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetParameterA'                    ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetSplFHandleFromNewSplF'         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_GetSplFMsgAttrA'                  ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_HoldOutputQueue'                  ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_HoldSplF'                         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_IsViewerAvailable'                ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_MoveSplF'                         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_OpenList'                         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_OpenResource'                     ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_OpenResourceForSplFA'             ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_OpenSplF'                         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_OpenSplFEx'                       ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_PurgeOutputQueue'                 ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_ReadResource'                     ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_ReadSplF'                         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_RefreshObj'                       ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_ReleaseOutputQueue'               ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_ReleaseSplF'                      ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_ResetListAttrsToRetrieve'         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_ResetListFilter'                  ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SeekResource'                     ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SeekSplF'                         ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SendNetSplF'                      ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SendTCPSplF'                      ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SetConnectionsToKeepA'            ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SetListAttrsToRetrieve'           ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SetListFilter'                    ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SetListFilterWithSplF'            ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SetObjAttrs'                      ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_SetParameterA'                    ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_StartWriter'                      ; Options: 1;),
  (DllIndex: 4; Name: 'cwbOBJ_WriteNewSplF'                     ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_AddParmA'                          ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_CallPgm'                           ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_CreatePgmA'                        ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_DeletePgm'                         ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_GetClientCCSID'                    ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_GetHostCCSID'                      ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_GetLibNameA'                       ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_GetParm'                           ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_GetParmCount'                      ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_GetPgmNameA'                       ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_GetSysNameA'                       ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_RunCmdA'                           ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_SetLibNameA'                       ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_SetParm'                           ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_SetPgmNameA'                       ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_StartSysA'                         ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_StartSysExA'                       ; Options: 1;),
  (DllIndex: 5; Name: 'cwbRC_StopSys'                           ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_CloseList'                         ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_CopyObjHandle'                     ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_CreateErrorHandle'                 ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_CreateListHandle'                  ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_CreateListHandleEx'                ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_CreateObjHandle'                   ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_CreateParmObjHandle'               ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DeleteErrorHandle'                 ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DeleteListHandle'                  ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DeleteObjHandle'                   ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DeleteParmObjHandle'               ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DisallowListActions'               ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DisallowListFilter'                ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DisplayErrMsg'                     ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DisplayList'                       ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DisplayObjAttr'                    ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_DisplaySplf'                       ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_GetErrMsgText'                     ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_GetListSize'                       ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_GetObjAttr'                        ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_GetObjHandle'                      ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_OpenList'                          ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_ReadListProfile'                   ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_RefreshObj'                        ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_ResetParmObj'                      ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_SetListFilter'                     ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_SetListProfile'                    ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_SetListSortFields'                 ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_SetListTitle'                      ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_SetObjAttr'                        ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_SetParameter'                      ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_WaitForObj'                        ; Options: 1;),
  (DllIndex: 6; Name: 'CWBSO_WriteListProfile'                  ; Options: 1;),
  (DllIndex: 7; Name: 'cwbSV_CreateErrHandle'                   ; Options: 0;),
  (DllIndex: 7; Name: 'cwbSV_DeleteErrHandle'                   ; Options: 0;),
  (DllIndex: 7; Name: 'cwbSV_GetErrCount'                       ; Options: 0;),
  (DllIndex: 7; Name: 'cwbSV_GetErrTextIndexed'                 ; Options: 0;),
  (DllIndex: 8; Name: 'cwbSY_CreateSecurityObj'                 ; Options: 0;),
  (DllIndex: 8; Name: 'cwbSY_DeleteSecurityObj'                 ; Options: 0;),
  (DllIndex: 8; Name: 'cwbSY_GetUserIDA'                        ; Options: 0;),
  (DllIndex: 8; Name: 'cwbSY_LogonUserA'                        ; Options: 0;),
  (DllIndex: 8; Name: 'cwbSY_SetSysA'                           ; Options: 0;));

Function cwbAD_GetClientVersion(Var version: Cardinal; Var release: Cardinal; Var modificationlevel: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var version: Cardinal; Var release: Cardinal; Var modificationlevel: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbAD_GetClientVersion, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(version,release,modificationlevel);
  Result:= cwbCheck(icwbAD_GetClientVersion, Result, Handler, ReturnAddr)
End;

Function cwbAD_GetProductFixLevel(szBuffer: LPCSTR; Var ulBufLen: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (szBuffer: LPCSTR; Var ulBufLen: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbAD_GetProductFixLevel, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(szBuffer,ulBufLen);
  Result:= cwbCheck(icwbAD_GetProductFixLevel, Result, Handler, ReturnAddr)
End;

Function cwbCO_CanModifyDefaultUserMode(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var canModify: cwb_Boolean): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_CanModifyDefaultUserMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,canModify);
  Result:= cwbCheck(icwbCO_CanModifyDefaultUserMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_CanModifyIPAddress(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var canModify: cwb_Boolean): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_CanModifyIPAddress, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,canModify);
  Result:= cwbCheck(icwbCO_CanModifyIPAddress, Result, Handler, ReturnAddr)
End;

Function cwbCO_CanModifyIPAddressLookupMode(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var canModify: cwb_Boolean): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_CanModifyIPAddressLookupMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,canModify);
  Result:= cwbCheck(icwbCO_CanModifyIPAddressLookupMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_CanModifyPersistenceMode(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var canModify: cwb_Boolean): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_CanModifyPersistenceMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,canModify);
  Result:= cwbCheck(icwbCO_CanModifyPersistenceMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_CanModifyPortLookupMode(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var canModify: cwb_Boolean): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_CanModifyPortLookupMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,canModify);
  Result:= cwbCheck(icwbCO_CanModifyPortLookupMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_CanModifyUseSecureSockets(system: cwbCO_SysHandle; Var canModify: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var canModify: cwb_Boolean): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_CanModifyUseSecureSockets, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,canModify);
  Result:= cwbCheck(icwbCO_CanModifyUseSecureSockets, Result, Handler, ReturnAddr)
End;

Function cwbCO_ChangePassword(system: cwbCO_SysHandle; userID: LPCSTR; oldPassword: LPCSTR; newPassword: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; userID: LPCSTR; oldPassword: LPCSTR; newPassword: LPCSTR; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_ChangePassword, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,userID,oldPassword,newPassword,errorHandle);
  Result:= cwbCheck(icwbCO_ChangePassword, Result, Handler, ReturnAddr)
End;

Function cwbCO_Connect(system: cwbCO_SysHandle; service: cwbCO_Service; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; service: cwbCO_Service; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_Connect, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,service,errorHandle);
  Result:= cwbCheck(icwbCO_Connect, Result, Handler, ReturnAddr)
End;

Function cwbCO_CreateSystem(systemName: LPCSTR; Var system: cwbCO_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: LPCSTR; Var system: cwbCO_SysHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_CreateSystem, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,system);
  Result:= cwbCheck(icwbCO_CreateSystem, Result, Handler, ReturnAddr)
End;

Function cwbCO_CreateSystemLike(systemToCopy: cwbCO_SysHandle; systemName: LPCSTR; Var system: cwbCO_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemToCopy: cwbCO_SysHandle; systemName: LPCSTR; Var system: cwbCO_SysHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_CreateSystemLike, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemToCopy,systemName,system);
  Result:= cwbCheck(icwbCO_CreateSystemLike, Result, Handler, ReturnAddr)
End;

Function cwbCO_DeleteSystem(system: cwbCO_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_DeleteSystem, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system);
  Result:= cwbCheck(icwbCO_DeleteSystem, Result, Handler, ReturnAddr)
End;

Function cwbCO_Disconnect(system: cwbCO_SysHandle; service: cwbCO_Service; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; service: cwbCO_Service; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_Disconnect, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,service,errorHandle);
  Result:= cwbCheck(icwbCO_Disconnect, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetConnectTimeout(system: cwbCO_SysHandle; Var timeout: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var timeout: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetConnectTimeout, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,timeout);
  Result:= cwbCheck(icwbCO_GetConnectTimeout, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetDefaultSysName(defaultSystemName: LPCSTR; bufferSize: Cardinal; Var needed: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (defaultSystemName: LPCSTR; bufferSize: Cardinal; Var needed: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetDefaultSysName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(defaultSystemName,bufferSize,needed,errorHandle);
  Result:= cwbCheck(icwbCO_GetDefaultSysName, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetDefaultUserMode(system: cwbCO_SysHandle; Var mode: cwbCO_DefaultUserMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var mode: cwbCO_DefaultUserMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetDefaultUserMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_GetDefaultUserMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetDescription(system: cwbCO_SysHandle; description: LPCSTR; Var length: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; description: LPCSTR; Var length: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetDescription, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,description,length);
  Result:= cwbCheck(icwbCO_GetDescription, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetFailedSignons(system: cwbCO_SysHandle; Var numberFailedAttempts: Word; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var numberFailedAttempts: Word): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetFailedSignons, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,numberFailedAttempts);
  Result:= cwbCheck(icwbCO_GetFailedSignons, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetHostCCSID(system: cwbCO_SysHandle; Var CCSID: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var CCSID: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetHostCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,CCSID);
  Result:= cwbCheck(icwbCO_GetHostCCSID, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetHostVersionEx(system: cwbCO_SysHandle; Var version: Cardinal; Var release: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var version: Cardinal; Var release: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetHostVersionEx, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,version,release);
  Result:= cwbCheck(icwbCO_GetHostVersionEx, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetIPAddress(system: cwbCO_SysHandle; IPAddress: LPCSTR; Var length: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; IPAddress: LPCSTR; Var length: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetIPAddress, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,IPAddress,length);
  Result:= cwbCheck(icwbCO_GetIPAddress, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetIPAddressLookupMode(system: cwbCO_SysHandle; Var mode: cwbCO_IPAddressLookupMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var mode: cwbCO_IPAddressLookupMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetIPAddressLookupMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_GetIPAddressLookupMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetPasswordExpireDate(system: cwbCO_SysHandle; Var expirationDateTime: cwb_DateTime; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var expirationDateTime: cwb_DateTime): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetPasswordExpireDate, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,expirationDateTime);
  Result:= cwbCheck(icwbCO_GetPasswordExpireDate, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetPersistenceMode(system: cwbCO_SysHandle; Var mode: cwbCO_PersistenceMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var mode: cwbCO_PersistenceMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetPersistenceMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_GetPersistenceMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetPortLookupMode(system: cwbCO_SysHandle; Var mode: cwbCO_PortLookupMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var mode: cwbCO_PortLookupMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetPortLookupMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_GetPortLookupMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetPrevSignonDate(system: cwbCO_SysHandle; Var signonDateTime: cwb_DateTime; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var signonDateTime: cwb_DateTime): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetPrevSignonDate, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,signonDateTime);
  Result:= cwbCheck(icwbCO_GetPrevSignonDate, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetPromptMode(system: cwbCO_SysHandle; Var mode: cwbCO_PromptMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var mode: cwbCO_PromptMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetPromptMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_GetPromptMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetSignonDate(system: cwbCO_SysHandle; Var signonDateTime: cwb_DateTime; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var signonDateTime: cwb_DateTime): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetSignonDate, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,signonDateTime);
  Result:= cwbCheck(icwbCO_GetSignonDate, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetSystemName(system: cwbCO_SysHandle; sysName: LPCSTR; Var length: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; sysName: LPCSTR; Var length: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetSystemName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,sysName,length);
  Result:= cwbCheck(icwbCO_GetSystemName, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetUserIDEx(system: cwbCO_SysHandle; userID: LPCSTR; Var length: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; userID: LPCSTR; Var length: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetUserIDEx, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,userID,length);
  Result:= cwbCheck(icwbCO_GetUserIDEx, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetValidateMode(system: cwbCO_SysHandle; Var mode: cwbCO_ValidateMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var mode: cwbCO_ValidateMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetValidateMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_GetValidateMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_GetWindowHandle(system: cwbCO_SysHandle; Var windowHandle: THandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var windowHandle: THandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_GetWindowHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,windowHandle);
  Result:= cwbCheck(icwbCO_GetWindowHandle, Result, Handler, ReturnAddr)
End;

Function cwbCO_HasSignedOn(system: cwbCO_SysHandle; Var signedOn: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var signedOn: cwb_Boolean): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_HasSignedOn, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,signedOn);
  Result:= cwbCheck(icwbCO_HasSignedOn, Result, Handler, ReturnAddr)
End;

Function cwbCO_IsConnected(system: cwbCO_SysHandle; service: cwbCO_Service; Var numberOfConnections: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; service: cwbCO_Service; Var numberOfConnections: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_IsConnected, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,service,numberOfConnections);
  Result:= cwbCheck(icwbCO_IsConnected, Result, Handler, ReturnAddr)
End;

Function cwbCO_IsSecureSockets(system: cwbCO_SysHandle; Var inUse: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; Var inUse: cwb_Boolean): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_IsSecureSockets, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,inUse);
  Result:= cwbCheck(icwbCO_IsSecureSockets, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetConnectTimeout(system: cwbCO_SysHandle; timeout: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; timeout: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetConnectTimeout, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,timeout);
  Result:= cwbCheck(icwbCO_SetConnectTimeout, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetDefaultUserMode(system: cwbCO_SysHandle; mode: cwbCO_DefaultUserMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; mode: cwbCO_DefaultUserMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetDefaultUserMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_SetDefaultUserMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetIPAddress(system: cwbCO_SysHandle; IPAddress: LPCSTR; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; IPAddress: LPCSTR): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetIPAddress, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,IPAddress);
  Result:= cwbCheck(icwbCO_SetIPAddress, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetIPAddressLookupMode(system: cwbCO_SysHandle; mode: cwbCO_IPAddressLookupMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; mode: cwbCO_IPAddressLookupMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetIPAddressLookupMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_SetIPAddressLookupMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetPassword(system: cwbCO_SysHandle; password: LPCSTR; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; password: LPCSTR): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetPassword, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,password);
  Result:= cwbCheck(icwbCO_SetPassword, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetPersistenceMode(system: cwbCO_SysHandle; mode: cwbCO_PersistenceMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; mode: cwbCO_PersistenceMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetPersistenceMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_SetPersistenceMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetPortLookupMode(system: cwbCO_SysHandle; mode: cwbCO_PortLookupMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; mode: cwbCO_PortLookupMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetPortLookupMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_SetPortLookupMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetPromptMode(system: cwbCO_SysHandle; mode: cwbCO_PromptMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; mode: cwbCO_PromptMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetPromptMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_SetPromptMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetUserIDEx(system: cwbCO_SysHandle; userID: LPCSTR; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; userID: LPCSTR): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetUserIDEx, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,userID);
  Result:= cwbCheck(icwbCO_SetUserIDEx, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetValidateMode(system: cwbCO_SysHandle; mode: cwbCO_ValidateMode; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; mode: cwbCO_ValidateMode): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetValidateMode, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,mode);
  Result:= cwbCheck(icwbCO_SetValidateMode, Result, Handler, ReturnAddr)
End;

Function cwbCO_SetWindowHandle(system: cwbCO_SysHandle; windowHandle: THandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; windowHandle: THandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_SetWindowHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,windowHandle);
  Result:= cwbCheck(icwbCO_SetWindowHandle, Result, Handler, ReturnAddr)
End;

Function cwbCO_Signon(system: cwbCO_SysHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_Signon, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,errorHandle);
  Result:= cwbCheck(icwbCO_Signon, Result, Handler, ReturnAddr)
End;

Function cwbCO_UseSecureSockets(system: cwbCO_SysHandle; useSecureSockets: cwb_Boolean; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; useSecureSockets: cwb_Boolean): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_UseSecureSockets, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,useSecureSockets);
  Result:= cwbCheck(icwbCO_UseSecureSockets, Result, Handler, ReturnAddr)
End;

Function cwbCO_Verify(system: cwbCO_SysHandle; service: cwbCO_Service; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; service: cwbCO_Service; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_Verify, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,service,errorHandle);
  Result:= cwbCheck(icwbCO_Verify, Result, Handler, ReturnAddr)
End;

Function cwbCO_VerifyUserIDPassword(system: cwbCO_SysHandle; userID: LPCSTR; password: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbCO_SysHandle; userID: LPCSTR; password: LPCSTR; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbCO_VerifyUserIDPassword, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,userID,password,errorHandle);
  Result:= cwbCheck(icwbCO_VerifyUserIDPassword, Result, Handler, ReturnAddr)
End;

Function cwbDB_AddLibraryToList(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_AddLibraryToList, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_AddLibraryToList, Result, Handler, ReturnAddr)
End;

Function cwbDB_AddMember(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_AddMember, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_AddMember, Result, Handler, ReturnAddr)
End;

Function cwbDB_ApplyAttributes(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ApplyAttributes, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,errorHandle);
  Result:= cwbCheck(icwbDB_ApplyAttributes, Result, Handler, ReturnAddr)
End;

Function cwbDB_ClearMember(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ClearMember, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_ClearMember, Result, Handler, ReturnAddr)
End;

Function cwbDB_ClearPackage(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ClearPackage, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_ClearPackage, Result, Handler, ReturnAddr)
End;

Function cwbDB_Close(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_Close, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_Close, Result, Handler, ReturnAddr)
End;

Function cwbDB_Commit(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_Commit, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_Commit, Result, Handler, ReturnAddr)
End;

Function cwbDB_Connect(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_Connect, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,errorHandle);
  Result:= cwbCheck(icwbDB_Connect, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateCatalogRequestHandle(connection: cwbDB_ConnectionHandle; Var request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateCatalogRequestHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,request,errorHandle);
  Result:= cwbCheck(icwbDB_CreateCatalogRequestHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateConnectionHandle(systemName: LPCSTR; Var connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: LPCSTR; Var connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateConnectionHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,connection,errorHandle);
  Result:= cwbCheck(icwbDB_CreateConnectionHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateConnectionHandleEx(sysHandle: cwbCO_SysHandle; Var connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (sysHandle: cwbCO_SysHandle; Var connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateConnectionHandleEx, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(sysHandle,connection,errorHandle);
  Result:= cwbCheck(icwbDB_CreateConnectionHandleEx, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateDataFormatHandle(connection: cwbDB_ConnectionHandle; Var format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateDataFormatHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,format,errorHandle);
  Result:= cwbCheck(icwbDB_CreateDataFormatHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateDataHandle(Var dataHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var dataHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateDataHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(dataHandle,errorHandle);
  Result:= cwbCheck(icwbDB_CreateDataHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateDuplicateFile(request: cwbDB_RequestHandle; copyDataIndicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; copyDataIndicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateDuplicateFile, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,copyDataIndicator,errorHandle);
  Result:= cwbCheck(icwbDB_CreateDuplicateFile, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateNDBRequestHandle(connection: cwbDB_ConnectionHandle; Var request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateNDBRequestHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,request,errorHandle);
  Result:= cwbCheck(icwbDB_CreateNDBRequestHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreatePackage(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreatePackage, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_CreatePackage, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateParameterMarkerFormatHandle(connection: cwbDB_ConnectionHandle; Var format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateParameterMarkerFormatHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,format,errorHandle);
  Result:= cwbCheck(icwbDB_CreateParameterMarkerFormatHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateSourcePhysicalFile(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateSourcePhysicalFile, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_CreateSourcePhysicalFile, Result, Handler, ReturnAddr)
End;

Function cwbDB_CreateSQLRequestHandle(connection: cwbDB_ConnectionHandle; Var request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_CreateSQLRequestHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,request,errorHandle);
  Result:= cwbCheck(icwbDB_CreateSQLRequestHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_DeleteCatalogRequestHandle(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DeleteCatalogRequestHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_DeleteCatalogRequestHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_DeleteConnectionHandle(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DeleteConnectionHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,errorHandle);
  Result:= cwbCheck(icwbDB_DeleteConnectionHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_DeleteDataFormatHandle(format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DeleteDataFormatHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,errorHandle);
  Result:= cwbCheck(icwbDB_DeleteDataFormatHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_DeleteDataHandle(dataHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (dataHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DeleteDataHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(dataHandle,errorHandle);
  Result:= cwbCheck(icwbDB_DeleteDataHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_DeleteFile(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DeleteFile, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_DeleteFile, Result, Handler, ReturnAddr)
End;

Function cwbDB_DeleteNDBRequestHandle(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DeleteNDBRequestHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_DeleteNDBRequestHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_DeletePackage(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DeletePackage, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_DeletePackage, Result, Handler, ReturnAddr)
End;

Function cwbDB_DeleteParameterMarkerFormatHandle(format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DeleteParameterMarkerFormatHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,errorHandle);
  Result:= cwbCheck(icwbDB_DeleteParameterMarkerFormatHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_DeleteSQLRequestHandle(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DeleteSQLRequestHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_DeleteSQLRequestHandle, Result, Handler, ReturnAddr)
End;

Function cwbDB_Describe(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_Describe, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_Describe, Result, Handler, ReturnAddr)
End;

Function cwbDB_DescribeParameterMarkers(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DescribeParameterMarkers, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_DescribeParameterMarkers, Result, Handler, ReturnAddr)
End;

Function cwbDB_DynamicStreamFetch(request: cwbDB_RequestHandle; statementText: PChar; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; statementText: PChar; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_DynamicStreamFetch, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,statementText,data,indicators,format,errorHandle);
  Result:= cwbCheck(icwbDB_DynamicStreamFetch, Result, Handler, ReturnAddr)
End;

Function cwbDB_EndStreamFetch(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_EndStreamFetch, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_EndStreamFetch, Result, Handler, ReturnAddr)
End;

Function cwbDB_Execute(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_Execute, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_Execute, Result, Handler, ReturnAddr)
End;

Function cwbDB_ExecuteImmediate(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ExecuteImmediate, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_ExecuteImmediate, Result, Handler, ReturnAddr)
End;

Function cwbDB_ExtendedDynamicStreamFetch(request: cwbDB_RequestHandle; libraryName: PChar; packageName: PChar; statementName: PChar; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; libraryName: PChar; packageName: PChar; statementName: PChar; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ExtendedDynamicStreamFetch, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,libraryName,packageName,statementName,data,indicators,format,errorHandle);
  Result:= cwbCheck(icwbDB_ExtendedDynamicStreamFetch, Result, Handler, ReturnAddr)
End;

Function cwbDB_Fetch(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_Fetch, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_Fetch, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetBaseColumnName(format: cwbDB_FormatHandle; columnPosition: Cardinal; columnHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; columnPosition: Cardinal; columnHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetBaseColumnName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnPosition,columnHandle,errorHandle);
  Result:= cwbCheck(icwbDB_GetBaseColumnName, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetBaseSchemaName(format: cwbDB_FormatHandle; columnPosition: Cardinal; schemaHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; columnPosition: Cardinal; schemaHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetBaseSchemaName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnPosition,schemaHandle,errorHandle);
  Result:= cwbCheck(icwbDB_GetBaseSchemaName, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetBaseTableName(format: cwbDB_FormatHandle; columnPosition: Cardinal; tableHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; columnPosition: Cardinal; tableHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetBaseTableName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnPosition,tableHandle,errorHandle);
  Result:= cwbCheck(icwbDB_GetBaseTableName, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetColumnCCSID(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataCCSID: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetColumnCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,columnPosition,dataCCSID,errorHandle);
  Result:= cwbCheck(icwbDB_GetColumnCCSID, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetColumnCount(format: cwbDB_FormatHandle; Var columnCount: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; Var columnCount: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetColumnCount, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnCount,errorHandle);
  Result:= cwbCheck(icwbDB_GetColumnCount, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetColumnLength(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataLength: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataLength: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetColumnLength, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,columnPosition,dataLength,errorHandle);
  Result:= cwbCheck(icwbDB_GetColumnLength, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetColumnName(format: cwbDB_FormatHandle; columnPosition: Cardinal; columnHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; columnPosition: Cardinal; columnHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetColumnName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnPosition,columnHandle,errorHandle);
  Result:= cwbCheck(icwbDB_GetColumnName, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetColumnPrecision(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataPrecision: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataPrecision: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetColumnPrecision, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,columnPosition,dataPrecision,errorHandle);
  Result:= cwbCheck(icwbDB_GetColumnPrecision, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetColumnScale(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataScale: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataScale: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetColumnScale, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,columnPosition,dataScale,errorHandle);
  Result:= cwbCheck(icwbDB_GetColumnScale, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetColumnType(format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataType: SmallInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; columnPosition: Cardinal; Var dataType: SmallInt; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetColumnType, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,columnPosition,dataType,errorHandle);
  Result:= cwbCheck(icwbDB_GetColumnType, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetCommitmentControl(connection: cwbDB_ConnectionHandle; Var commitmentLevel: Word;  errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var commitmentLevel: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetCommitmentControl, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,commitmentLevel,errorHandle);
  Result:= cwbCheck(icwbDB_GetCommitmentControl, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetConversionIndicator(format: cwbDB_FormatHandle; Var conversionIndicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; Var conversionIndicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetConversionIndicator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,conversionIndicator,errorHandle);
  Result:= cwbCheck(icwbDB_GetConversionIndicator, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetData(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetData, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_GetData, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetDataLength(dataHandle: cwbDB_DataHandle; Var dataLength: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (dataHandle: cwbDB_DataHandle; Var dataLength: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetDataLength, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(dataHandle,dataLength,errorHandle);
  Result:= cwbCheck(icwbDB_GetDataLength, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetDataPointer(dataHandle: cwbDB_DataHandle; Var data: Pointer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (dataHandle: cwbDB_DataHandle; Var data: Pointer; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetDataPointer, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(dataHandle,data,errorHandle);
  Result:= cwbCheck(icwbDB_GetDataPointer, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetDateFormat(connection: cwbDB_ConnectionHandle; Var dateFormat: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var dateFormat: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetDateFormat, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,dateFormat,errorHandle);
  Result:= cwbCheck(icwbDB_GetDateFormat, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetDateSeparator(connection: cwbDB_ConnectionHandle; Var dateSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var dateSeparator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetDateSeparator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,dateSeparator,errorHandle);
  Result:= cwbCheck(icwbDB_GetDateSeparator, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetDecimalSeparator(connection: cwbDB_ConnectionHandle; Var decimalSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var decimalSeparator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetDecimalSeparator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,decimalSeparator,errorHandle);
  Result:= cwbCheck(icwbDB_GetDecimalSeparator, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetExtendedColumnInfo(format: cwbDB_FormatHandle; columnPosition: Cardinal; Var columnInfo: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; columnPosition: Cardinal; Var columnInfo: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetExtendedColumnInfo, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnPosition,columnInfo,errorHandle);
  Result:= cwbCheck(icwbDB_GetExtendedColumnInfo, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetIgnoreDecimalDataError(connection: cwbDB_ConnectionHandle; Var ignoreDecimalError: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var ignoreDecimalError: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetIgnoreDecimalDataError, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,ignoreDecimalError,errorHandle);
  Result:= cwbCheck(icwbDB_GetIgnoreDecimalDataError, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetLabelName(format: cwbDB_FormatHandle; columnPosition: Cardinal; labelHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; columnPosition: Cardinal; labelHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetLabelName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnPosition,labelHandle,errorHandle);
  Result:= cwbCheck(icwbDB_GetLabelName, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetLOBLocator(format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var dataLocator: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var dataLocator: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetLOBLocator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,parameterPosition,dataLocator,errorHandle);
  Result:= cwbCheck(icwbDB_GetLOBLocator, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetLOBMaxSize(format: cwbDB_FormatHandle; columnPosition: Cardinal; Var maxSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; columnPosition: Cardinal; Var maxSize: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetLOBMaxSize, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnPosition,maxSize,errorHandle);
  Result:= cwbCheck(icwbDB_GetLOBMaxSize, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetNamingConvention(connection: cwbDB_ConnectionHandle; Var namingConvention: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var namingConvention: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetNamingConvention, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,namingConvention,errorHandle);
  Result:= cwbCheck(icwbDB_GetNamingConvention, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetParameterCCSID(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataCCSID: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetParameterCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,parameterPosition,dataCCSID,errorHandle);
  Result:= cwbCheck(icwbDB_GetParameterCCSID, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetParameterCount(format: cwbDB_FormatHandle; Var parameterCount: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; Var parameterCount: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetParameterCount, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,parameterCount,errorHandle);
  Result:= cwbCheck(icwbDB_GetParameterCount, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetParameterDirection(format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var columnDirection: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var columnDirection: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetParameterDirection, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,parameterPosition,columnDirection,errorHandle);
  Result:= cwbCheck(icwbDB_GetParameterDirection, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetParameterLength(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataLength: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataLength: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetParameterLength, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,parameterPosition,dataLength,errorHandle);
  Result:= cwbCheck(icwbDB_GetParameterLength, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetParameterName(format: cwbDB_FormatHandle; parameterPosition: Cardinal; parameterHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; parameterPosition: Cardinal; parameterHandle: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetParameterName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,parameterPosition,parameterHandle,errorHandle);
  Result:= cwbCheck(icwbDB_GetParameterName, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetParameterPrecision(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataPrecision: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataPrecision: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetParameterPrecision, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,parameterPosition,dataPrecision,errorHandle);
  Result:= cwbCheck(icwbDB_GetParameterPrecision, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetParameterScale(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataScale: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataScale: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetParameterScale, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,parameterPosition,dataScale,errorHandle);
  Result:= cwbCheck(icwbDB_GetParameterScale, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetParameterType(format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataType: SmallInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; parameterPosition: Cardinal; Var dataType: SmallInt; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetParameterType, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,parameterPosition,dataType,errorHandle);
  Result:= cwbCheck(icwbDB_GetParameterType, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetRelationalDBName(connection: cwbDB_ConnectionHandle; relationalDBName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; relationalDBName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetRelationalDBName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,relationalDBName,errorHandle);
  Result:= cwbCheck(icwbDB_GetRelationalDBName, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetRowSize(format: cwbDB_FormatHandle; location: Cardinal; Var rowSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; Var rowSize: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetRowSize, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,rowSize,errorHandle);
  Result:= cwbCheck(icwbDB_GetRowSize, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetServerFunctionalLevel(connection: cwbDB_ConnectionHandle; serverFunctionalLevel: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; serverFunctionalLevel: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetServerFunctionalLevel, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,serverFunctionalLevel,errorHandle);
  Result:= cwbCheck(icwbDB_GetServerFunctionalLevel, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetSizeOfInputParameters(format: cwbDB_FormatHandle; location: Cardinal; Var inputSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; Var inputSize: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetSizeOfInputParameters, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,inputSize,errorHandle);
  Result:= cwbCheck(icwbDB_GetSizeOfInputParameters, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetSizeOfOutputParameters(format: cwbDB_FormatHandle; location: Cardinal; Var outputSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; location: Cardinal; Var outputSize: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetSizeOfOutputParameters, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,location,outputSize,errorHandle);
  Result:= cwbCheck(icwbDB_GetSizeOfOutputParameters, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetSizeOfParameters(format: cwbDB_FormatHandle; Var Size: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; Var Size: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetSizeOfParameters, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,Size,errorHandle);
  Result:= cwbCheck(icwbDB_GetSizeOfParameters, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetTimeFormat(connection: cwbDB_ConnectionHandle; Var timeFormat: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var timeFormat: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetTimeFormat, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,timeFormat,errorHandle);
  Result:= cwbCheck(icwbDB_GetTimeFormat, Result, Handler, ReturnAddr)
End;

Function cwbDB_GetTimeSeparator(connection: cwbDB_ConnectionHandle; Var timeSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var timeSeparator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_GetTimeSeparator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,timeSeparator,errorHandle);
  Result:= cwbCheck(icwbDB_GetTimeSeparator, Result, Handler, ReturnAddr)
End;

Function cwbDB_IsParameterInput(format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var parameterIsInput: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var parameterIsInput: cwb_Boolean; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_IsParameterInput, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,parameterPosition,parameterIsInput,errorHandle);
  Result:= cwbCheck(icwbDB_IsParameterInput, Result, Handler, ReturnAddr)
End;

Function cwbDB_IsParameterInputOutput(format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var parameterIsInputOutput: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; parameterPosition: Cardinal; Var parameterIsInputOutput: cwb_Boolean; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_IsParameterInputOutput, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,parameterPosition,parameterIsInputOutput,errorHandle);
  Result:= cwbCheck(icwbDB_IsParameterInputOutput, Result, Handler, ReturnAddr)
End;

Function cwbDB_MoreStreamData(request: cwbDB_RequestHandle; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_MoreStreamData, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,data,indicators,format,errorHandle);
  Result:= cwbCheck(icwbDB_MoreStreamData, Result, Handler, ReturnAddr)
End;

Function cwbDB_Open(request: cwbDB_RequestHandle; openOptions: Byte; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; openOptions: Byte; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_Open, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,openOptions,errorHandle);
  Result:= cwbCheck(icwbDB_Open, Result, Handler, ReturnAddr)
End;

Function cwbDB_OpenDescribeFetch(request: cwbDB_RequestHandle; openOptions: Byte; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; openOptions: Byte; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_OpenDescribeFetch, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,openOptions,errorHandle);
  Result:= cwbCheck(icwbDB_OpenDescribeFetch, Result, Handler, ReturnAddr)
End;

Function cwbDB_OverrideFile(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_OverrideFile, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_OverrideFile, Result, Handler, ReturnAddr)
End;

Function cwbDB_Prepare(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_Prepare, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_Prepare, Result, Handler, ReturnAddr)
End;

Function cwbDB_PrepareDescribe(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_PrepareDescribe, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_PrepareDescribe, Result, Handler, ReturnAddr)
End;

Function cwbDB_PrepareDescribeOpenFetch(request: cwbDB_RequestHandle; openOptions: Byte; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; openOptions: Byte; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_PrepareDescribeOpenFetch, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,openOptions,errorHandle);
  Result:= cwbCheck(icwbDB_PrepareDescribeOpenFetch, Result, Handler, ReturnAddr)
End;

Function cwbDB_RemoveMember(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RemoveMember, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_RemoveMember, Result, Handler, ReturnAddr)
End;

Function cwbDB_RemoveOverride(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RemoveOverride, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_RemoveOverride, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveFieldInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveFieldInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveFieldInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveFileInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveFileInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveFileInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveForeignKeyInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveForeignKeyInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveForeignKeyInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveIndexInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveIndexInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveIndexInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveLibraryInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveLibraryInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveLibraryInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveLOBData(request: cwbDB_RequestHandle; data: cwbDB_DataHandle; locator: Cardinal; size: Cardinal; start: Cardinal; columnIndex: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; data: cwbDB_DataHandle; locator: Cardinal; size: Cardinal; start: Cardinal; columnIndex: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveLOBData, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,data,locator,size,start,columnIndex,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveLOBData, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveMemberInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveMemberInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveMemberInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrievePackageStatementInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrievePackageStatementInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrievePackageStatementInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrievePrimaryKeyInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrievePrimaryKeyInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrievePrimaryKeyInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveRDBInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveRDBInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveRDBInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveRecordFormatInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveRecordFormatInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveRecordFormatInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveSpecialColumnInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveSpecialColumnInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveSpecialColumnInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_RetrieveSQLPackageInformation(request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; retrieveInformation: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_RetrieveSQLPackageInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,retrieveInformation,errorHandle);
  Result:= cwbCheck(icwbDB_RetrieveSQLPackageInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_ReturnData(request: cwbDB_RequestHandle; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; data: cwbDB_DataHandle; indicators: cwbDB_DataHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ReturnData, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,data,indicators,format,errorHandle);
  Result:= cwbCheck(icwbDB_ReturnData, Result, Handler, ReturnAddr)
End;

Function cwbDB_ReturnDataFormat(request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ReturnDataFormat, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,format,errorHandle);
  Result:= cwbCheck(icwbDB_ReturnDataFormat, Result, Handler, ReturnAddr)
End;

Function cwbDB_ReturnExtendedDataFormat(request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ReturnExtendedDataFormat, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,format,errorHandle);
  Result:= cwbCheck(icwbDB_ReturnExtendedDataFormat, Result, Handler, ReturnAddr)
End;

Function cwbDB_ReturnHostErrorInfo(request: cwbDB_RequestHandle; Var hostErrorClass: Word; Var hostErrorCode: Integer; hostMsgID: cwbDB_DataHandle; firstLevelMessageText: cwbDB_DataHandle; secondLevelMessageText: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; Var hostErrorClass: Word; Var hostErrorCode: Integer; hostMsgID: cwbDB_DataHandle; firstLevelMessageText: cwbDB_DataHandle; secondLevelMessageText: cwbDB_DataHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ReturnHostErrorInfo, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,hostErrorClass,hostErrorCode,hostMsgID,firstLevelMessageText,secondLevelMessageText,errorHandle);
  Result:= cwbCheck(icwbDB_ReturnHostErrorInfo, Result, Handler, ReturnAddr)
End;

Function cwbDB_ReturnParameterMarkerFormat(request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ReturnParameterMarkerFormat, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,format,errorHandle);
  Result:= cwbCheck(icwbDB_ReturnParameterMarkerFormat, Result, Handler, ReturnAddr)
End;

Function cwbDB_ReturnSQLCA(request: cwbDB_RequestHandle; Var sqlca: cwbDB_SQLCA; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; Var sqlca: cwbDB_SQLCA; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_ReturnSQLCA, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,sqlca,errorHandle);
  Result:= cwbCheck(icwbDB_ReturnSQLCA, Result, Handler, ReturnAddr)
End;

Function cwbDB_Rollback(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_Rollback, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_Rollback, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetAddLibraryName(request: cwbDB_RequestHandle; addLibraryName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; addLibraryName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetAddLibraryName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,addLibraryName,errorHandle);
  Result:= cwbCheck(icwbDB_SetAddLibraryName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetAddLibraryPosition(request: cwbDB_RequestHandle; position: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; position: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetAddLibraryPosition, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,position,errorHandle);
  Result:= cwbCheck(icwbDB_SetAddLibraryPosition, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetAllowAddStatementToPackage(connection: cwbDB_ConnectionHandle; allowAdd: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; allowAdd: cwb_Boolean; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetAllowAddStatementToPackage, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,allowAdd,errorHandle);
  Result:= cwbCheck(icwbDB_SetAllowAddStatementToPackage, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetAmbiguousSelectOption(connection: cwbDB_ConnectionHandle; updateability: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; updateability: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetAmbiguousSelectOption, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,updateability,errorHandle);
  Result:= cwbCheck(icwbDB_SetAmbiguousSelectOption, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetAuthority(request: cwbDB_RequestHandle; authority: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; authority: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetAuthority, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,authority,errorHandle);
  Result:= cwbCheck(icwbDB_SetAuthority, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetAutoCommit(connection: cwbDB_ConnectionHandle; autoCommit: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; autoCommit: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetAutoCommit, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,autoCommit,errorHandle);
  Result:= cwbCheck(icwbDB_SetAutoCommit, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetBaseFile(request: cwbDB_RequestHandle; baseLibraryName: PChar; baseFileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; baseLibraryName: PChar; baseFileName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetBaseFile, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,baseLibraryName,baseFileName,errorHandle);
  Result:= cwbCheck(icwbDB_SetBaseFile, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetBlockCount(request: cwbDB_RequestHandle; blockCount: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; blockCount: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetBlockCount, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,blockCount,errorHandle);
  Result:= cwbCheck(icwbDB_SetBlockCount, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetClientColumnToNumeric(format: cwbDB_FormatHandle; columnPosition: Cardinal; columnType: ShortInt; columnLength: Cardinal; columnPrecision: Word; columnScale: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; columnPosition: Cardinal; columnType: ShortInt; columnLength: Cardinal; columnPrecision: Word; columnScale: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetClientColumnToNumeric, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnPosition,columnType,columnLength,columnPrecision,columnScale,errorHandle);
  Result:= cwbCheck(icwbDB_SetClientColumnToNumeric, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetClientColumnToString(format: cwbDB_FormatHandle; columnPosition: Cardinal; columnType: ShortInt; columnLength: Cardinal; columnCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; columnPosition: Cardinal; columnType: ShortInt; columnLength: Cardinal; columnCCSID: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetClientColumnToString, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,columnPosition,columnType,columnLength,columnCCSID,errorHandle);
  Result:= cwbCheck(icwbDB_SetClientColumnToString, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetClientDataCCSID(connection: cwbDB_ConnectionHandle; clientDataCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; clientDataCCSID: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetClientDataCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,clientDataCCSID,errorHandle);
  Result:= cwbCheck(icwbDB_SetClientDataCCSID, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetClientHostErrorCCSID(connection: cwbDB_ConnectionHandle; clientHostErrorCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; clientHostErrorCCSID: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetClientHostErrorCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,clientHostErrorCCSID,errorHandle);
  Result:= cwbCheck(icwbDB_SetClientHostErrorCCSID, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetClientInputCCSID(connection: cwbDB_ConnectionHandle; inputCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; inputCCSID: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetClientInputCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,inputCCSID,errorHandle);
  Result:= cwbCheck(icwbDB_SetClientInputCCSID, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetClientParameterToNumeric(format: cwbDB_FormatHandle; parameterPosition: Cardinal; parameterType: ShortInt; parameterLength: Cardinal; parameterPrecision: Word; parameterScale: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; parameterPosition: Cardinal; parameterType: ShortInt; parameterLength: Cardinal; parameterPrecision: Word; parameterScale: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetClientParameterToNumeric, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,parameterPosition,parameterType,parameterLength,parameterPrecision,parameterScale,errorHandle);
  Result:= cwbCheck(icwbDB_SetClientParameterToNumeric, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetClientParameterToString(format: cwbDB_FormatHandle; parameterPosition: Cardinal; parameterType: ShortInt; parameterLength: Cardinal; parameterCCSID: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; parameterPosition: Cardinal; parameterType: ShortInt; parameterLength: Cardinal; parameterCCSID: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetClientParameterToString, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,parameterPosition,parameterType,parameterLength,parameterCCSID,errorHandle);
  Result:= cwbCheck(icwbDB_SetClientParameterToString, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetCommitmentControl(connection: cwbDB_ConnectionHandle; commitmentLevel: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; commitmentLevel: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetCommitmentControl, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,commitmentLevel,errorHandle);
  Result:= cwbCheck(icwbDB_SetCommitmentControl, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetConversionIndicator(format: cwbDB_FormatHandle; conversionIndicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (format: cwbDB_FormatHandle; conversionIndicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetConversionIndicator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(format,conversionIndicator,errorHandle);
  Result:= cwbCheck(icwbDB_SetConversionIndicator, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetConvert65535(connection: cwbDB_ConnectionHandle; convert65535indicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; convert65535indicator: cwb_Boolean; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetConvert65535, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,convert65535indicator,errorHandle);
  Result:= cwbCheck(icwbDB_SetConvert65535, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetCursorName(request: cwbDB_RequestHandle; cursorName: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; cursorName: LPCSTR; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetCursorName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,cursorName,errorHandle);
  Result:= cwbCheck(icwbDB_SetCursorName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetCursorReuse(request: cwbDB_RequestHandle; reuseIndicator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; reuseIndicator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetCursorReuse, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,reuseIndicator,errorHandle);
  Result:= cwbCheck(icwbDB_SetCursorReuse, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetDateFormat(connection: cwbDB_ConnectionHandle; dateFormat: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; dateFormat: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetDateFormat, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,dateFormat,errorHandle);
  Result:= cwbCheck(icwbDB_SetDateFormat, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetDateSeparator(connection: cwbDB_ConnectionHandle; dateSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; dateSeparator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetDateSeparator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,dateSeparator,errorHandle);
  Result:= cwbCheck(icwbDB_SetDateSeparator, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetDecimalSeparator(connection: cwbDB_ConnectionHandle; decimalSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; decimalSeparator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetDecimalSeparator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,decimalSeparator,errorHandle);
  Result:= cwbCheck(icwbDB_SetDecimalSeparator, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetDefaultSQLLibraryName(connection: cwbDB_ConnectionHandle; libraryName: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; libraryName: LPCSTR; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetDefaultSQLLibraryName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,libraryName,errorHandle);
  Result:= cwbCheck(icwbDB_SetDefaultSQLLibraryName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetDescribeOption(request: cwbDB_RequestHandle; describeOption: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; describeOption: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetDescribeOption, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,describeOption,errorHandle);
  Result:= cwbCheck(icwbDB_SetDescribeOption, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetExtendedDataFormat(request: cwbDB_RequestHandle; extendedFormatIndicator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; extendedFormatIndicator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetExtendedDataFormat, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,extendedFormatIndicator,errorHandle);
  Result:= cwbCheck(icwbDB_SetExtendedDataFormat, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetFetchScrollOptions(request: cwbDB_RequestHandle; scrollType: Word; relativeDistance: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; scrollType: Word; relativeDistance: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetFetchScrollOptions, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,scrollType,relativeDistance,errorHandle);
  Result:= cwbCheck(icwbDB_SetFetchScrollOptions, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetFieldName(request: cwbDB_RequestHandle; fieldName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; fieldName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetFieldName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,fieldName,errorHandle);
  Result:= cwbCheck(icwbDB_SetFieldName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetFileAttributes(request: cwbDB_RequestHandle; fileAttributes: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; fileAttributes: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetFileAttributes, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,fileAttributes,errorHandle);
  Result:= cwbCheck(icwbDB_SetFileAttributes, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetFileInfoOrdering(request: cwbDB_RequestHandle; fileInfoOrder: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; fileInfoOrder: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetFileInfoOrdering, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,fileInfoOrder,errorHandle);
  Result:= cwbCheck(icwbDB_SetFileInfoOrdering, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetFileName(request: cwbDB_RequestHandle; fileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; fileName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetFileName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,fileName,errorHandle);
  Result:= cwbCheck(icwbDB_SetFileName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetFileText(request: cwbDB_RequestHandle; fileText: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; fileText: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetFileText, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,fileText,errorHandle);
  Result:= cwbCheck(icwbDB_SetFileText, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetFileType(request: cwbDB_RequestHandle; fileType: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; fileType: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetFileType, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,fileType,errorHandle);
  Result:= cwbCheck(icwbDB_SetFileType, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetForeignKeyFileName(request: cwbDB_RequestHandle; fileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; fileName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetForeignKeyFileName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,fileName,errorHandle);
  Result:= cwbCheck(icwbDB_SetForeignKeyFileName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetForeignKeyLibName(request: cwbDB_RequestHandle; libName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; libName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetForeignKeyLibName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,libName,errorHandle);
  Result:= cwbCheck(icwbDB_SetForeignKeyLibName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetFormatName(request: cwbDB_RequestHandle; formatName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; formatName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetFormatName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,formatName,errorHandle);
  Result:= cwbCheck(icwbDB_SetFormatName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetHoldIndicator(request: cwbDB_RequestHandle; holdIndicator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; holdIndicator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetHoldIndicator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,holdIndicator,errorHandle);
  Result:= cwbCheck(icwbDB_SetHoldIndicator, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetIgnoreDecimalDataError(connection: cwbDB_ConnectionHandle; ignoreDecimalError: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; ignoreDecimalError: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetIgnoreDecimalDataError, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,ignoreDecimalError,errorHandle);
  Result:= cwbCheck(icwbDB_SetIgnoreDecimalDataError, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetIndexType(request: cwbDB_RequestHandle; indexType: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; indexType: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetIndexType, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,indexType,errorHandle);
  Result:= cwbCheck(icwbDB_SetIndexType, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetLibraryName(request: cwbDB_RequestHandle; libraryName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; libraryName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetLibraryName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,libraryName,errorHandle);
  Result:= cwbCheck(icwbDB_SetLibraryName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetLOBFieldThreshold(connection: cwbDB_ConnectionHandle; thresholdSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; thresholdSize: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetLOBFieldThreshold, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,thresholdSize,errorHandle);
  Result:= cwbCheck(icwbDB_SetLOBFieldThreshold, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetLongFileName(request: cwbDB_RequestHandle; longFileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; longFileName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetLongFileName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,longFileName,errorHandle);
  Result:= cwbCheck(icwbDB_SetLongFileName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetMaximumMembers(request: cwbDB_RequestHandle; maxMembers: ShortInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; maxMembers: ShortInt; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetMaximumMembers, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,maxMembers,errorHandle);
  Result:= cwbCheck(icwbDB_SetMaximumMembers, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetMemberName(request: cwbDB_RequestHandle; memberName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; memberName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetMemberName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,memberName,errorHandle);
  Result:= cwbCheck(icwbDB_SetMemberName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetMemberText(request: cwbDB_RequestHandle; memberText: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; memberText: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetMemberText, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,memberText,errorHandle);
  Result:= cwbCheck(icwbDB_SetMemberText, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetNamingConvention(connection: cwbDB_ConnectionHandle; newNamingConvention: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; newNamingConvention: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetNamingConvention, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,newNamingConvention,errorHandle);
  Result:= cwbCheck(icwbDB_SetNamingConvention, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetNLSS(connection: cwbDB_ConnectionHandle; NLSSTypeID: Word; tableOrLangID: PChar; lib: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; NLSSTypeID: Word; tableOrLangID: PChar; lib: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetNLSS, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,NLSSTypeID,tableOrLangID,lib,errorHandle);
  Result:= cwbCheck(icwbDB_SetNLSS, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetNullable(request: cwbDB_RequestHandle; nullableInd: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; nullableInd: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetNullable, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,nullableInd,errorHandle);
  Result:= cwbCheck(icwbDB_SetNullable, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetOverrideInformation(request: cwbDB_RequestHandle; overrideLibraryName: PChar; overrideFileName: PChar; overrideMemberName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; overrideLibraryName: PChar; overrideFileName: PChar; overrideMemberName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetOverrideInformation, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,overrideLibraryName,overrideFileName,overrideMemberName,errorHandle);
  Result:= cwbCheck(icwbDB_SetOverrideInformation, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetPackageName(request: cwbDB_RequestHandle; packageName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; packageName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetPackageName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,packageName,errorHandle);
  Result:= cwbCheck(icwbDB_SetPackageName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetParameterMarkerBlock(request: cwbDB_RequestHandle; numberOfRows: Cardinal; format: cwbDB_FormatHandle; dataPointer: Pointer; indicators: PShortInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; numberOfRows: Cardinal; format: cwbDB_FormatHandle; dataPointer: Pointer; indicators: PShortInt; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetParameterMarkerBlock, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,numberOfRows,format,dataPointer,indicators,errorHandle);
  Result:= cwbCheck(icwbDB_SetParameterMarkerBlock, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetParameterMarkers(request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; dataBuffer: Pointer; indicators: PSmallInt; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; format: cwbDB_FormatHandle; dataBuffer: Pointer; indicators: PSmallInt; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetParameterMarkers, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,format,dataBuffer,indicators,errorHandle);
  Result:= cwbCheck(icwbDB_SetParameterMarkers, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetPatternMatching(request: cwbDB_RequestHandle; objectType: Word; patternMatch: cwb_Boolean; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; objectType: Word; patternMatch: cwb_Boolean; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetPatternMatching, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,objectType,patternMatch,errorHandle);
  Result:= cwbCheck(icwbDB_SetPatternMatching, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetPrepareOption(request: cwbDB_RequestHandle; prepareOption: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; prepareOption: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetPrepareOption, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,prepareOption,errorHandle);
  Result:= cwbCheck(icwbDB_SetPrepareOption, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetPrimaryKeyFileName(request: cwbDB_RequestHandle; fileName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; fileName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetPrimaryKeyFileName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,fileName,errorHandle);
  Result:= cwbCheck(icwbDB_SetPrimaryKeyFileName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetPrimaryKeyLibName(request: cwbDB_RequestHandle; libName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; libName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetPrimaryKeyLibName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,libName,errorHandle);
  Result:= cwbCheck(icwbDB_SetPrimaryKeyLibName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetQueryTimeoutValue(request: cwbDB_RequestHandle; timeout: Integer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; timeout: Integer; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetQueryTimeoutValue, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,timeout,errorHandle);
  Result:= cwbCheck(icwbDB_SetQueryTimeoutValue, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetRDBName(request: cwbDB_RequestHandle; RDBName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; RDBName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetRDBName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,RDBName,errorHandle);
  Result:= cwbCheck(icwbDB_SetRDBName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetRecordLength(request: cwbDB_RequestHandle; recordLength: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; recordLength: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetRecordLength, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,recordLength,errorHandle);
  Result:= cwbCheck(icwbDB_SetRecordLength, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetRelationalDBName(connection: cwbDB_ConnectionHandle; relationalDBName: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; relationalDBName: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetRelationalDBName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,relationalDBName,errorHandle);
  Result:= cwbCheck(icwbDB_SetRelationalDBName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetScrollableCursor(request: cwbDB_RequestHandle; scrollIndicator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; scrollIndicator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetScrollableCursor, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,scrollIndicator,errorHandle);
  Result:= cwbCheck(icwbDB_SetScrollableCursor, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetStatementName(request: cwbDB_RequestHandle; statementName: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; statementName: LPCSTR; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetStatementName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,statementName,errorHandle);
  Result:= cwbCheck(icwbDB_SetStatementName, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetStatementText(request: cwbDB_RequestHandle; statementText: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; statementText: LPCSTR; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetStatementText, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,statementText,errorHandle);
  Result:= cwbCheck(icwbDB_SetStatementText, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetStatementType(request: cwbDB_RequestHandle; statementType: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; statementType: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetStatementType, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,statementType,errorHandle);
  Result:= cwbCheck(icwbDB_SetStatementType, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetStaticCursorResultSetThreshold(request: cwbDB_RequestHandle; thresholdSize: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; thresholdSize: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetStaticCursorResultSetThreshold, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,thresholdSize,errorHandle);
  Result:= cwbCheck(icwbDB_SetStaticCursorResultSetThreshold, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetStreamFetchSyncCount(request: cwbDB_RequestHandle; syncCount: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; syncCount: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetStreamFetchSyncCount, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,syncCount,errorHandle);
  Result:= cwbCheck(icwbDB_SetStreamFetchSyncCount, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetTimeFormat(connection: cwbDB_ConnectionHandle; timeFormat: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; timeFormat: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetTimeFormat, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,timeFormat,errorHandle);
  Result:= cwbCheck(icwbDB_SetTimeFormat, Result, Handler, ReturnAddr)
End;

Function cwbDB_SetTimeSeparator(connection: cwbDB_ConnectionHandle; timeSeparator: Word; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; timeSeparator: Word; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_SetTimeSeparator, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,timeSeparator,errorHandle);
  Result:= cwbCheck(icwbDB_SetTimeSeparator, Result, Handler, ReturnAddr)
End;

Function cwbDB_StartServer(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_StartServer, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,errorHandle);
  Result:= cwbCheck(icwbDB_StartServer, Result, Handler, ReturnAddr)
End;

Function cwbDB_StartServerDetailed(connection: cwbDB_ConnectionHandle; Var returnCode: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; Var returnCode: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_StartServerDetailed, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,returnCode,errorHandle);
  Result:= cwbCheck(icwbDB_StartServerDetailed, Result, Handler, ReturnAddr)
End;

Function cwbDB_StopServer(connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (connection: cwbDB_ConnectionHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_StopServer, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(connection,errorHandle);
  Result:= cwbCheck(icwbDB_StopServer, Result, Handler, ReturnAddr)
End;

Function cwbDB_StoreRequestParameters(request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_StoreRequestParameters, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,errorHandle);
  Result:= cwbCheck(icwbDB_StoreRequestParameters, Result, Handler, ReturnAddr)
End;

Function cwbDB_WriteLOBData(request: cwbDB_RequestHandle; dataPointer: Pointer; locator: Cardinal; ccsid: Word; size: Cardinal; start: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (request: cwbDB_RequestHandle; dataPointer: Pointer; locator: Cardinal; ccsid: Word; size: Cardinal; start: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbDB_WriteLOBData, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(request,dataPointer,locator,ccsid,size,start,errorHandle);
  Result:= cwbCheck(icwbDB_WriteLOBData, Result, Handler, ReturnAddr)
End;

Function cwbNL_CCSIDToCodePage(CCSID: Cardinal; Var codePage: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (CCSID: Cardinal; Var codePage: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbNL_CCSIDToCodePage, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(CCSID,codePage,errorHandle);
  Result:= cwbCheck(icwbNL_CCSIDToCodePage, Result, Handler, ReturnAddr)
End;

Function cwbNL_CodePageToCCSID(codePage: Cardinal; Var CCSID: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (codePage: Cardinal; Var CCSID: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbNL_CodePageToCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(codePage,CCSID,errorHandle);
  Result:= cwbCheck(icwbNL_CodePageToCCSID, Result, Handler, ReturnAddr)
End;

Function cwbNL_Convert(theConverter: cwbNL_Converter; sourceLength: Cardinal; targetLength: Cardinal; sourceBuffer: PChar; targetBuffer: PChar; Var numberOfErrors: Cardinal; Var firstErrorIndex: Cardinal; Var requiredLen: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (theConverter: cwbNL_Converter; sourceLength: Cardinal; targetLength: Cardinal; sourceBuffer: PChar; targetBuffer: PChar; Var numberOfErrors: Cardinal; Var firstErrorIndex: Cardinal; Var requiredLen: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbNL_Convert, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(theConverter,sourceLength,targetLength,sourceBuffer,targetBuffer,numberOfErrors,firstErrorIndex,requiredLen,errorHandle);
  Result:= cwbCheck(icwbNL_Convert, Result, Handler, ReturnAddr)
End;

Function cwbNL_ConvertCodePages(sourceCodePage: Cardinal; targetCodePage: Cardinal; sourceLength: Cardinal; targetLength: Cardinal; sourceBuffer: PChar; targetBuffer: PChar; Var numberOfErrors: Cardinal; Var firstErrorIndex: Cardinal; Var requiredLen: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (sourceCodePage: Cardinal; targetCodePage: Cardinal; sourceLength: Cardinal; targetLength: Cardinal; sourceBuffer: PChar; targetBuffer: PChar; Var numberOfErrors: Cardinal; Var firstErrorIndex: Cardinal; Var requiredLen: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbNL_ConvertCodePages, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(sourceCodePage,targetCodePage,sourceLength,targetLength,sourceBuffer,targetBuffer,numberOfErrors,firstErrorIndex,requiredLen,errorHandle);
  Result:= cwbCheck(icwbNL_ConvertCodePages, Result, Handler, ReturnAddr)
End;

Function cwbNL_CreateConverter(sourceCodePage: Cardinal; targetCodePage: Cardinal; Var theConverter: cwbNL_Converter; errorHandle: cwbSV_ErrHandle; shiftInShiftOutStatus: Cardinal; padLength: Cardinal; pad: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (sourceCodePage: Cardinal; targetCodePage: Cardinal; Var theConverter: cwbNL_Converter; errorHandle: cwbSV_ErrHandle; shiftInShiftOutStatus: Cardinal; padLength: Cardinal; pad: PChar): cwb_Result StdCall;
Begin If cwbInvalid(icwbNL_CreateConverter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(sourceCodePage,targetCodePage,theConverter,errorHandle,shiftInShiftOutStatus,padLength,pad);
  Result:= cwbCheck(icwbNL_CreateConverter, Result, Handler, ReturnAddr)
End;

Function cwbNL_DeleteConverter(theConverter: cwbNL_Converter; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (theConverter: cwbNL_Converter; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbNL_DeleteConverter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(theConverter,errorHandle);
  Result:= cwbCheck(icwbNL_DeleteConverter, Result, Handler, ReturnAddr)
End;

Function cwbNL_GetANSICodePage(Var codePage: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var codePage: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbNL_GetANSICodePage, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(codePage,errorHandle);
  Result:= cwbCheck(icwbNL_GetANSICodePage, Result, Handler, ReturnAddr)
End;

Function cwbNL_GetCodePage(Var codePage: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var codePage: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbNL_GetCodePage, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(codePage,errorHandle);
  Result:= cwbCheck(icwbNL_GetCodePage, Result, Handler, ReturnAddr)
End;

Function cwbNL_GetHostCCSID(system: PChar; Var CCSID: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: PChar; Var CCSID: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbNL_GetHostCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,CCSID);
  Result:= cwbCheck(icwbNL_GetHostCCSID, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_AnalyzeSplFData(data: PChar; bufLen: Cardinal; Var dataType: cwbOBJ_SplFDataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (data: PChar; bufLen: Cardinal; Var dataType: cwbOBJ_SplFDataType; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_AnalyzeSplFData, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(data,bufLen,dataType,errorHandle);
  Result:= cwbCheck(icwbOBJ_AnalyzeSplFData, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_AnswerSplFMsg(splFHandle: cwbOBJ_ObjHandle; msgAnswer: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; msgAnswer: LPCSTR; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_AnswerSplFMsg, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,msgAnswer,errorHandle);
  Result:= cwbCheck(icwbOBJ_AnswerSplFMsg, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CallExitPgmForSplF(splFHandle: cwbOBJ_ObjHandle; data: Pointer; dataLen: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; data: Pointer; dataLen: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CallExitPgmForSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,data,dataLen,errorHandle);
  Result:= cwbCheck(icwbOBJ_CallExitPgmForSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CloseList(listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CloseList, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CloseList, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CloseNewSplF(newsplFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (newsplFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CloseNewSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(newsplFHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CloseNewSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CloseNewSplFAndGetHandle(newsplFHandle: cwbOBJ_ObjHandle; Var splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (newsplFHandle: cwbOBJ_ObjHandle; Var splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CloseNewSplFAndGetHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(newsplFHandle,splFHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CloseNewSplFAndGetHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CloseResource(resourceHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (resourceHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CloseResource, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(resourceHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CloseResource, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CloseSplF(splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CloseSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CloseSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CopyObjHandle(objectHandle: cwbOBJ_ObjHandle; Var newObjectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbOBJ_ObjHandle; Var newObjectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CopyObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,newObjectHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CopyObjHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CopyParmObjHandle(parmListHandle: cwbOBJ_ObjHandle; Var newParmListHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (parmListHandle: cwbOBJ_ObjHandle; Var newParmListHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CopyParmObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(parmListHandle,newParmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CopyParmObjHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CreateListHandle(systemName: LPCSTR; Atype: cwbOBJ_ListType; Var listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: LPCSTR; Atype: cwbOBJ_ListType; Var listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CreateListHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,Atype,listHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CreateListHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CreateNewSplF(systemName: LPCSTR; parmListHandle: cwbOBJ_ObjHandle; Var printerFileHandle: cwbOBJ_ObjHandle; Var outputQueueHandle: cwbOBJ_ObjHandle; Var newSplFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: LPCSTR; parmListHandle: cwbOBJ_ObjHandle; Var printerFileHandle: cwbOBJ_ObjHandle; Var outputQueueHandle: cwbOBJ_ObjHandle; Var newSplFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CreateNewSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,parmListHandle,printerFileHandle,outputQueueHandle,newSplFHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CreateNewSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CreateParmObjHandle(Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CreateParmObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(parmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CreateParmObjHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CreateResourceHandle(systemName: LPCSTR; resourceName: LPCSTR; resourceLibrary: LPCSTR; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: LPCSTR; resourceName: LPCSTR; resourceLibrary: LPCSTR; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CreateResourceHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,resourceName,resourceLibrary,objectHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CreateResourceHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CreateSplFHandle(systemName: LPCSTR; jobName: LPCSTR; jobNumber: LPCSTR; jobUser: LPCSTR; splFName: LPCSTR; splFNumber: Cardinal; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: LPCSTR; jobName: LPCSTR; jobNumber: LPCSTR; jobUser: LPCSTR; splFName: LPCSTR; splFNumber: Cardinal; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CreateSplFHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,jobName,jobNumber,jobUser,splFName,splFNumber,objectHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CreateSplFHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_CreateSplFHandleEx(systemName: LPCSTR; jobName: LPCSTR; jobNumber: LPCSTR; jobUser: LPCSTR; splFName: LPCSTR; splFNumber: Cardinal; createdSystem: LPCSTR; createdDate: LPCSTR; createdTime: LPCSTR; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: LPCSTR; jobName: LPCSTR; jobNumber: LPCSTR; jobUser: LPCSTR; splFName: LPCSTR; splFNumber: Cardinal; createdSystem: LPCSTR; createdDate: LPCSTR; createdTime: LPCSTR; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_CreateSplFHandleEx, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,jobName,jobNumber,jobUser,splFName,splFNumber,createdSystem,createdDate,createdTime,objectHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_CreateSplFHandleEx, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_DeleteListHandle(listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_DeleteListHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_DeleteListHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_DeleteObjHandle(objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_DeleteObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_DeleteObjHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_DeleteParmObjHandle(parmListHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (parmListHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_DeleteParmObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(parmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_DeleteParmObjHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_DeleteSplF(splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_DeleteSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_DeleteSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_DisplayResource(resourceHandle: cwbOBJ_ObjHandle; view: LPCSTR; flags: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (resourceHandle: cwbOBJ_ObjHandle; view: LPCSTR; flags: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_DisplayResource, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(resourceHandle,view,flags,errorHandle);
  Result:= cwbCheck(icwbOBJ_DisplayResource, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_DisplaySplF(splFHandle: cwbOBJ_ObjHandle; view: LPCSTR; flags: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; view: LPCSTR; flags: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_DisplaySplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,view,flags,errorHandle);
  Result:= cwbCheck(icwbOBJ_DisplaySplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_DropConnections(errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_DropConnections, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(errorHandle);
  Result:= cwbCheck(icwbOBJ_DropConnections, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_EndWriter(writerHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (writerHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_EndWriter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(writerHandle,parmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_EndWriter, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetListSize(listHandle: cwbOBJ_ListHandle; Var size: Integer; Var listStatus: cwbOBJ_List_Status; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; Var size: Integer; Var listStatus: cwbOBJ_List_Status; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetListSize, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,size,listStatus,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetListSize, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetNPServerAttr(systemName: LPCSTR; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: LPCSTR; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetNPServerAttr, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,key,buffer,bufLen,bytesNeeded,keyType,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetNPServerAttr, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetObjAttr(objectHandle: cwbOBJ_ObjHandle; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbOBJ_ObjHandle; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetObjAttr, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,key,buffer,bufLen,bytesNeeded,keyType,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetObjAttr, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetObjAttrs(objectHandle: cwbOBJ_ObjHandle; numAttrs: Cardinal; Var getAttrParms: cwbOBJ_GetObjAttrParms; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbOBJ_ObjHandle; numAttrs: Cardinal; Var getAttrParms: cwbOBJ_GetObjAttrParms; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetObjAttrs, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,numAttrs,getAttrParms,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetObjAttrs, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetObjHandle(listHandle: cwbOBJ_ListHandle; position: Cardinal; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; position: Cardinal; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,position,objectHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetObjHandle, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetObjHandleFromID(idBuffer: Pointer; bufLen: Cardinal; objectType: cwbOBJ_ObjType; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (idBuffer: Pointer; bufLen: Cardinal; objectType: cwbOBJ_ObjType; Var objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetObjHandleFromID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(idBuffer,bufLen,objectType,objectHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetObjHandleFromID, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetObjID(objectHandle: cwbOBJ_ObjHandle; idBuffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbOBJ_ObjHandle; idBuffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetObjID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,idBuffer,bufLen,bytesNeeded,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetObjID, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetParameter(parmListHandle: cwbOBJ_ParmHandle; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (parmListHandle: cwbOBJ_ParmHandle; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetParameter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(parmListHandle,key,buffer,bufLen,bytesNeeded,keyType,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetParameter, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetSplFHandleFromNewSplF(newSplFHandle: cwbOBJ_ObjHandle; Var splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (newSplFHandle: cwbOBJ_ObjHandle; Var splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetSplFHandleFromNewSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(newSplFHandle,splFHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetSplFHandleFromNewSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_GetSplFMsgAttr(splFHandle: cwbOBJ_ObjHandle; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; key: cwbOBJ_KeyID; buffer: Pointer; bufLen: Cardinal; Var bytesNeeded: Cardinal; Var keyType: cwbOBJ_DataType; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_GetSplFMsgAttr, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,key,buffer,bufLen,bytesNeeded,keyType,errorHandle);
  Result:= cwbCheck(icwbOBJ_GetSplFMsgAttr, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_HoldOutputQueue(queueHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (queueHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_HoldOutputQueue, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(queueHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_HoldOutputQueue, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_HoldSplF(splFHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_HoldSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,parmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_HoldSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_IsViewerAvailable(errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_IsViewerAvailable, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(errorHandle);
  Result:= cwbCheck(icwbOBJ_IsViewerAvailable, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_MoveSplF(splFHandle: cwbOBJ_ObjHandle; Var targetSplFHandle: cwbOBJ_ObjHandle; Var outputQueueHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; Var targetSplFHandle: cwbOBJ_ObjHandle; Var outputQueueHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_MoveSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,targetSplFHandle,outputQueueHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_MoveSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_OpenList(listHandle: cwbOBJ_ListHandle; openType: cwbOBJ_List_OpenType; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; openType: cwbOBJ_List_OpenType; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_OpenList, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,openType,errorHandle);
  Result:= cwbCheck(icwbOBJ_OpenList, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_OpenResource(resourceHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (resourceHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_OpenResource, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(resourceHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_OpenResource, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_OpenResourceForSplF(splFHandle: cwbOBJ_ObjHandle; resourceName: LPCSTR; resourceLibrary: LPCSTR; resourceType: Cardinal; reserved: LPCSTR; Var resourceHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; resourceName: LPCSTR; resourceLibrary: LPCSTR; resourceType: Cardinal; reserved: LPCSTR; Var resourceHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_OpenResourceForSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,resourceName,resourceLibrary,resourceType,reserved,resourceHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_OpenResourceForSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_OpenSplF(splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_OpenSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_OpenSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_OpenSplFEx(splFHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_OpenSplFEx, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,parmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_OpenSplFEx, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_PurgeOutputQueue(queueHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (queueHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_PurgeOutputQueue, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(queueHandle,parmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_PurgeOutputQueue, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_ReadResource(resourceHandle: cwbOBJ_ObjHandle; bBuffer: PChar; bytesToRead: Cardinal; Var bytesRead: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (resourceHandle: cwbOBJ_ObjHandle; bBuffer: PChar; bytesToRead: Cardinal; Var bytesRead: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_ReadResource, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(resourceHandle,bBuffer,bytesToRead,bytesRead,errorHandle);
  Result:= cwbCheck(icwbOBJ_ReadResource, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_ReadSplF(splFHandle: cwbOBJ_ObjHandle; Var bBuffer: PChar; bytesToRead: Cardinal; Var bytesRead: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; Var bBuffer: PChar; bytesToRead: Cardinal; Var bytesRead: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_ReadSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,bBuffer,bytesToRead,bytesRead,errorHandle);
  Result:= cwbCheck(icwbOBJ_ReadSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_RefreshObj(objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_RefreshObj, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_RefreshObj, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_ReleaseOutputQueue(queueHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (queueHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_ReleaseOutputQueue, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(queueHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_ReleaseOutputQueue, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_ReleaseSplF(splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_ReleaseSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_ReleaseSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_ResetListAttrsToRetrieve(listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_ResetListAttrsToRetrieve, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_ResetListAttrsToRetrieve, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_ResetListFilter(listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_ResetListFilter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_ResetListFilter, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SeekResource(resourceHandle: cwbOBJ_ListHandle; seekOrigin: cwbOBJ_SeekOrigin; seekOffset: Integer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (resourceHandle: cwbOBJ_ListHandle; seekOrigin: cwbOBJ_SeekOrigin; seekOffset: Integer; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SeekResource, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(resourceHandle,seekOrigin,seekOffset,errorHandle);
  Result:= cwbCheck(icwbOBJ_SeekResource, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SeekSplF(splFHandle: cwbOBJ_ListHandle; seekOrigin: cwbOBJ_SeekOrigin; seekOffset: Integer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ListHandle; seekOrigin: cwbOBJ_SeekOrigin; seekOffset: Integer; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SeekSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,seekOrigin,seekOffset,errorHandle);
  Result:= cwbCheck(icwbOBJ_SeekSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SendNetSplF(splFHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SendNetSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,parmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_SendNetSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SendTCPSplF(splFHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (splFHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SendTCPSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(splFHandle,parmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_SendTCPSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SetConnectionsToKeep(systemName: LPCSTR; connections: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: LPCSTR; connections: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SetConnectionsToKeep, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,connections,errorHandle);
  Result:= cwbCheck(icwbOBJ_SetConnectionsToKeep, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SetListAttrsToRetrieve(listHandle: cwbOBJ_ListHandle; numKeys: Cardinal; keys: Array Of cwbOBJ_KeyID; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; numKeys: Cardinal; keys: Array Of cwbOBJ_KeyID; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SetListAttrsToRetrieve, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,numKeys,keys,errorHandle);
  Result:= cwbCheck(icwbOBJ_SetListAttrsToRetrieve, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SetListFilter(listHandle: cwbOBJ_ListHandle; key: cwbOBJ_KeyID; Value: Pointer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; key: cwbOBJ_KeyID; Value: Pointer; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SetListFilter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,key,Value,errorHandle);
  Result:= cwbCheck(icwbOBJ_SetListFilter, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SetListFilterWithSplF(listHandle: cwbOBJ_ListHandle; splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbOBJ_ListHandle; splFHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SetListFilterWithSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,splFHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_SetListFilterWithSplF, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SetObjAttrs(objectHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbOBJ_ObjHandle; parmListHandle: cwbOBJ_ParmHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SetObjAttrs, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,parmListHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_SetObjAttrs, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_SetParameter(parmListHandle: cwbOBJ_ParmHandle; key: cwbOBJ_KeyID; Value: Pointer; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (parmListHandle: cwbOBJ_ParmHandle; key: cwbOBJ_KeyID; Value: Pointer; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_SetParameter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(parmListHandle,key,Value,errorHandle);
  Result:= cwbCheck(icwbOBJ_SetParameter, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_StartWriter(Var printerHandle: cwbOBJ_ObjHandle; Var outputQueueHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; Var writerHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var printerHandle: cwbOBJ_ObjHandle; Var outputQueueHandle: cwbOBJ_ObjHandle; Var parmListHandle: cwbOBJ_ParmHandle; Var writerHandle: cwbOBJ_ObjHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_StartWriter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(printerHandle,outputQueueHandle,parmListHandle,writerHandle,errorHandle);
  Result:= cwbCheck(icwbOBJ_StartWriter, Result, Handler, ReturnAddr)
End;

Function cwbOBJ_WriteNewSplF(newSplFHandle: cwbOBJ_ObjHandle; data: PChar; dataLen: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (newSplFHandle: cwbOBJ_ObjHandle; data: PChar; dataLen: Cardinal; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbOBJ_WriteNewSplF, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(newSplFHandle,data,dataLen,errorHandle);
  Result:= cwbCheck(icwbOBJ_WriteNewSplF, Result, Handler, ReturnAddr)
End;

Function cwbRC_AddParm(pgm: cwbRC_PgmHandle; ParamType: Word; length: Cardinal; Parameter: Pointer; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (pgm: cwbRC_PgmHandle; ParamType: Word; length: Cardinal; Parameter: Pointer): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_AddParm, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(pgm,ParamType,length,Parameter);
  Result:= cwbCheck(icwbRC_AddParm, Result, Handler, ReturnAddr)
End;

Function cwbRC_CallPgm(system: cwbRC_SysHandle; pgm: cwbRC_PgmHandle; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbRC_SysHandle; pgm: cwbRC_PgmHandle; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_CallPgm, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,pgm,errorHandle);
  Result:= cwbCheck(icwbRC_CallPgm, Result, Handler, ReturnAddr)
End;

Function cwbRC_CreatePgm(programName: PChar; libraryName: PChar; Var pgm: cwbRC_PgmHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (programName: PChar; libraryName: PChar; Var pgm: cwbRC_PgmHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_CreatePgm, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(programName,libraryName,pgm);
  Result:= cwbCheck(icwbRC_CreatePgm, Result, Handler, ReturnAddr)
End;

Function cwbRC_DeletePgm(pgm: cwbRC_PgmHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (pgm: cwbRC_PgmHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_DeletePgm, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(pgm);
  Result:= cwbCheck(icwbRC_DeletePgm, Result, Handler, ReturnAddr)
End;

Function cwbRC_GetClientCCSID(system: cwbRC_SysHandle; Var clientCCSID: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbRC_SysHandle; Var clientCCSID: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_GetClientCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,clientCCSID);
  Result:= cwbCheck(icwbRC_GetClientCCSID, Result, Handler, ReturnAddr)
End;

Function cwbRC_GetHostCCSID(system: cwbRC_SysHandle; Var hostCCSID: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbRC_SysHandle; Var hostCCSID: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_GetHostCCSID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,hostCCSID);
  Result:= cwbCheck(icwbRC_GetHostCCSID, Result, Handler, ReturnAddr)
End;

Function cwbRC_GetLibName(pgm: cwbRC_PgmHandle; libraryName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (pgm: cwbRC_PgmHandle; libraryName: PChar): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_GetLibName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(pgm,libraryName);
  Result:= cwbCheck(icwbRC_GetLibName, Result, Handler, ReturnAddr)
End;

Function cwbRC_GetParm(pgm: cwbRC_PgmHandle; index: Word; Var ParamType: Word; Var length: Cardinal; Var parameter: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (pgm: cwbRC_PgmHandle; index: Word; Var ParamType: Word; Var length: Cardinal; Var parameter: PChar): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_GetParm, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(pgm,index,ParamType,length,parameter);
  Result:= cwbCheck(icwbRC_GetParm, Result, Handler, ReturnAddr)
End;

Function cwbRC_GetParmCount(pgm: cwbRC_PgmHandle; Var Count: Word; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (pgm: cwbRC_PgmHandle; Var Count: Word): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_GetParmCount, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(pgm,Count);
  Result:= cwbCheck(icwbRC_GetParmCount, Result, Handler, ReturnAddr)
End;

Function cwbRC_GetPgmName(pgm: cwbRC_PgmHandle; programName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (pgm: cwbRC_PgmHandle; programName: PChar): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_GetPgmName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(pgm,programName);
  Result:= cwbCheck(icwbRC_GetPgmName, Result, Handler, ReturnAddr)
End;

Function cwbRC_GetSysName(system: cwbRC_SysHandle; systemName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbRC_SysHandle; systemName: PChar): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_GetSysName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,systemName);
  Result:= cwbCheck(icwbRC_GetSysName, Result, Handler, ReturnAddr)
End;

Function cwbRC_RunCmd(system: cwbRC_SysHandle; commandString: PChar; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbRC_SysHandle; commandString: PChar; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_RunCmd, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system,commandString,errorHandle);
  Result:= cwbCheck(icwbRC_RunCmd, Result, Handler, ReturnAddr)
End;

Function cwbRC_SetLibName(pgm: cwbRC_PgmHandle; libraryName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (pgm: cwbRC_PgmHandle; libraryName: PChar): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_SetLibName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(pgm,libraryName);
  Result:= cwbCheck(icwbRC_SetLibName, Result, Handler, ReturnAddr)
End;

Function cwbRC_SetParm(pgm: cwbRC_PgmHandle; index: Word; ParamType: Word; Length: Cardinal; parameter: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (pgm: cwbRC_PgmHandle; index: Word; ParamType: Word; Length: Cardinal; parameter: PChar): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_SetParm, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(pgm,index,ParamType,Length,parameter);
  Result:= cwbCheck(icwbRC_SetParm, Result, Handler, ReturnAddr)
End;

Function cwbRC_SetPgmName(pgm: cwbRC_PgmHandle; programName: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (pgm: cwbRC_PgmHandle; programName: PChar): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_SetPgmName, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(pgm,programName);
  Result:= cwbCheck(icwbRC_SetPgmName, Result, Handler, ReturnAddr)
End;

Function cwbRC_StartSys(systemName: PChar; appName: PChar; Var system: cwbRC_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemName: PChar; appName: PChar; Var system: cwbRC_SysHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_StartSys, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemName,appName,system);
  Result:= cwbCheck(icwbRC_StartSys, Result, Handler, ReturnAddr)
End;

Function cwbRC_StartSysEx(systemObj: cwbCO_SysHandle; Var system: cwbRC_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemObj: cwbCO_SysHandle; Var system: cwbRC_SysHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_StartSysEx, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemObj,system);
  Result:= cwbCheck(icwbRC_StartSysEx, Result, Handler, ReturnAddr)
End;

Function cwbRC_StopSys(system: cwbRC_SysHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (system: cwbRC_SysHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbRC_StopSys, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(system);
  Result:= cwbCheck(icwbRC_StopSys, Result, Handler, ReturnAddr)
End;

Function CWBSO_CloseList(listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_CloseList, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,errorHandle);
  Result:= cwbCheck(iCWBSO_CloseList, Result, Handler, ReturnAddr)
End;

Function CWBSO_CopyObjHandle(objectHandle: cwbSO_ObjHandle; Var newObjectHandle: cwbSO_ObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbSO_ObjHandle; Var newObjectHandle: cwbSO_ObjHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_CopyObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,newObjectHandle);
  Result:= cwbCheck(iCWBSO_CopyObjHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_CreateErrorHandle(Var ErrorHandle: cwbSO_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var ErrorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_CreateErrorHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(ErrorHandle);
  Result:= cwbCheck(iCWBSO_CreateErrorHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_CreateListHandle(szSystemName: PChar; szApplicationName: PChar; listtype: CWBSO_LISTTYPE; Var listHandle: cwbSO_ListHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (szSystemName: PChar; szApplicationName: PChar; listtype: CWBSO_LISTTYPE; Var listHandle: cwbSO_ListHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_CreateListHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(szSystemName,szApplicationName,listtype,listHandle);
  Result:= cwbCheck(iCWBSO_CreateListHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_CreateListHandleEx(systemObjectHandle: cwbCO_SysHandle; listType: CWBSO_LISTTYPE; Var listHandle: cwbSO_ListHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (systemObjectHandle: cwbCO_SysHandle; listType: CWBSO_LISTTYPE; Var listHandle: cwbSO_ListHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_CreateListHandleEx, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(systemObjectHandle,listType,listHandle);
  Result:= cwbCheck(iCWBSO_CreateListHandleEx, Result, Handler, ReturnAddr)
End;

Function CWBSO_CreateObjHandle(szSystemName: PChar; szApplicationName: PChar; objtype: CWBSO_OBJTYPE; Var objHandle: cwbSO_ObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (szSystemName: PChar; szApplicationName: PChar; objtype: CWBSO_OBJTYPE; Var objHandle: cwbSO_ObjHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_CreateObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(szSystemName,szApplicationName,objtype,objHandle);
  Result:= cwbCheck(iCWBSO_CreateObjHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_CreateParmObjHandle(Var parmObjHandle: cwbSO_ParmObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var parmObjHandle: cwbSO_ParmObjHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_CreateParmObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(parmObjHandle);
  Result:= cwbCheck(iCWBSO_CreateParmObjHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_DeleteErrorHandle(errorHandle: cwbSO_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DeleteErrorHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(errorHandle);
  Result:= cwbCheck(iCWBSO_DeleteErrorHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_DeleteListHandle(listHandle: cwbSO_ListHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DeleteListHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle);
  Result:= cwbCheck(iCWBSO_DeleteListHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_DeleteObjHandle(objectHandle: cwbSO_ObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbSO_ObjHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DeleteObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle);
  Result:= cwbCheck(iCWBSO_DeleteObjHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_DeleteParmObjHandle(parmObjHandle: cwbSO_ParmObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (parmObjHandle: cwbSO_ParmObjHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DeleteParmObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(parmObjHandle);
  Result:= cwbCheck(iCWBSO_DeleteParmObjHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_DisallowListActions(listHandle: cwbSO_ListHandle; Var usActionIDs: Word; Count: Word; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; Var usActionIDs: Word; Count: Word): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DisallowListActions, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,usActionIDs,Count);
  Result:= cwbCheck(iCWBSO_DisallowListActions, Result, Handler, ReturnAddr)
End;

Function CWBSO_DisallowListFilter(listHandle: cwbSO_ListHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DisallowListFilter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle);
  Result:= cwbCheck(iCWBSO_DisallowListFilter, Result, Handler, ReturnAddr)
End;

Function CWBSO_DisplayErrMsg(errorHandle: cwbSO_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DisplayErrMsg, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(errorHandle);
  Result:= cwbCheck(iCWBSO_DisplayErrMsg, Result, Handler, ReturnAddr)
End;

Function CWBSO_DisplayList(listHandle: cwbSO_ListHandle; Instance: THandle; cmdShow: Integer; Var hWnd: THandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; Instance: THandle; cmdShow: Integer; Var hWnd: THandle; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DisplayList, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,Instance,cmdShow,hWnd,errorHandle);
  Result:= cwbCheck(iCWBSO_DisplayList, Result, Handler, ReturnAddr)
End;

Function CWBSO_DisplayObjAttr(objectHandle: cwbSO_ObjHandle; Instance: THandle; cmdShow: Integer; Var hWnd: THandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbSO_ObjHandle; Instance: THandle; cmdShow: Integer; Var hWnd: THandle; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DisplayObjAttr, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,Instance,cmdShow,hWnd,errorHandle);
  Result:= cwbCheck(iCWBSO_DisplayObjAttr, Result, Handler, ReturnAddr)
End;

Function CWBSO_DisplaySplf(objectHandle: cwbSO_ObjHandle; View: PChar; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbSO_ObjHandle; View: PChar; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_DisplaySplf, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,View,errorHandle);
  Result:= cwbCheck(iCWBSO_DisplaySplf, Result, Handler, ReturnAddr)
End;

Function CWBSO_GetErrMsgText(errorHandle: cwbSO_ErrHandle; msgBuffer: PChar; bufferLength: Cardinal; Var bytesNeeded: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (errorHandle: cwbSO_ErrHandle; msgBuffer: PChar; bufferLength: Cardinal; Var bytesNeeded: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_GetErrMsgText, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(errorHandle,msgBuffer,bufferLength,bytesNeeded);
  Result:= cwbCheck(iCWBSO_GetErrMsgText, Result, Handler, ReturnAddr)
End;

Function CWBSO_GetListSize(listHandle: cwbSO_ListHandle; Var Size: Integer; Var Status: Word; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; Var Size: Integer; Var Status: Word; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_GetListSize, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,Size,Status,errorHandle);
  Result:= cwbCheck(iCWBSO_GetListSize, Result, Handler, ReturnAddr)
End;

Function CWBSO_GetObjAttr(objectHandle: cwbSO_ObjHandle; AttributeID: Word; Buffer: PChar; bufferLength: Cardinal; Var bytesNeeded: Cardinal; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbSO_ObjHandle; AttributeID: Word; Buffer: PChar; bufferLength: Cardinal; Var bytesNeeded: Cardinal; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_GetObjAttr, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,AttributeID,Buffer,bufferLength,bytesNeeded,errorHandle);
  Result:= cwbCheck(iCWBSO_GetObjAttr, Result, Handler, ReturnAddr)
End;

Function CWBSO_GetObjHandle(listHandle: cwbSO_ListHandle; position: Cardinal; Var objectHandle: cwbSO_ObjHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; position: Cardinal; Var objectHandle: cwbSO_ObjHandle; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_GetObjHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,position,objectHandle,errorHandle);
  Result:= cwbCheck(iCWBSO_GetObjHandle, Result, Handler, ReturnAddr)
End;

Function CWBSO_OpenList(listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_OpenList, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,errorHandle);
  Result:= cwbCheck(iCWBSO_OpenList, Result, Handler, ReturnAddr)
End;

Function CWBSO_ReadListProfile(listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_ReadListProfile, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,errorHandle);
  Result:= cwbCheck(iCWBSO_ReadListProfile, Result, Handler, ReturnAddr)
End;

Function CWBSO_RefreshObj(objectHandle: cwbSO_ObjHandle; Wnd: HWND; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbSO_ObjHandle; Wnd: HWND; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_RefreshObj, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,Wnd,errorHandle);
  Result:= cwbCheck(iCWBSO_RefreshObj, Result, Handler, ReturnAddr)
End;

Function CWBSO_ResetParmObj(parmObjHandle: cwbSO_ParmObjHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (parmObjHandle: cwbSO_ParmObjHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_ResetParmObj, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(parmObjHandle);
  Result:= cwbCheck(iCWBSO_ResetParmObj, Result, Handler, ReturnAddr)
End;

Function CWBSO_SetListFilter(listHandle: cwbSO_ListHandle; FilterID: Word; Value: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; FilterID: Word; Value: PChar): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_SetListFilter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,FilterID,Value);
  Result:= cwbCheck(iCWBSO_SetListFilter, Result, Handler, ReturnAddr)
End;

Function CWBSO_SetListProfile(listHandle: cwbSO_ListHandle; FilterID: Word; Key: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; FilterID: Word; Key: PChar): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_SetListProfile, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,FilterID,Key);
  Result:= cwbCheck(iCWBSO_SetListProfile, Result, Handler, ReturnAddr)
End;

Function CWBSO_SetListSortFields(listHandle: cwbSO_ListHandle; SortIDs: PChar; Count: Word; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; SortIDs: PChar; Count: Word): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_SetListSortFields, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,SortIDs,Count);
  Result:= cwbCheck(iCWBSO_SetListSortFields, Result, Handler, ReturnAddr)
End;

Function CWBSO_SetListTitle(listHandle: cwbSO_ListHandle; Title: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; Title: PChar): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_SetListTitle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,Title);
  Result:= cwbCheck(iCWBSO_SetListTitle, Result, Handler, ReturnAddr)
End;

Function CWBSO_SetObjAttr(objectHandle: cwbSO_ObjHandle; parmObjHandle: cwbSO_ParmObjHandle; Var errorIndex: Word; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (objectHandle: cwbSO_ObjHandle; parmObjHandle: cwbSO_ParmObjHandle; Var errorIndex: Word; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_SetObjAttr, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(objectHandle,parmObjHandle,errorIndex,errorHandle);
  Result:= cwbCheck(iCWBSO_SetObjAttr, Result, Handler, ReturnAddr)
End;

Function CWBSO_SetParameter(parmObjHandle: cwbSO_ParmObjHandle; AttributeID: Word; Value: PChar; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (parmObjHandle: cwbSO_ParmObjHandle; AttributeID: Word; Value: PChar; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_SetParameter, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(parmObjHandle,AttributeID,Value,errorHandle);
  Result:= cwbCheck(iCWBSO_SetParameter, Result, Handler, ReturnAddr)
End;

Function CWBSO_WaitForObj(listHandle: cwbSO_ListHandle; Position: Cardinal; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; Position: Cardinal; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_WaitForObj, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,Position,errorHandle);
  Result:= cwbCheck(iCWBSO_WaitForObj, Result, Handler, ReturnAddr)
End;

Function CWBSO_WriteListProfile(listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (listHandle: cwbSO_ListHandle; errorHandle: cwbSO_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(iCWBSO_WriteListProfile, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(listHandle,errorHandle);
  Result:= cwbCheck(iCWBSO_WriteListProfile, Result, Handler, ReturnAddr)
End;

Function cwbSV_CreateErrHandle(Var errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbSV_CreateErrHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(errorHandle);
  Result:= cwbCheck(icwbSV_CreateErrHandle, Result, Handler, ReturnAddr)
End;

Function cwbSV_DeleteErrHandle(errorHandle: cwbSV_ErrHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbSV_DeleteErrHandle, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(errorHandle);
  Result:= cwbCheck(icwbSV_DeleteErrHandle, Result, Handler, ReturnAddr)
End;

Function cwbSV_GetErrCount(errorHandle: cwbSV_ErrHandle; Var count: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (errorHandle: cwbSV_ErrHandle; Var count: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbSV_GetErrCount, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(errorHandle,count);
  Result:= cwbCheck(icwbSV_GetErrCount, Result, Handler, ReturnAddr)
End;

Function cwbSV_GetErrTextIndexed(errorHandle: cwbSV_ErrHandle; index: Cardinal; messageText: pChar; messageTextLength: Cardinal; Var returnlength: Cardinal; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (errorHandle: cwbSV_ErrHandle; index: Cardinal; messageText: pChar; messageTextLength: Cardinal; Var returnlength: Cardinal): cwb_Result StdCall;
Begin If cwbInvalid(icwbSV_GetErrTextIndexed, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(errorHandle,index,messageText,messageTextLength,returnlength);
  Result:= cwbCheck(icwbSV_GetErrTextIndexed, Result, Handler, ReturnAddr)
End;

Function cwbSY_CreateSecurityObj(Var securityHandle: cwbSY_SecurityHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (Var securityHandle: cwbSY_SecurityHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbSY_CreateSecurityObj, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(securityHandle);
  Result:= cwbCheck(icwbSY_CreateSecurityObj, Result, Handler, ReturnAddr)
End;

Function cwbSY_DeleteSecurityObj(securityHandle: cwbSY_SecurityHandle; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (securityHandle: cwbSY_SecurityHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbSY_DeleteSecurityObj, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(securityHandle);
  Result:= cwbCheck(icwbSY_DeleteSecurityObj, Result, Handler, ReturnAddr)
End;

Function cwbSY_GetUserID(securityHandle: cwbSY_SecurityHandle; systemName: PChar; userID: PChar; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (securityHandle: cwbSY_SecurityHandle; systemName: PChar; userID: PChar): cwb_Result StdCall;
Begin If cwbInvalid(icwbSY_GetUserID, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(securityHandle,systemName,userID);
  Result:= cwbCheck(icwbSY_GetUserID, Result, Handler, ReturnAddr)
End;

Function cwbSY_LogonUser(securityHandle: cwbSY_SecurityHandle; userID: LPCSTR; password: LPCSTR; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (securityHandle: cwbSY_SecurityHandle; userID: LPCSTR; password: LPCSTR; errorHandle: cwbSV_ErrHandle): cwb_Result StdCall;
Begin If cwbInvalid(icwbSY_LogonUser, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(securityHandle,userID,password,errorHandle);
  Result:= cwbCheck(icwbSY_LogonUser, Result, Handler, ReturnAddr)
End;

Function cwbSY_SetSys(securityHandle: cwbSY_SecurityHandle; systemName: LPCSTR; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var Func: Function (securityHandle: cwbSY_SecurityHandle; systemName: LPCSTR): cwb_Result StdCall;
Begin If cwbInvalid(icwbSY_SetSys, Func) Then Result:= CWB_INVALID_FUNCTION Else Result:= Func(securityHandle,systemName);
  Result:= cwbCheck(icwbSY_SetSys, Result, Handler, ReturnAddr)
End;

{.Implementation ca400procs end}

Function cwbIsCallable (Index: Integer): Boolean;
Begin
  Result:= (Index>=Low(CallTable)) And (Index<=High(CallTable))
     And (CallTable[Index].Proc<>Nil)
End;

Procedure Bind;
Var
  i: Integer;
Begin
  BindError:= False;
  FillChar(DllHandles, SizeOf(DllHandles), 0);
  For i:= Low(CallTable) To High(CallTable) Do
  With CallTable[i] Do Begin
    If DllHandles[DllIndex]=0 Then Begin
      DllHandles[DllIndex]:= LoadLibrary(DllNames[DllIndex]);
      If DllHandles[DllIndex]=0 Then Begin
        If Options And 1=0 Then
          BindError:= True;
        Continue
      End
    End;
    TFarProc(Proc):= GetProcAddress(DllHandles[DllIndex], Name);
    If Proc=Nil Then
      If Options And 1=0 Then
        BindError:= True; // failed to load a vital function
  End
End;

Procedure UnBind;
Var
  i: Integer;
Begin
  For i:= Low(CallTable) To High(CallTable) Do
  With CallTable[i] Do
    If DllHandles[DllIndex]<>0 Then Begin
      FreeLibrary(DllHandles[DllIndex]);
      DllHandles[DllIndex]:= 0
    End
End;

Function BindErrors: String;
Var
  i: Integer;

  Procedure Add(Const Value: String);
  Begin
    If Result='' Then
      Result:= Value
    Else
      Result:= Result+','+Value
  End;

Begin
  Result:= '';
  For i:= Low(DllHandles) To High(DllHandles) Do
    If DllHandles[i]=0 Then
      Add(DllNames[i]+' not found');
  For i:= Low(CallTable) To High(CallTable) Do
    With CallTable[i] Do
      If Proc=Nil Then
        If Options And 1=0 Then
          Add(Name+' missing')
End;

Type
  TSimpleConversionTable = Array[Char] Of Char;
  PSimpleConversionTable = ^TSimpleConversionTable;
  TConversionEntry = Record
    SrcCP, DstCP: Cardinal;
    Table: PSimpleConversionTable;
    Converter: cwbNL_Converter;
  End;
Var
  ECIs: Array Of TConversionEntry; // Ebcdic Conversion Informations

Function GetAddConversion (SrcCP, DstCP: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): Integer;
Var
  i: Integer;
  TempConverter: cwbNL_Converter;
  InChar: Char;
  Errors, PosOfError, requLen: Cardinal;
  CT: PSimpleConversionTable;
  DoSimple: Boolean;
Begin
  For i:= Low(ECIs) To High(ECIs) Do
    If (ECIs[i].SrcCP=SrcCP) And (ECIs[i].DstCP=DstCP) Then Begin
      Result:= i;
      Exit
    End;

  SetLength(ECIs, Length(ECIs)+1);
  Result:= High(ECIs);
  ECIs[Result].SrcCP:= SrcCP;
  ECIs[Result].DstCP:= DstCP;

  DoSimple:= False;
  Case SrcCP Of 1250, 1252, 850, 037,273,277,278,280,284,285,297,500,871,1140..1149:
  Case DstCP Of 1250, 1252, 850, 037,273,277,278,280,284,285,297,500,871,1140..1149: DoSimple:= True; End
  End;

  If DoSimple Then Begin
    ECIs[Result].Converter:= 0;
    ECIs[Result].Table:= AllocMem(256);

    CT:= ECIs[Result].Table;
    cwbNL_CreateConverter(SrcCP, DstCP, TempConverter, errorHandle, 0, 0, Nil {pad}, Handler);
    For InChar:= #0 To #255 Do
      cwbNL_Convert(TempConverter, 1, 1, @InChar, @CT[InChar], Errors, PosOfError, requLen, errorHandle, Handler);
    cwbNL_DeleteConverter(TempConverter, errorHandle, Handler);
  End Else Begin
    ECIs[Result].Table:= Nil;
    cwbNL_CreateConverter(SrcCP, DstCP, ECIs[Result].Converter, errorHandle, 1, 0, Nil {pad}, Handler);
  End
End;

Procedure InitConversion;
begin
  SetLength(ECIs, 0);
  GetAddConversion(  37, 1252);
  GetAddConversion(1252,   37);
  GetAddConversion( 273, 1252);
  GetAddConversion(1252,  273);
  GetAddConversion(1141, 1252);
  GetAddConversion(1252, 1141);
end;

// converts but does not add a terminating #0 !!!
Function ConvertCP (LenSrc: Integer; Src: PChar; LenDst: Integer; Dst: PChar; SrcCP, DstCP: Cardinal; Var Count: Cardinal;  errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var
  i: Integer;
  CI: Integer;
  CT: PSimpleConversionTable;
  Errors, PosOfError: Cardinal;
Begin
  CI:= GetAddConversion(SrcCP, DstCP, errorHandle, Handler);
  CT:= ECIs[CI].Table;
  If CT<>Nil Then Begin
    If LenDst<LenSrc Then Count:= LenDst Else Count:= LenSrc;
    For i:= 0 To Count-1 Do
      Dst[i]:= CT[Src[i]];
    Result:= CWB_OK
  End Else
    Result:= cwbNL_Convert(ECIs[CI].Converter, LenSrc, LenDst, Src, Dst, Errors, PosOfError, Count, errorHandle, Handler)
End;

Function ConvertCPStr (Const Value: String; Var Dst: String; SrcCP, DstCP: Cardinal; errorHandle: cwbSV_ErrHandle = 0; Handler: TCustomcwbErrorHandler=Nil): cwb_Result;
Var
  Count: Cardinal;
Begin
  SetLength(Dst, Length(Value)*2);
  Result:= ConvertCP(Length(Value), PChar(Value), Length(Value)*2, PChar(Dst), SrcCP, DstCP, Count, errorHandle, Handler);
  If Result=CWB_OK Then
    SetLength(Dst, Count)
End;


{ TCustomcwbErrorHandler }

Function TCustomcwbErrorHandler.Check (Index: Integer; Value: cwb_Result; Where: Pointer = Nil): cwb_Result;
Begin
  Result:= Value;
  If IsSerious(Index, Value) Then Begin
    If Where=Nil Then
      Raise EcwbError.Create(returnErrTexts(Value, CallTable[Index].Name), Value, Index)
    Else
      Raise EcwbError.Create(returnErrTexts(Value, CallTable[Index].Name), Value, Index) At Where
  End
End;

{ TcwbErrorHandler }

Constructor TcwbErrorHandler.Create ;
Begin
  Inherited Create;
  cwbSV_CreateErrHandle(FerrHandle, Self);
End;

Destructor TcwbErrorHandler.Destroy;
Begin
  If errHandle<>0 Then Begin
    cwbSV_DeleteErrHandle(errHandle);
    errHandle:= 0
  End;
  Inherited Destroy
End;

Function TcwbErrorHandler.IsSerious (Index: Integer; Value: cwb_Result): Boolean;
Begin
  Result:= True;
  {Case Index Of
    i...: Result:= Value=...;
  End;}
End;

Function TcwbErrorHandler.returnErrTexts(Value: cwb_Result; Context: String = ''): String;
Var
  Buffer: Array[0..1024] Of Char;
  errCount, i, Len: Cardinal;
  rc: cwb_Result;
Begin
  If Context<>'' Then
    Result:= Format('%s returned error code %d.'#13, [Context, Value])
  Else
    Result:= '';

  Buffer[High(Buffer)]:= #0;
  cwbSV_GetErrCount(errHandle, errCount);
  For i:= 1 To errCount Do Begin
    rc:= cwbSV_GetErrTextIndexed(errHandle, i, Buffer, SizeOf(Buffer)-1, Len);
    If (rc=CWB_OK) Or (rc=CWB_BUFFER_OVERFLOW) Then
      Result:= Format('%s'#13'%s', [Result, Buffer])
  End
End;

{ TcwbDBErrorHandler }

Constructor TcwbDBErrorHandler.Create (ARequestHandle: cwbDB_RequestHandle = 0);
Begin
  Inherited Create;
  FRequestHandle:= ARequestHandle;
  cwbDB_CreateDataHandle(FhostMsgID, errHandle, Self);
  cwbDB_CreateDataHandle(FfirstLevelMessage, errHandle, Self);
  cwbDB_CreateDataHandle(FsecondLevelMessage, errHandle, Self);
End;

Destructor TcwbDBErrorHandler.Destroy;
Begin
  FRequestHandle:= 0;
  If hostMsgId<>0 Then Begin
    cwbDB_DeleteDataHandle(hostMsgID, errHandle);
    hostMsgID:= 0
  End;
  If firstLevelMessage<>0 Then Begin
    cwbDB_DeleteDataHandle(firstLevelMessage, errHandle);
    firstLevelMessage:= 0
  End;
  If secondLevelMessage<>0 Then Begin
    cwbDB_DeleteDataHandle(secondLevelMessage, errHandle);
    secondLevelMessage:= 0
  End;
  Inherited Destroy
End;

Function TcwbDBErrorHandler.IsSerious (Index: Integer; Value: cwb_Result): Boolean;
Begin
  Result:= Inherited IsSerious(Index, Value);
  Case Index Of
    icwbDB_StartServer: Result:= Value=CWBDB_CANNOT_CONTACT_SERVER;
    icwbDB_Fetch: Result:= (Value<>CWBDB_SQL_PARAMETER_WARNING) And (Value<>CWBDB_SQL_WARNING);
  Else
    Case Value Of
      CWBDB_SQL_WARNING,
      CWBDB_SQL_PARAMETER_WARNING,
      CWBDB_LIST_SERVER_WARNING,
      CWBDB_LIST_PARAMETER_WARNING,
      CWBDB_NDB_FILE_SERVER_WARNING,
      CWBDB_FILE_PARAMETER_WARNING,
      CWBDB_GENERAL_SERVER_WARNING,
      CWBDB_EXIT_PROGRAM_WARNING: Result:= False
    End
  End
End;

Function TcwbDBErrorHandler.returnErrTexts(Value: cwb_Result; Context: String = ''): String;
Var
  textPtr: PChar;
  textLen: Cardinal;

  Function StrN (Value: PChar; Count: Integer): String;
  Begin
    SetLength(Result, Count);
    StrLCopy(PChar(Result), Value, Count)
  End;

Begin
  Result:= Inherited returnErrTexts(Value, Context);
  If Value>CWBDB_DATASTREAM_TOO_SHORT Then Begin
    If FRequestHandle<>0 Then Begin
      FhostErrorClass:=0;
      FhostErrorCode:= 0;
      cwbDB_ReturnHostErrorInfo(FrequestHandle, FhostErrorClass, FhostErrorCode, hostMsgID, firstLevelMessage, secondLevelMessage, errHandle);
      cwbDB_GetData(FrequestHandle, errHandle)
    End;
    Result:= Format('%s'#13'Server error class %d code %d'#13,
             [Result, hostErrorClass, hostErrorCode]);
    cwbDB_GetDataPointer(hostMsgID, Pointer(textPtr), errHandle);
    cwbDB_GetDataLength(hostMsgID, textLen, errHandle);
    If textLen>0 Then
      Result:= Format('%s'#13'Message id: %s', [Result, StrN(textPtr, textLen)]);
    cwbDB_GetDataPointer(firstLevelMessage, Pointer(textPtr), errHandle);
    cwbDB_GetDataLength(firstLevelMessage, textLen, errHandle);
    If textLen>0 Then
      Result:= Format('%s'#13'%s', [Result, StrN(textPtr, textLen)]);
    cwbDB_GetDataPointer(secondLevelMessage, Pointer(textPtr), errHandle);
    cwbDB_GetDataLength(secondLevelMessage, textLen, errHandle);
    If textLen>0 Then
      Result:= Format('%s'#13'%s', [Result, StrN(textPtr, textLen)]);
  End
End;

{ TcwbSOErrorHandler }

Constructor TcwbSOErrorHandler.Create ;
Begin
  Inherited Create;
  cwbSO_CreateErrorHandle(FerrHandle, Self);
End;

Destructor TcwbSOErrorHandler.Destroy;
Begin
  If errHandle<>0 Then Begin
    cwbSO_DeleteErrorHandle(errHandle);
    errHandle:= 0
  End;
  Inherited Destroy
End;

Function TcwbSOErrorHandler.IsSerious (Index: Integer; Value: cwb_Result): Boolean;
Begin
  Result:= True;
  {Case Index Of
    i...: Result:= Value=...;
  End;}
End;

Function TcwbSOErrorHandler.returnErrTexts(Value: cwb_Result; Context: String = ''): String;
Var
  Buffer: Array[0..1024] Of Char;
  bytesNeeded: Cardinal;
Begin
  If Context<>'' Then
    Result:= Format('%s returned error code %d.'#13, [Context, Value])
  Else
    Result:= '';
  If Value=CWBSO_ERROR_OCCURRED Then Begin
    If cwbSO_GetErrMsgText(errHandle, Buffer, SizeOf(Buffer), bytesNeeded)=CWB_OK Then
      Result:= Format('%s'#13'%s', [Result, Buffer])
  End
End;

{ EcwbError }

Constructor EcwbError.Create(ANativeError: String; AErrorCode: cwb_Result; AFuncIndex: Integer);
Begin
  Inherited Create(ANativeError);
  FErrorCode:= AErrorCode;
  FFuncIndex:= AFuncIndex;
End;

Var
  FcwbVersion: Cardinal = 0;
  FcwbRelease: Cardinal = 0;
  FcwbModificationLevel: Cardinal = 0;

Procedure GetReleaseLevel;
Begin
  If FcwbVersion<>0 Then
    Exit;
  If cwbAD_GetClientVersion(FcwbVersion, FcwbRelease, FcwbModificationLevel)<>CWB_OK Then Begin
    FcwbVersion:= 3;
    FcwbRelease:= 2;
    FcwbModificationLevel:= 0;
  End
End;

Function cwbReleaseStr: String;
Var
  fixLevel: Array[0..100] Of Char;
  fixLen: Cardinal;
Begin
  GetReleaseLevel;
  fixlevel[0]:= #0;
  fixLen:= SizeOf(fixLevel)-1;
  cwbAD_GetProductFixLevel(fixLevel, fixLen);
  Result:= Format('V%dR%dM%d %s', [FcwbVersion, FcwbRelease, FcwbModificationLevel, fixLevel])
End;

Function cwbRelease: Integer;
Begin
  GetReleaseLevel;
  Result:= FcwbVersion*100+FcwbRelease*10+FcwbModificationLevel
End;

Var
  DebugCallBack: TDebugCallBack;

Function cwbCheck (Index: Integer; Value: cwb_Result; Handler: TCustomcwbErrorHandler; Where: Pointer = Nil): cwb_Result;
Begin
  Result:= Value;
  if Value=CWB_OK Then
    Exit;
  If Assigned(DebugCallBack) Then
    DebugCallBack(Format('%s returned %d', [CallTable[Index].Name, Value]));
  If Handler<>Nil Then
    Result:= Handler.Check(Index, Value, Where)
End;

Function cwbInvalid (Index: Integer; Var Func): Boolean;
Begin
  TFarProc(Func):= CallTable[Index].Proc;
  Result:= TFarProc(Func)=Nil;
  If Assigned(DebugCallBack) Then
    If Result Then
      DebugCallBack(Format('%s not available', [CallTable[Index].Name]))
    Else
      DebugCallBack(Format('calling %s', [CallTable[Index].Name]))
End;

Procedure RegisterDebug (Value: TDebugCallBack);
Begin
  DebugCallBack:= Value;
End;

Procedure UnRegisterDebug (Value: TDebugCallBack);
Begin
  DebugCallBack:= Nil
End;

Initialization
Begin
  Bind;
  InitConversion;
End;

Finalization
Begin
  UnBind
End;

End.
